/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.administrativeOffice.externalUnits;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitUtils;
import org.fenixedu.academic.dto.LinkObject;

public abstract class AbstractExternalUnitResultBean
implements Serializable {
    protected static final transient List<AccountabilityTypeEnum> ACCOUNTABILITY_TYPES = Arrays.asList(AccountabilityTypeEnum.GEOGRAPHIC, AccountabilityTypeEnum.ORGANIZATIONAL_STRUCTURE, AccountabilityTypeEnum.ACADEMIC_STRUCTURE);
    private PartyTypeEnum parentUnitType;
    private String fullName;

    public PartyTypeEnum getParentUnitType() {
        return this.parentUnitType;
    }

    public void setParentUnitType(PartyTypeEnum parentUnitType) {
        this.parentUnitType = parentUnitType;
    }

    private boolean hasParentUnitType() {
        return this.getParentUnitType() != null;
    }

    protected List<Unit> searchFullPath() {
        List<Unit> units = UnitUtils.getUnitFullPath(this.getUnit(), ACCOUNTABILITY_TYPES);
        if (this.hasParentUnitType()) {
            this.removeAllUnitsUntilParentUnitType(units);
        }
        return units;
    }

    private void removeAllUnitsUntilParentUnitType(List<Unit> units) {
        Iterator<Unit> iterUnits = units.iterator();
        while (iterUnits.hasNext()) {
            if (iterUnits.next().getType() == this.getParentUnitType()) {
                iterUnits.remove();
                break;
            }
            iterUnits.remove();
        }
    }

    public String getNumberOfUniversities() {
        return "-";
    }

    public String getNumberOfSchools() {
        return "-";
    }

    public String getNumberOfDepartments() {
        return "-";
    }

    public String getNumberOfExternalCurricularCourses() {
        return "-";
    }

    public String getFullName() {
        if (this.fullName == null) {
            StringBuilder unitFullPathName = UnitUtils.getUnitFullPathName(this.getUnit(), ACCOUNTABILITY_TYPES);
            this.setFullName(unitFullPathName.toString() + " > " + this.getName());
        }
        return this.fullName;
    }

    protected void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public abstract Unit getUnit();

    public abstract Enum getType();

    public abstract List<LinkObject> getFullPath();

    public abstract String getName();
}

