/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.Comparator;
import java.util.Date;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.dto.InfoExecutionYear;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.util.PeriodState;
import pt.ist.fenixframework.DomainObject;

public class InfoExecutionPeriod
extends InfoObject
implements Comparable {
    public static final Comparator<InfoExecutionPeriod> COMPARATOR_BY_YEAR_AND_SEMESTER = new Comparator<InfoExecutionPeriod>(){

        @Override
        public int compare(InfoExecutionPeriod o1, InfoExecutionPeriod o2) {
            int c = o2.getInfoExecutionYear().getYear().compareTo(o1.getInfoExecutionYear().getYear());
            return c == 0 ? o2.getSemester().compareTo(o1.getSemester()) : c;
        }
    };
    private ExecutionSemester executionPeriodDomainReference;
    private String qualifiedName;
    private InfoExecutionYear infoExecutionYear = null;

    public InfoExecutionPeriod(ExecutionSemester executionSemester) {
        this.executionPeriodDomainReference = executionSemester;
    }

    public InfoExecutionYear getInfoExecutionYear() {
        if (this.infoExecutionYear == null) {
            this.infoExecutionYear = new InfoExecutionYear(this.getExecutionPeriod().getExecutionYear());
        }
        return this.infoExecutionYear;
    }

    public String getName() {
        return this.getExecutionPeriod().getName();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof InfoExecutionPeriod) {
            InfoExecutionPeriod infoExecutionPeriod = (InfoExecutionPeriod)obj;
            return this.getInfoExecutionYear().equals(infoExecutionPeriod.getInfoExecutionYear()) && this.getName().equals(infoExecutionPeriod.getName());
        }
        return false;
    }

    public String toString() {
        return this.getExecutionPeriod().toString();
    }

    public PeriodState getState() {
        return this.getExecutionPeriod().getState();
    }

    public Integer getSemester() {
        return this.getExecutionPeriod().getSemester();
    }

    public int compareTo(Object arg0) {
        InfoExecutionPeriod infoExecutionPeriod = (InfoExecutionPeriod)arg0;
        int yearCmp = this.getInfoExecutionYear().compareTo(infoExecutionPeriod.getInfoExecutionYear());
        if (yearCmp != 0) {
            return yearCmp;
        }
        return this.getSemester() - infoExecutionPeriod.getSemester();
    }

    public Date getBeginDate() {
        return this.getExecutionPeriod().getBeginDate();
    }

    public Date getEndDate() {
        return this.getExecutionPeriod().getEndDate();
    }

    public String getDescription() {
        StringBuilder buffer = new StringBuilder();
        if (this.getName() != null) {
            buffer.append(this.getName());
        }
        if (this.getInfoExecutionYear() != null) {
            buffer.append(" - ").append(this.getInfoExecutionYear().getYear());
        }
        return buffer.toString();
    }

    public InfoExecutionPeriod getPreviousInfoExecutionPeriod() {
        ExecutionSemester previousInfoExecutionPeriod = this.getExecutionPeriod().getPreviousExecutionPeriod();
        return previousInfoExecutionPeriod == null ? null : new InfoExecutionPeriod(previousInfoExecutionPeriod);
    }

    public static InfoExecutionPeriod newInfoFromDomain(ExecutionSemester executionSemester) {
        return executionSemester == null ? null : new InfoExecutionPeriod(executionSemester);
    }

    public String getQualifiedName() {
        return this.getDescription();
    }

    @Override
    public void copyFromDomain(DomainObject domainObject) {
        throw new Error("Method should not be called!");
    }

    @Override
    public String getExternalId() {
        return this.getExecutionPeriod().getExternalId();
    }

    @Override
    public void setExternalId(String integer) {
        throw new Error("Method should not be called!");
    }

    public ExecutionSemester getExecutionPeriod() {
        return this.executionPeriodDomainReference;
    }

    public void setExecutionPeriod(ExecutionSemester executionSemester) {
        this.executionPeriodDomainReference = executionSemester;
    }
}

