/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reports;

import java.util.Collections;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.reports.GraduationReportFile_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcess;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.joda.time.LocalDate;

public class GraduationReportFile
extends GraduationReportFile_Base {
    public String getJobName() {
        return "Listagem de diplomados";
    }

    protected String getPrefix() {
        return "diplomados";
    }

    public void renderReport(Spreadsheet spreadsheet) {
        spreadsheet.setHeader("n\u00famero aluno");
        spreadsheet.setHeader("nome");
        this.setDegreeHeaders(spreadsheet);
        spreadsheet.setHeader("ciclo");
        spreadsheet.setHeader("Nota Conclus\u00e3o Secund\u00e1rio");
        spreadsheet.setHeader("Nota Seria\u00e7\u00e3o");
        spreadsheet.setHeader("ano de ingresso");
        spreadsheet.setHeader("ano lectivo conclus\u00e3o");
        spreadsheet.setHeader("data conclus\u00e3o");
        spreadsheet.setHeader("n\u00famero de anos para conclus\u00e3o");
        spreadsheet.setHeader("m\u00e9dia final");
        spreadsheet.setHeader("morada");
        spreadsheet.setHeader("c\u00f3digo postal");
        spreadsheet.setHeader("cidade");
        spreadsheet.setHeader("pa\u00eds");
        spreadsheet.setHeader("telefone");
        spreadsheet.setHeader("telemovel");
        spreadsheet.setHeader("email");
        spreadsheet.setHeader("sexo");
        spreadsheet.setHeader("data nascimento");
        Set<ExecutionYear> toInspectSet = this.getExecutionYear() == null ? this.getRootDomainObject().getExecutionYearsSet() : Collections.singleton(this.getExecutionYear());
        for (ExecutionYear toInspect : toInspectSet) {
            for (ConclusionProcess conclusionProcess : toInspect.getConclusionProcessesConcludedSet()) {
                if (!this.checkDegreeType(this.getDegreeType(), conclusionProcess)) continue;
                this.reportGraduate(spreadsheet, conclusionProcess);
            }
        }
    }

    private void reportGraduate(Spreadsheet sheet, ConclusionProcess conclusionProcess) {
        Spreadsheet.Row row = sheet.addRow();
        Registration registration = conclusionProcess.getRegistration();
        ExecutionYear ingression = conclusionProcess.getIngressionYear();
        ExecutionYear conclusion = conclusionProcess.getConclusionYear();
        LocalDate conclusionDate = conclusionProcess.getConclusionDate();
        row.setCell(registration.getNumber());
        row.setCell(registration.getName());
        this.setDegreeCells(row, registration.getDegree());
        row.setCell(conclusionProcess.getName().getContent());
        row.setCell(registration.getPrecedentDegreeConclusionGrade(SchoolLevelType.SECOND_CYCLE_BASIC_SCHOOL));
        row.setCell(registration.getEntryGrade() != null ? registration.getEntryGrade().toString() : "");
        row.setCell(ingression.getYear());
        row.setCell(conclusion == null ? "" : conclusion.getYear());
        row.setCell(conclusionDate == null ? "" : conclusionDate.toString("yyyy-MM-dd"));
        row.setCell(conclusion == null ? "" : String.valueOf(ingression.getDistanceInCivilYears(conclusion) + 1));
        row.setCell(conclusionProcess.getFinalGrade().getValue());
        this.setPersonCells(registration, row);
    }

    private void setPersonCells(Registration registration, Spreadsheet.Row row) {
        Person person = registration.getPerson();
        PhysicalAddress defaultPhysicalAddress = person.getDefaultPhysicalAddress();
        if (defaultPhysicalAddress != null) {
            row.setCell(defaultPhysicalAddress.getAddress());
            row.setCell(defaultPhysicalAddress.getPostalCode());
            row.setCell(defaultPhysicalAddress.getArea());
            row.setCell(defaultPhysicalAddress.getCountryOfResidence() == null ? "" : defaultPhysicalAddress.getCountryOfResidence().getName());
        } else {
            row.setCell("");
            row.setCell("");
            row.setCell("");
            row.setCell("");
        }
        row.setCell(person.getDefaultPhoneNumber());
        row.setCell(person.getDefaultMobilePhoneNumber());
        row.setCell(person.getInstitutionalOrDefaultEmailAddressValue());
        row.setCell(person.getGender().toLocalizedString());
        row.setCell(person.getDateOfBirthYearMonthDay() != null ? person.getDateOfBirthYearMonthDay().toString("yyyy-MM-dd") : "");
    }
}

