/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.candidacy.feedbackRequest;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.fenixedu.academic.domain.phd.PhdProcessStateType;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public enum PhdCandidacyFeedbackStateType implements PhdProcessStateType
{
    NEW,
    WAITING_FOR_FEEDBACK,
    CONCLUDED;


    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getLocalizedName() {
        return this.getLocalizedName(I18N.getLocale());
    }

    @Override
    public String getLocalizedName(Locale locale) {
        return BundleUtil.getString((String)"resources.PhdResources", (Locale)locale, (String)this.getQualifiedName(), (String[])new String[0]);
    }

    private String getQualifiedName() {
        return this.getClass().getSimpleName() + "." + this.name();
    }

    public static List<PhdCandidacyFeedbackStateType> getPossibleNextStates(PhdCandidacyFeedbackStateType type) {
        if (type == null) {
            return Collections.singletonList(NEW);
        }
        switch (type) {
            case NEW: {
                return Collections.singletonList(WAITING_FOR_FEEDBACK);
            }
            case WAITING_FOR_FEEDBACK: {
                return Collections.singletonList(CONCLUDED);
            }
        }
        return Collections.EMPTY_LIST;
    }
}

