/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformation;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Accountability;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType;
import org.fenixedu.academic.domain.organizationalStructure.CompetenceCourseGroupUnit_Base;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.ScientificAreaUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitClassification;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.YearMonthDay;

public class CompetenceCourseGroupUnit
extends CompetenceCourseGroupUnit_Base {
    private CompetenceCourseGroupUnit() {
        super.setType(PartyTypeEnum.COMPETENCE_COURSE_GROUP);
    }

    public static Unit createNewInternalCompetenceCourseGroupUnit(MultiLanguageString name, String unitNameCard, Integer costCenterCode, String acronym, YearMonthDay beginDate, YearMonthDay endDate, Unit parentUnit, AccountabilityType accountabilityType, String webAddress, UnitClassification classification, Boolean canBeResponsibleOfSpaces, Space campus) {
        CompetenceCourseGroupUnit competenceCourseGroupUnit = new CompetenceCourseGroupUnit();
        competenceCourseGroupUnit.init(name, unitNameCard, costCenterCode, acronym, beginDate, endDate, webAddress, classification, null, canBeResponsibleOfSpaces, campus);
        competenceCourseGroupUnit.addParentUnit(parentUnit, accountabilityType);
        CompetenceCourseGroupUnit.checkIfAlreadyExistsOneCompetenceCourseGroupUnitWithSameAcronymAndName(competenceCourseGroupUnit);
        return competenceCourseGroupUnit;
    }

    public void edit(MultiLanguageString unitName, String unitNameCard, Integer unitCostCenter, String acronym, YearMonthDay beginDate, YearMonthDay endDate, String webAddress, UnitClassification classification, Department department, Degree degree, AdministrativeOffice administrativeOffice, Boolean canBeResponsibleOfSpaces, Space campus) {
        super.edit(unitName, unitNameCard, unitCostCenter, acronym, beginDate, endDate, webAddress, classification, department, degree, administrativeOffice, canBeResponsibleOfSpaces, campus);
        CompetenceCourseGroupUnit.checkIfAlreadyExistsOneCompetenceCourseGroupUnitWithSameAcronymAndName(this);
    }

    public Accountability addParentUnit(Unit parentUnit, AccountabilityType accountabilityType) {
        if (!(parentUnit == null || parentUnit.isInternal() && parentUnit.isScientificAreaUnit())) {
            throw new DomainException("error.unit.invalid.parentUnit", new String[0]);
        }
        return super.addParentUnit(parentUnit, accountabilityType);
    }

    public boolean isCompetenceCourseGroupUnit() {
        return true;
    }

    public boolean hasCompetenceCourses(CompetenceCourse competenceCourse) {
        return competenceCourse.getCompetenceCourseGroupUnit().equals((Object)this);
    }

    public ScientificAreaUnit getScientificAreaUnit() {
        if (this.hasAnyParentUnits()) {
            if (this.getParentUnits().size() > 1) {
                throw new DomainException("competence.course.group.should.have.only.one.scientific.area", new String[0]);
            }
            return (ScientificAreaUnit)((Object)this.getParentUnits().iterator().next());
        }
        return null;
    }

    public DepartmentUnit getDepartmentUnit() {
        ScientificAreaUnit area = this.getScientificAreaUnit();
        if (area.hasAnyParentUnits()) {
            if (area.getParentUnits().size() > 1) {
                throw new DomainException("scientific.area.should.have.only.one.department", new String[0]);
            }
            return (DepartmentUnit)((Object)area.getParentUnits().iterator().next());
        }
        return null;
    }

    public Set<CompetenceCourse> getCompetenceCoursesSet() {
        TreeSet<CompetenceCourse> result = new TreeSet<CompetenceCourse>(CompetenceCourse.COMPETENCE_COURSE_COMPARATOR_BY_NAME);
        for (CompetenceCourseInformation competenceInformation : this.getCompetenceCourseInformationsSet()) {
            if (competenceInformation.getCompetenceCourse().getCompetenceCourseGroupUnit() != this) continue;
            result.add(competenceInformation.getCompetenceCourse());
        }
        return result;
    }

    public List<CompetenceCourse> getCompetenceCourses() {
        return new ArrayList<CompetenceCourse>(this.getCompetenceCoursesSet());
    }

    public List<CompetenceCourse> getCurrentOrFutureCompetenceCourses() {
        TreeSet<CompetenceCourse> result = new TreeSet<CompetenceCourse>(CompetenceCourse.COMPETENCE_COURSE_COMPARATOR_BY_NAME);
        for (CompetenceCourseInformation competenceInformation : this.getCompetenceCourseInformationsSet()) {
            if (competenceInformation.getCompetenceCourse().getCompetenceCourseGroupUnit() == this) {
                result.add(competenceInformation.getCompetenceCourse());
            }
            if (competenceInformation.getCompetenceCourse().getCompetenceCourseGroupUnit(ExecutionSemester.readLastExecutionSemester()) != this) continue;
            result.add(competenceInformation.getCompetenceCourse());
        }
        return new ArrayList<CompetenceCourse>(result);
    }

    public List<CompetenceCourse> getOldCompetenceCourses() {
        TreeSet<CompetenceCourse> result = new TreeSet<CompetenceCourse>(CompetenceCourse.COMPETENCE_COURSE_COMPARATOR_BY_NAME);
        for (CompetenceCourseInformation competenceInformation : this.getCompetenceCourseInformationsSet()) {
            CompetenceCourse course = competenceInformation.getCompetenceCourse();
            if (course.getDepartmentUnit() == this.getDepartmentUnit() || course.getMostRecentGroupInDepartment(this.getDepartmentUnit()) != this) continue;
            result.add(competenceInformation.getCompetenceCourse());
        }
        return new ArrayList<CompetenceCourse>(result);
    }

    public void setType(PartyTypeEnum partyTypeEnum) {
        throw new DomainException("unit.impossible.set.type", new String[0]);
    }

    public List<CurricularCourse> getCurricularCourses() {
        List<CompetenceCourse> competenceCourses = this.getCompetenceCourses();
        ArrayList<CurricularCourse> curricularCourses = new ArrayList<CurricularCourse>();
        for (CompetenceCourse competenceCourse : competenceCourses) {
            curricularCourses.addAll(competenceCourse.getAssociatedCurricularCoursesSet());
        }
        return curricularCourses;
    }

    public List<CompetenceCourse> getCompetenceCoursesByExecutionYear(ExecutionYear executionYear) {
        List<CompetenceCourse> competenceCourses = this.getCompetenceCourses();
        ArrayList<CompetenceCourse> competenceCoursesByExecutionYear = new ArrayList<CompetenceCourse>();
        for (CompetenceCourse competenceCourse : competenceCourses) {
            if (!competenceCourse.hasActiveScopesInExecutionYear(executionYear).booleanValue()) continue;
            competenceCoursesByExecutionYear.add(competenceCourse);
        }
        return competenceCoursesByExecutionYear;
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getCompetenceCourseInformationsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.unit.cannot.be.deleted", (String[])new String[0]));
        }
    }

    private static void checkIfAlreadyExistsOneCompetenceCourseGroupUnitWithSameAcronymAndName(CompetenceCourseGroupUnit competenceCourseGroupUnit) {
        for (Unit parentUnit : competenceCourseGroupUnit.getParentUnits()) {
            for (Unit unit : parentUnit.getAllSubUnits()) {
                if (unit.equals((Object)competenceCourseGroupUnit) || !competenceCourseGroupUnit.getName().equalsIgnoreCase(unit.getName())) continue;
                throw new DomainException("error.unit.already.exists.unit.with.same.name.or.acronym", new String[0]);
            }
        }
    }
}

