/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.mobility.outbound;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityAgreement;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityProgram;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacy;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContest;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContestGroup;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriod$callable$addOption;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriod$callable$create;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriod$callable$createOutboundMobilityCandidacyContest;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriod$callable$createOutboundMobilityCandidacyContest$1;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriod$callable$delete;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriod$callable$selectCandidatesForAllGroups;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriod$callable$setOptionIntroductoryDestriptionService;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriodConfirmationOption;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriod_Base;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacySubmission;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacySubmissionGrade;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.period.CandidacyPeriod;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class OutboundMobilityCandidacyPeriod
extends OutboundMobilityCandidacyPeriod_Base
implements Comparable<CandidacyPeriod> {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createOutboundMobilityCandidacyContest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createOutboundMobilityCandidacyContest$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$setOptionIntroductoryDestriptionService = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$addOption = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$selectCandidatesForAllGroups = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public OutboundMobilityCandidacyPeriod(ExecutionInterval executionInterval, DateTime start, DateTime end) {
        this.init(executionInterval, start, end);
        OutboundMobilityCandidacyPeriod previousPeriod = this.findPreviousPeriod();
        for (OutboundMobilityCandidacyContestGroup group : previousPeriod.getOutboundMobilityCandidacyContestGroupSet()) {
            if (group.getExecutionDegreeSet().isEmpty()) continue;
            OutboundMobilityCandidacyContestGroup newGroup = new OutboundMobilityCandidacyContestGroup(group.getExecutionDegreeSet());
            for (OutboundMobilityCandidacyContest contest : group.getOutboundMobilityCandidacyContestSet()) {
                OutboundMobilityCandidacyContest newContest = new OutboundMobilityCandidacyContest(this, newGroup, contest.getMobilityAgreement(), contest.getVacancies());
                newGroup.getOutboundMobilityCandidacyContestSet().add(newContest);
            }
            newGroup.getMobilityCoordinatorSet().addAll(group.getMobilityCoordinatorSet());
        }
        for (OutboundMobilityCandidacyContest contest : previousPeriod.getOutboundMobilityCandidacyContestSet()) {
            contest.getExecutionDegreeSet();
            contest.getMobilityAgreement();
            contest.getOutboundMobilityCandidacyContestGroup();
            contest.getVacancies();
        }
    }

    public static OutboundMobilityCandidacyPeriod create(ExecutionInterval executionInterval, DateTime dateTime, DateTime dateTime2) {
        return (OutboundMobilityCandidacyPeriod)advice$create.perform((Callable)new OutboundMobilityCandidacyPeriod$callable$create(executionInterval, dateTime, dateTime2));
    }

    static /* synthetic */ OutboundMobilityCandidacyPeriod advised$create(ExecutionInterval executionInterval, DateTime start, DateTime end) {
        return new OutboundMobilityCandidacyPeriod(executionInterval, start, end);
    }

    public OutboundMobilityCandidacyContest createOutboundMobilityCandidacyContest(ExecutionDegree executionDegree, MobilityProgram mobilityProgram, UniversityUnit universityUnit, Integer n) {
        return (OutboundMobilityCandidacyContest)advice$createOutboundMobilityCandidacyContest.perform((Callable)new OutboundMobilityCandidacyPeriod$callable$createOutboundMobilityCandidacyContest(this, executionDegree, mobilityProgram, universityUnit, n));
    }

    static /* synthetic */ OutboundMobilityCandidacyContest advised$createOutboundMobilityCandidacyContest(OutboundMobilityCandidacyPeriod this_, ExecutionDegree executionDegree, MobilityProgram mobilityProgram, UniversityUnit unit, Integer vacancies) {
        MobilityAgreement mobilityAgreement = this_.findOrCreateMobilityAgreement(mobilityProgram, unit);
        OutboundMobilityCandidacyContestGroup mobilityGroup = OutboundMobilityCandidacyContestGroup.findOrCreateGroup(executionDegree);
        OutboundMobilityCandidacyContest contest = new OutboundMobilityCandidacyContest(this_, mobilityGroup, mobilityAgreement, vacancies);
        mobilityGroup.getOutboundMobilityCandidacyContestSet().size();
        return contest;
    }

    public OutboundMobilityCandidacyContest createOutboundMobilityCandidacyContest(OutboundMobilityCandidacyContestGroup outboundMobilityCandidacyContestGroup, MobilityProgram mobilityProgram, UniversityUnit universityUnit, Integer n) {
        return (OutboundMobilityCandidacyContest)advice$createOutboundMobilityCandidacyContest$1.perform((Callable)new OutboundMobilityCandidacyPeriod$callable$createOutboundMobilityCandidacyContest$1(this, outboundMobilityCandidacyContestGroup, mobilityProgram, universityUnit, n));
    }

    static /* synthetic */ OutboundMobilityCandidacyContest advised$createOutboundMobilityCandidacyContest(OutboundMobilityCandidacyPeriod this_, OutboundMobilityCandidacyContestGroup mobilityGroup, MobilityProgram mobilityProgram, UniversityUnit unit, Integer vacancies) {
        MobilityAgreement mobilityAgreement = this_.findOrCreateMobilityAgreement(mobilityProgram, unit);
        return new OutboundMobilityCandidacyContest(this_, mobilityGroup, mobilityAgreement, vacancies);
    }

    private MobilityAgreement findOrCreateMobilityAgreement(MobilityProgram mobilityProgram, UniversityUnit unit) {
        for (MobilityAgreement mobilityAgreement : mobilityProgram.getMobilityAgreementsSet()) {
            if (mobilityAgreement.getUniversityUnit() != unit) continue;
            return mobilityAgreement;
        }
        return new MobilityAgreement(mobilityProgram, unit);
    }

    @Override
    public int compareTo(CandidacyPeriod cp) {
        int i = this.getStart().compareTo((ReadableInstant)cp.getStart());
        return i == 0 ? this.getExternalId().compareTo(cp.getExternalId()) : i;
    }

    public Interval getInterval() {
        return new Interval((ReadableInstant)this.getStart(), (ReadableInstant)this.getEnd());
    }

    public String getIntervalAsString() {
        return this.getStart().toString("yyyy/MM/dd HH:mm") + " - " + this.getEnd().toString("yyyy/MM/dd HH:mm");
    }

    public SortedSet<OutboundMobilityCandidacyContest> getSortedOutboundMobilityCandidacyContest() {
        return new TreeSet<OutboundMobilityCandidacyContest>(this.getOutboundMobilityCandidacyContestSet());
    }

    public boolean isAcceptingCandidacies() {
        return this.isOpen();
    }

    public SortedSet<OutboundMobilityCandidacyContestGroup> getOutboundMobilityCandidacyContestGroupSet() {
        TreeSet<OutboundMobilityCandidacyContestGroup> result = new TreeSet<OutboundMobilityCandidacyContestGroup>();
        for (OutboundMobilityCandidacyContest contest : this.getOutboundMobilityCandidacyContestSet()) {
            result.add(contest.getOutboundMobilityCandidacyContestGroup());
        }
        return result;
    }

    public OutboundMobilityCandidacySubmission findSubmissionFor(Person person) {
        for (Registration registration : person.getStudent().getRegistrationsSet()) {
            for (OutboundMobilityCandidacySubmission submission : registration.getOutboundMobilityCandidacySubmissionSet()) {
                if (submission.getOutboundMobilityCandidacyPeriod() != this) continue;
                return submission;
            }
        }
        return null;
    }

    public void setOptionIntroductoryDestriptionService(String string) {
        Object object = advice$setOptionIntroductoryDestriptionService.perform((Callable)new OutboundMobilityCandidacyPeriod$callable$setOptionIntroductoryDestriptionService(this, string));
    }

    static /* synthetic */ void advised$setOptionIntroductoryDestriptionService(OutboundMobilityCandidacyPeriod this_, String optionIntroductoryDestription) {
        this_.setOptionIntroductoryDestription(optionIntroductoryDestription);
    }

    public void addOption(String string, Boolean bl) {
        Object object = advice$addOption.perform((Callable)new OutboundMobilityCandidacyPeriod$callable$addOption(this, string, bl));
    }

    static /* synthetic */ void advised$addOption(OutboundMobilityCandidacyPeriod this_, String optionValue, Boolean availableForCandidates) {
        new OutboundMobilityCandidacyPeriodConfirmationOption(this_, optionValue, availableForCandidates);
    }

    public SortedSet<OutboundMobilityCandidacyPeriodConfirmationOption> getSortedOptions() {
        return new TreeSet<OutboundMobilityCandidacyPeriodConfirmationOption>(this.getOutboundMobilityCandidacyPeriodConfirmationOptionSet());
    }

    public SortedSet<OutboundMobilityCandidacySubmission> getSortedSubmissionSet(final OutboundMobilityCandidacyContestGroup mobilityGroup) {
        TreeSet<OutboundMobilityCandidacySubmission> result = new TreeSet<OutboundMobilityCandidacySubmission>(new Comparator<OutboundMobilityCandidacySubmission>(){

            @Override
            public int compare(OutboundMobilityCandidacySubmission o1, OutboundMobilityCandidacySubmission o2) {
                BigDecimal grade1 = o1.getGradeForSerialization(mobilityGroup);
                BigDecimal grade2 = o2.getGradeForSerialization(mobilityGroup);
                if (grade1 == null && grade2 == null || grade1 != null && grade1.equals(grade2)) {
                    return o1.compareTo(o2);
                }
                return grade1 == null ? 1 : (grade2 == null ? -1 : grade2.compareTo(grade1));
            }
        });
        for (OutboundMobilityCandidacySubmission submission : this.getOutboundMobilityCandidacySubmissionSet()) {
            if (!submission.hasContestInGroup(mobilityGroup)) continue;
            result.add(submission);
        }
        return result;
    }

    public Spreadsheet getSelectedCandidateSpreadSheet(OutboundMobilityCandidacyPeriod period) {
        String filename = BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.mobility.outbound.period.export.selected.candiadates.filename", (String[])new String[0]);
        Spreadsheet spreadsheetCandidates = new Spreadsheet(filename);
        Spreadsheet spreadsheetOtherCurricularInfo = spreadsheetCandidates.addSpreadsheet(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.other.curricular.info", (String[])new String[0]));
        for (OutboundMobilityCandidacySubmission submission : this.getOutboundMobilityCandidacySubmissionSet()) {
            OutboundMobilityCandidacy candidacy = submission.getSelectedCandidacy();
            if (candidacy == null) continue;
            Registration registration = submission.getRegistration();
            Person person = registration.getPerson();
            ICurriculum curriculum = registration.getCurriculum();
            OutboundMobilityCandidacyContest contest = candidacy.getOutboundMobilityCandidacyContest();
            OutboundMobilityCandidacyContestGroup group = contest.getOutboundMobilityCandidacyContestGroup();
            MobilityAgreement mobilityAgreement = contest.getMobilityAgreement();
            MobilityProgram mobilityProgram = mobilityAgreement.getMobilityProgram();
            RegistrationProtocol registrationProtocol = mobilityProgram.getRegistrationProtocol();
            UniversityUnit universityUnit = mobilityAgreement.getUniversityUnit();
            Country country = universityUnit.getCountry();
            Spreadsheet.Row candidacyRow = spreadsheetCandidates.addRow();
            candidacyRow.setCell(this.getString("label.mobility.program", new String[0]), registrationProtocol.getDescription().getContent());
            candidacyRow.setCell(this.getString("label.country", new String[0]), country == null ? "" : country.getLocalizedName().toString());
            candidacyRow.setCell(this.getString("label.university", new String[0]), universityUnit.getPresentationName());
            candidacyRow.setCell(this.getString("label.degrees", new String[0]), group.getDescription());
            candidacyRow.setCell(this.getString("label.vacancies", new String[0]), contest.getVacancies());
            candidacyRow.setCell(this.getString("label.username", new String[0]), person.getUsername());
            candidacyRow.setCell(this.getString("label.name", new String[0]), person.getName());
            candidacyRow.setCell(this.getString("label.degree", new String[0]), registration.getDegree().getSigla());
            candidacyRow.setCell(this.getString("label.candidate.classification", new String[0]), this.getGrades(submission));
            candidacyRow.setCell(this.getString("label.preference.order", new String[0]), candidacy.getPreferenceOrder());
            candidacyRow.setCell(this.getString("label.curricular.year", new String[0]), curriculum.getCurricularYear());
            candidacyRow.setCell(this.getString("label.ects.completed.degree", new String[0]), curriculum.getSumEctsCredits().toString());
            candidacyRow.setCell(this.getString("label.average.degree", new String[0]), curriculum.getRawGrade().getValue());
            group.fillCycleDetails(candidacyRow, CycleType.FIRST_CYCLE, registration, this.getString("label.ects.completed.cycle.first", new String[0]), this.getString("label.average.cycle.first", new String[0]));
            group.fillCycleDetails(candidacyRow, CycleType.SECOND_CYCLE, registration, this.getString("label.ects.completed.cycle.second", new String[0]), this.getString("label.average.cycle.second", new String[0]));
            candidacyRow.setCell(this.getString("label.email", new String[0]), person.getEmailForSendingEmails());
            candidacyRow.setCell(this.getString("label.phone", new String[0]), person.getDefaultPhoneNumber());
            candidacyRow.setCell(this.getString("label.mobile", new String[0]), person.getDefaultMobilePhoneNumber());
            for (Registration otherRegistration : registration.getStudent().getRegistrationsSet()) {
                if (otherRegistration == registration) continue;
                Spreadsheet.Row rowOCI = spreadsheetOtherCurricularInfo.addRow();
                ICurriculum curriculumOther = otherRegistration.getCurriculum();
                rowOCI.setCell(this.getString("label.username", new String[0]), person.getUsername());
                rowOCI.setCell(this.getString("label.name", new String[0]), person.getName());
                rowOCI.setCell(this.getString("label.degree", new String[0]), otherRegistration.getDegree().getSigla());
                rowOCI.setCell(this.getString("label.curricular.year", new String[0]), curriculumOther.getCurricularYear());
                rowOCI.setCell(this.getString("label.ects.completed.degree", new String[0]), curriculumOther.getSumEctsCredits().toString());
                rowOCI.setCell(this.getString("label.average.degree", new String[0]), curriculumOther.getRawGrade().getValue());
                group.fillCycleDetails(rowOCI, CycleType.FIRST_CYCLE, otherRegistration, this.getString("label.ects.completed.cycle.first", new String[0]), this.getString("label.average.cycle.first", new String[0]));
                group.fillCycleDetails(rowOCI, CycleType.SECOND_CYCLE, otherRegistration, this.getString("label.ects.completed.cycle.second", new String[0]), this.getString("label.average.cycle.second", new String[0]));
            }
        }
        return spreadsheetCandidates;
    }

    private String getGrades(OutboundMobilityCandidacySubmission submission) {
        HashSet<BigDecimal> grades = new HashSet<BigDecimal>();
        StringBuilder builder = new StringBuilder();
        for (OutboundMobilityCandidacySubmissionGrade grade : submission.getOutboundMobilityCandidacySubmissionGradeSet()) {
            BigDecimal value = grade.getGrade();
            if (grades.contains(value)) continue;
            grades.add(value);
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(value.toString());
        }
        return builder.toString();
    }

    private String getString(String key, String ... args) {
        return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)key, (String[])args);
    }

    public String selectCandidatesForAllGroups() {
        return (String)advice$selectCandidatesForAllGroups.perform((Callable)new OutboundMobilityCandidacyPeriod$callable$selectCandidatesForAllGroups(this));
    }

    static /* synthetic */ String advised$selectCandidatesForAllGroups(OutboundMobilityCandidacyPeriod this_) {
        Registration registration;
        boolean hasSomePlacement = false;
        StringBuilder error = new StringBuilder();
        HashMap<OutboundMobilityCandidacySubmission, OutboundMobilityCandidacy> selections = new HashMap<OutboundMobilityCandidacySubmission, OutboundMobilityCandidacy>();
        for (OutboundMobilityCandidacySubmission submission : this_.getOutboundMobilityCandidacySubmissionSet()) {
            OutboundMobilityCandidacy selectedCandidacy = submission.getSelectedCandidacy();
            selections.put(submission, selectedCandidacy);
            if (selectedCandidacy != null) {
                hasSomePlacement = true;
            }
            BigDecimal gv = null;
            for (OutboundMobilityCandidacySubmissionGrade grade : submission.getOutboundMobilityCandidacySubmissionGradeSet()) {
                if (gv == null) {
                    gv = grade.getGrade();
                    continue;
                }
                if (gv.equals(grade.getGrade())) continue;
                registration = submission.getRegistration();
                error.append(this_.getString("label.error.student.has.different.grades.in.different.groups", registration.getPerson().getUsername(), registration.getDegree().getSigla()));
                error.append("\n");
            }
        }
        if (error.length() > 0) {
            throw new DomainException(error.toString(), new String[0]);
        }
        for (OutboundMobilityCandidacyContestGroup group : this_.getOutboundMobilityCandidacyContestGroupSet()) {
            for (OutboundMobilityCandidacyContest contest : group.getOutboundMobilityCandidacyContestSet()) {
                for (OutboundMobilityCandidacy candidacy : contest.getOutboundMobilityCandidacySet()) {
                    candidacy.unselect();
                }
            }
        }
        for (OutboundMobilityCandidacyContestGroup group : this_.getOutboundMobilityCandidacyContestGroupSet()) {
            group.selectCandidates(this_);
        }
        StringBuilder result = new StringBuilder();
        TreeSet<OutboundMobilityCandidacySubmission> submissions = new TreeSet<OutboundMobilityCandidacySubmission>(new Comparator<OutboundMobilityCandidacySubmission>(){

            @Override
            public int compare(OutboundMobilityCandidacySubmission o1, OutboundMobilityCandidacySubmission o2) {
                int cd = o1.getRegistration().getDegree().compareTo(o2.getRegistration().getDegree());
                return cd == 0 ? o1.compareTo(o2) : cd;
            }
        });
        submissions.addAll(this_.getOutboundMobilityCandidacySubmissionSet());
        int selectedCandidateCount = 0;
        for (OutboundMobilityCandidacySubmission submission : submissions) {
            OutboundMobilityCandidacy selectedCandidacy = submission.getSelectedCandidacy();
            if (selectedCandidacy != null) {
                ++selectedCandidateCount;
            }
            if (selectedCandidacy == selections.get(submission)) continue;
            registration = submission.getRegistration();
            result.append(this_.getString("label.changed.candidate.selection", registration.getPerson().getUsername(), registration.getDegree().getSigla(), this_.printPlacement((OutboundMobilityCandidacy)selections.get(submission)), this_.printPlacement(selectedCandidacy)));
            result.append("\n");
        }
        return hasSomePlacement ? result.toString() : this_.getString("label.count.placed.candidates", "" + selectedCandidateCount);
    }

    private String printPlacement(OutboundMobilityCandidacy candidacy) {
        return candidacy == null ? "-----" : candidacy.getOutboundMobilityCandidacyContest().getMobilityAgreement().getUniversityUnit().getPresentationName();
    }

    private OutboundMobilityCandidacyPeriod findPreviousPeriod() {
        OutboundMobilityCandidacyPeriod result = null;
        for (ExecutionInterval interval : Bennu.getInstance().getExecutionIntervalsSet()) {
            for (CandidacyPeriod candidacyPeriod : interval.getCandidacyPeriodsSet()) {
                OutboundMobilityCandidacyPeriod period;
                YearMonthDay ymd;
                if (!(candidacyPeriod instanceof OutboundMobilityCandidacyPeriod) || !(ymd = (period = (OutboundMobilityCandidacyPeriod)((Object)candidacyPeriod)).getExecutionInterval().getBeginDateYearMonthDay()).isBefore((ReadablePartial)this.getExecutionInterval().getBeginDateYearMonthDay()) || result != null && !result.getExecutionInterval().getBeginDateYearMonthDay().isBefore((ReadablePartial)ymd)) continue;
                result = period;
            }
        }
        return result;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new OutboundMobilityCandidacyPeriod$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(OutboundMobilityCandidacyPeriod this_) {
        if (!this_.getOutboundMobilityCandidacyContestSet().isEmpty()) {
            throw new DomainException("cannot.delete.because.still.connected.to.contests", new String[0]);
        }
        for (OutboundMobilityCandidacyPeriodConfirmationOption option : this_.getOutboundMobilityCandidacyPeriodConfirmationOptionSet()) {
            option.delete();
        }
        this_.setExecutionInterval(null);
        this_.setRootDomainObject(null);
        this_.deleteDomainObject();
    }
}

