/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.contacts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PersonInformationLog;
import org.fenixedu.academic.domain.contacts.ContactRoot;
import org.fenixedu.academic.domain.contacts.PartyContact$callable$delete;
import org.fenixedu.academic.domain.contacts.PartyContact$callable$deleteWithoutCheckRules;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.PartyContactValidation;
import org.fenixedu.academic.domain.contacts.PartyContact_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class PartyContact
extends PartyContact_Base {
    public static Comparator<PartyContact> COMPARATOR_BY_TYPE;
    public static final Advice advice$deleteWithoutCheckRules;
    public static final Advice advice$delete;

    protected PartyContact() {
        this.setContactRoot(ContactRoot.getInstance());
        this.setVisibleToPublic(Boolean.FALSE);
        this.setVisibleToStudents(Boolean.FALSE);
        this.setVisibleToStaff(Boolean.FALSE);
        this.setLastModifiedDate(new DateTime());
        this.setActive(true);
        this.setDefaultContact(false);
    }

    protected void init(Party party, PartyContactType type, boolean defaultContact) {
        this.checkParameters(party, type);
        super.setParty(party);
        super.setType(type);
        if (type.equals((Object)PartyContactType.INSTITUTIONAL)) {
            this.setVisibleToPublic();
        } else {
            this.setVisibleToStudents(type == PartyContactType.WORK);
            this.setVisibleToStaff(type == PartyContactType.WORK);
        }
        this.setDefaultContactInformation(defaultContact);
        this.setLastModifiedDate(new DateTime());
    }

    protected void init(Party party, PartyContactType type, boolean visibleToPublic, boolean visibleToStudents, boolean visibleToStaff, boolean defaultContact) {
        this.checkParameters(party, type);
        super.setParty(party);
        super.setType(type);
        this.setVisibleToPublic(new Boolean(visibleToPublic));
        this.setVisibleToStudents(new Boolean(visibleToStudents));
        this.setVisibleToStaff(new Boolean(visibleToStaff));
        this.setDefaultContactInformation(defaultContact);
        this.setLastModifiedDate(new DateTime());
    }

    private void setVisibleToPublic() {
        super.setVisibleToPublic(Boolean.TRUE);
        super.setVisibleToStudents(Boolean.TRUE);
        super.setVisibleToStaff(Boolean.TRUE);
    }

    public void setVisibleToPublic(Boolean visibleToPublic) {
        super.setVisibleToPublic(visibleToPublic);
        if (visibleToPublic.booleanValue()) {
            super.setVisibleToStudents(Boolean.TRUE);
            super.setVisibleToStaff(Boolean.TRUE);
        }
    }

    public void setVisibleToStudents(Boolean visibleToStudents) {
        super.setVisibleToStudents(visibleToStudents);
        if (!visibleToStudents.booleanValue()) {
            super.setVisibleToPublic(Boolean.FALSE);
        }
    }

    public void setVisibleToStaff(Boolean visibleToStaff) {
        super.setVisibleToStaff(visibleToStaff);
        if (!visibleToStaff.booleanValue()) {
            super.setVisibleToPublic(Boolean.FALSE);
        }
    }

    public boolean isVisible() {
        if (this.getVisibleToPublic().booleanValue()) {
            return true;
        }
        if (this.getVisibleToStudents().booleanValue() && ContactRoot.getInstance().getStudentVisibility().isMember(Authenticate.getUser())) {
            return true;
        }
        if (this.getVisibleToStaff().booleanValue() && ContactRoot.getInstance().getStaffVisibility().isMember(Authenticate.getUser())) {
            return true;
        }
        return ContactRoot.getInstance().getManagementVisibility().isMember(Authenticate.getUser());
    }

    public void setDefaultContactInformation(boolean defaultContact) {
        if (!this.isActiveAndValid()) {
            if (this.getPartyContactValidation() != null) {
                this.getPartyContactValidation().setToBeDefault(defaultContact);
            }
        } else if (defaultContact) {
            this.changeToDefault();
        } else {
            List<? extends PartyContact> partyContacts = this.getParty().getPartyContacts(((Object)((Object)this)).getClass());
            if (partyContacts.isEmpty() || partyContacts.size() == 1) {
                super.setDefaultContact(Boolean.TRUE);
            } else {
                this.setAnotherContactAsDefault();
                super.setDefaultContact(Boolean.FALSE);
            }
        }
    }

    public void changeToDefault() {
        PartyContact defaultPartyContact = this.getParty().getDefaultPartyContact(((Object)((Object)this)).getClass());
        if (defaultPartyContact != null && defaultPartyContact != this) {
            defaultPartyContact.setDefaultContact(Boolean.FALSE);
        }
        super.setDefaultContact(Boolean.TRUE);
    }

    private void checkParameters(Party party, PartyContactType type) {
        if (party == null) {
            throw new DomainException("error.contacts.PartyContact.party.cannot.be.null", new String[0]);
        }
        if (type == null) {
            throw new DomainException("error.contacts.PartyContact.contactType.cannot.be.null", new String[0]);
        }
    }

    public void edit(PartyContactType type, boolean defaultContact) {
        this.checkParameters(this.getParty(), type);
        this.setType(type);
        this.setDefaultContactInformation(defaultContact);
    }

    public abstract String getPresentationValue();

    public boolean isDefault() {
        return this.hasDefaultContactValue() && this.getDefaultContact() != false;
    }

    private boolean hasDefaultContactValue() {
        return this.getDefaultContact() != null;
    }

    public boolean isInstitutionalType() {
        return this.getType() == PartyContactType.INSTITUTIONAL;
    }

    public boolean isWorkType() {
        return this.getType() == PartyContactType.WORK;
    }

    public boolean isPersonalType() {
        return this.getType() == PartyContactType.PERSONAL;
    }

    public boolean isWebAddress() {
        return false;
    }

    public boolean isPhysicalAddress() {
        return false;
    }

    public boolean isEmailAddress() {
        return false;
    }

    public boolean isPhone() {
        return false;
    }

    public boolean isMobile() {
        return false;
    }

    public void deleteWithoutCheckRules() {
        Object object = advice$deleteWithoutCheckRules.perform((Callable)new PartyContact$callable$deleteWithoutCheckRules(this));
    }

    static /* synthetic */ void advised$deleteWithoutCheckRules(PartyContact this_) {
        this_.processDelete();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PartyContact$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PartyContact this_) {
        if (this_.isActiveAndValid()) {
            this_.checkRulesToDelete();
        }
        this_.processDelete();
    }

    protected void processDelete() {
        if (this.isActiveAndValid()) {
            this.setAnotherContactAsDefault();
        }
        if (this.getActive().booleanValue()) {
            PartyContactValidation validation;
            this.setActive(false);
            this.setLastModifiedDate(new DateTime());
            this.setCurrentPartyContact(null);
            this.setPrevPartyContact(null);
            if (this.getPartyContactValidation() != null && (validation = this.getPartyContactValidation()).getContactRoot() != null) {
                validation.setContactRoot(null);
            }
        }
    }

    protected void checkRulesToDelete() {
    }

    public void setAnotherContactAsDefault() {
        List<? extends PartyContact> contacts;
        if (this.isDefault() && !(contacts = this.getParty().getPartyContacts(((Object)((Object)this)).getClass())).isEmpty() && contacts.size() > 1) {
            contacts.remove((Object)this);
            contacts.iterator().next().setDefaultContact(Boolean.TRUE);
        }
    }

    public String getPartyContactTypeString() {
        return this.getType().name();
    }

    public static Set<PartyContact> readPartyContactsOfType(Class<? extends PartyContact> ... contactClasses) {
        HashSet<PartyContact> contacts = new HashSet<PartyContact>();
        for (Class<? extends PartyContact> clazz : contactClasses) {
            contacts.addAll(PartyContact.getAllInstancesOf(clazz));
        }
        return contacts;
    }

    public boolean isValid() {
        return this.getPartyContactValidation() == null || this.getPartyContactValidation().isValid();
    }

    public boolean isActiveAndValid() {
        return this.getActive() != false && this.isValid();
    }

    public boolean waitsValidation() {
        return this.getActive() != false && !this.isValid();
    }

    public void triggerValidationProcess() {
        if (this.getPartyContactValidation() != null) {
            this.getPartyContactValidation().triggerValidationProcess();
        }
    }

    public void triggerValidationProcessIfNeeded() {
        if (this.getPartyContactValidation() != null) {
            this.getPartyContactValidation().triggerValidationProcessIfNeeded();
        }
    }

    public abstract boolean hasValue(String var1);

    public void setValid() {
        if (this.getPartyContactValidation() != null) {
            this.getPartyContactValidation().setValid();
        }
    }

    public boolean isValidationCodeGenerated() {
        if (this.getPartyContactValidation() != null) {
            return this.getPartyContactValidation().getToken() != null;
        }
        return false;
    }

    public void logCreate(Person person) {
    }

    protected void logCreateAux(Person person, String typeKey) {
        String infoLabel = BundleUtil.getString((String)"resources.ApplicationResources", (String)typeKey, (String[])new String[0]);
        String personViewed = PersonInformationLog.getPersonNameForLogDescription(person);
        String descriptionKey = this.waitsValidation() ? "log.personInformation.contact.generic.create.need.valid" : "log.personInformation.contact.generic.create";
        PersonInformationLog.createLog(person, "resources.MessagingResources", descriptionKey, infoLabel, this.getPresentationValue(), personViewed);
    }

    public void logEdit(Person person, boolean propertiesChanged, boolean valueChanged, boolean createdNewContact, String newValue) {
    }

    protected void logEditAux(Person person, boolean propertiesChanged, boolean valueChanged, boolean createdNewContact, String newValue, String typeKey) {
        String infoLabel = BundleUtil.getString((String)"resources.ApplicationResources", (String)typeKey, (String[])new String[0]);
        String personViewed = PersonInformationLog.getPersonNameForLogDescription(person);
        boolean oldValueDiffersFromNew = false;
        if (valueChanged && this.getPrevPartyContact() != null) {
            boolean bl = oldValueDiffersFromNew = this.getPrevPartyContact().getPresentationValue().compareTo(this.getPresentationValue()) != 0;
        }
        if (propertiesChanged && !valueChanged) {
            if (this.getPrevPartyContact() != null) {
                PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.edit.need.valid.newEdit", infoLabel, this.getPresentationValue(), personViewed);
            } else if (this.isValid()) {
                PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.edit", infoLabel, this.getPresentationValue(), personViewed);
            } else {
                PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.create.need.valid.edited", infoLabel, this.getPresentationValue(), personViewed);
            }
        } else if (valueChanged) {
            if (this.getPrevPartyContact() != null) {
                if (this.getPrevPartyContact().isValid()) {
                    if (oldValueDiffersFromNew && createdNewContact) {
                        PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.edit.need.valid.values", infoLabel, this.getPrevPartyContact().getPresentationValue(), newValue, personViewed);
                    } else if (createdNewContact) {
                        PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.edit.need.valid", infoLabel, this.getPresentationValue(), personViewed);
                    } else if (oldValueDiffersFromNew) {
                        PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.edit.need.valid.values.newEdit", infoLabel, this.getPrevPartyContact().getPresentationValue(), newValue, personViewed);
                    } else {
                        PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.edit.need.valid.newEdit", infoLabel, this.getPresentationValue(), personViewed);
                    }
                } else {
                    PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.edit.need.valid.values.newEdit", infoLabel, this.getPresentationValue(), newValue, personViewed);
                }
            } else {
                PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.create.need.valid.values.edited", infoLabel, this.getPresentationValue(), newValue, personViewed);
            }
        }
    }

    public void logDelete(Person person) {
    }

    public void logDeleteAux(Person person, String typeKey) {
        String infoLabel = BundleUtil.getString((String)"resources.ApplicationResources", (String)typeKey, (String[])new String[0]);
        String personViewed = PersonInformationLog.getPersonNameForLogDescription(person);
        if (this.isValid()) {
            PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.remove", infoLabel, this.getPresentationValue(), personViewed);
        } else if (this.getPrevPartyContact() == null) {
            PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.create.need.valid.canceled", infoLabel, this.getPresentationValue(), personViewed);
        } else {
            String oldValue = this.getPrevPartyContact().getPresentationValue();
            if (oldValue.compareTo(this.getPresentationValue()) == 0) {
                PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.edit.need.valid.canceled", infoLabel, this.getPresentationValue(), personViewed);
            } else {
                PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.edit.need.valid.values.canceled", infoLabel, this.getPrevPartyContact().getPresentationValue(), this.getPresentationValue(), personViewed);
            }
        }
    }

    public void logValid(Person person) {
    }

    public void logValidAux(Person person, String typeKey) {
        String infoLabel = BundleUtil.getString((String)"resources.ApplicationResources", (String)typeKey, (String[])new String[0]);
        String personViewed = PersonInformationLog.getPersonNameForLogDescription(person);
        if (this.getPrevPartyContact() == null) {
            PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.create.need.valid.accepted", infoLabel, this.getPresentationValue(), personViewed);
        } else {
            String oldValue = this.getPrevPartyContact().getPresentationValue();
            if (oldValue.compareTo(this.getPresentationValue()) == 0) {
                PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.edit.need.valid.accepted", infoLabel, this.getPresentationValue(), personViewed);
            } else {
                PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.edit.need.valid.values.accepted", infoLabel, this.getPrevPartyContact().getPresentationValue(), this.getPresentationValue(), personViewed);
            }
        }
    }

    public void logRefuse(Person person) {
    }

    public void logRefuseAux(Person person, String typeKey) {
        String infoLabel = BundleUtil.getString((String)"resources.ApplicationResources", (String)typeKey, (String[])new String[0]);
        String personViewed = PersonInformationLog.getPersonNameForLogDescription(person);
        if (this.getPrevPartyContact() == null) {
            PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.create.need.valid.rejected", infoLabel, this.getPresentationValue(), personViewed);
        } else {
            String oldValue = this.getPrevPartyContact().getPresentationValue();
            if (oldValue.compareTo(this.getPresentationValue()) == 0) {
                PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.edit.need.valid.rejected", infoLabel, this.getPresentationValue(), personViewed);
            } else {
                PersonInformationLog.createLog(person, "resources.MessagingResources", "log.personInformation.contact.generic.edit.need.valid.values.rejected", infoLabel, this.getPrevPartyContact().getPresentationValue(), this.getPresentationValue(), personViewed);
            }
        }
    }

    private static Set<PartyContact> getAllInstancesOf(Class<? extends PartyContact> type) {
        return Sets.newHashSet((Iterable)Iterables.filter((Iterable)ContactRoot.getInstance().getPartyContactsSet(), type));
    }

    public boolean isToBeValidated() {
        return true;
    }

    static {
        advice$deleteWithoutCheckRules = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_TYPE = new Comparator<PartyContact>(){

            @Override
            public int compare(PartyContact contact, PartyContact otherContact) {
                int result = contact.getType().compareTo(otherContact.getType());
                return result == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)contact, (DomainObject)otherContact) : result;
            }
        };
    }
}

