/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.standalone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EmptyDegree;
import org.fenixedu.academic.domain.EntryPhase;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.events.candidacy.StandaloneIndividualCandidacyEvent;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyState;
import org.fenixedu.academic.domain.candidacyProcess.standalone.StandaloneCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.standalone.StandaloneIndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.standalone.StandaloneIndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.standalone.StandaloneIndividualCandidacyResultBean;
import org.fenixedu.academic.domain.candidacyProcess.standalone.StandaloneIndividualCandidacy_Base;
import org.fenixedu.academic.domain.curricularRules.MaximumNumberOfEctsInStandaloneCurriculumGroup;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.administrativeOffice.studentEnrolment.StudentStandaloneEnrolmentBean;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;

public class StandaloneIndividualCandidacy
extends StandaloneIndividualCandidacy_Base {
    private StandaloneIndividualCandidacy() {
    }

    StandaloneIndividualCandidacy(StandaloneIndividualCandidacyProcess process2, StandaloneIndividualCandidacyProcessBean bean) {
        this();
        Person person = this.init(bean, (IndividualCandidacyProcess)((Object)process2));
        this.addSelectedCurricularCourses(bean.getCurricularCourses(), bean.getCandidacyExecutionInterval());
        if (bean.getInternalPersonCandidacy().booleanValue()) {
            this.createDebt(person);
        }
    }

    protected void checkParameters(Person person, IndividualCandidacyProcess process2, IndividualCandidacyProcessBean bean) {
        if (this.hasValidStandaloneIndividualCandidacy(bean, process2.getCandidacyExecutionInterval())) {
            throw new DomainException("error.StandaloneIndividualCandidacy.person.already.has.candidacy", process2.getCandidacyExecutionInterval().getName());
        }
        LocalDate candidacyDate = bean.getCandidacyDate();
        this.checkParameters(person, process2, candidacyDate);
    }

    protected void checkParameters(Person person, IndividualCandidacyProcess process2, LocalDate candidacyDate) {
        super.checkParameters(person, process2, candidacyDate);
    }

    private <T extends CandidacyProcess> boolean hasValidIndividualCandidacy(Class<T> clazz, ExecutionInterval executionInterval, IndividualCandidacyProcessBean bean) {
        T candidacyProcess = CandidacyProcess.getCandidacyProcessByExecutionInterval(clazz, executionInterval);
        IndividualCandidacyProcess individualCandidacyProcess = ((CandidacyProcess)((Object)candidacyProcess)).getChildProcessByDocumentId(bean.getPersonBean().getIdDocumentType(), bean.getPersonBean().getDocumentIdNumber());
        return individualCandidacyProcess != null && !individualCandidacyProcess.isCandidacyCancelled();
    }

    public boolean hasValidStandaloneIndividualCandidacy(IndividualCandidacyProcessBean bean, ExecutionInterval executionInterval) {
        return this.hasValidIndividualCandidacy(StandaloneCandidacyProcess.class, executionInterval, bean);
    }

    private void addSelectedCurricularCourses(List<CurricularCourse> curricularCourses, ExecutionSemester executionSemester) {
        this.checkEctsCredits(curricularCourses, executionSemester);
        this.getCurricularCoursesSet().addAll(curricularCourses);
    }

    private void checkEctsCredits(List<CurricularCourse> curricularCourses, ExecutionSemester executionSemester) {
        double total = 0.0;
        for (CurricularCourse curricularCourse : curricularCourses) {
            total += curricularCourse.getEctsCredits(executionSemester).doubleValue();
        }
        if (!MaximumNumberOfEctsInStandaloneCurriculumGroup.allowEctsCheckingDefaultValue(total)) {
            throw new DomainException("error.StandaloneIndividualCandidacy.ects.credits.above.maximum", String.valueOf(MaximumNumberOfEctsInStandaloneCurriculumGroup.MAXIMUM_DEFAULT_VALUE));
        }
    }

    protected void createDebt(Person person) {
        new StandaloneIndividualCandidacyEvent(this, person);
    }

    public void editCandidacyInformation(LocalDate candidacyDate, List<CurricularCourse> curricularCourses) {
        super.checkParameters(this.getPersonalDetails().getPerson(), this.getCandidacyProcess(), candidacyDate);
        this.setCandidacyDate(candidacyDate);
        this.getCurricularCoursesSet().clear();
        this.addSelectedCurricularCourses(curricularCourses, this.getCandidacyExecutionInterval());
    }

    public void editCandidacyResult(StandaloneIndividualCandidacyResultBean bean) {
        this.checkParameters(bean);
        if (this.isCandidacyResultStateValid(bean.getState())) {
            this.setState(bean.getState());
        }
    }

    private void checkParameters(StandaloneIndividualCandidacyResultBean bean) {
        if (this.isAccepted() && bean.getState() != IndividualCandidacyState.ACCEPTED && this.getRegistration() != null) {
            throw new DomainException("error.StandaloneIndividualCandidacy.cannot.change.state.from.accepted.candidacies", new String[0]);
        }
    }

    public Registration createRegistration(DegreeCurricularPlan degreeCurricularPlan, CycleType cycleType, IngressionType ingressionType) {
        if (this.getRegistration() != null) {
            throw new DomainException("error.IndividualCandidacy.person.with.registration", degreeCurricularPlan.getPresentationName());
        }
        if (!degreeCurricularPlan.isEmpty()) {
            throw new DomainException("error.StandaloneIndividualCandidacy.dcp.must.be.empty", new String[0]);
        }
        if (this.hasActiveRegistration(degreeCurricularPlan)) {
            Registration registration = this.getStudent().getActiveRegistrationFor(degreeCurricularPlan);
            this.setRegistration(registration);
            this.enrolInCurricularCourses(registration);
            return registration;
        }
        this.getPersonalDetails().ensurePersonInternalization();
        return this.createRegistration(this.getPersonalDetails().getPerson(), degreeCurricularPlan, cycleType, ingressionType);
    }

    protected Registration createRegistration(Person person, DegreeCurricularPlan degreeCurricularPlan, CycleType cycleType, IngressionType ingressionType) {
        Registration registration = new Registration(person, degreeCurricularPlan);
        registration.setEntryPhase(EntryPhase.FIRST_PHASE);
        registration.setIngressionType(ingressionType);
        registration.setRegistrationYear(this.getCandidacyExecutionInterval().getExecutionYear());
        registration.editStartDates(this.getStartDate(), registration.getHomologationDate(), registration.getStudiesStartDate());
        this.setRegistration(registration);
        this.enrolInCurricularCourses(registration);
        return registration;
    }

    protected YearMonthDay getStartDate() {
        ExecutionYear interval = this.getCandidacyExecutionInterval().getExecutionYear();
        return ((ExecutionInterval)((Object)interval)).isCurrent() ? new YearMonthDay() : interval.getBeginDateYearMonthDay();
    }

    private void enrolInCurricularCourses(Registration registration) {
        StudentCurricularPlan studentCurricularPlan = registration.getLastStudentCurricularPlan();
        for (CurricularCourse curricularCourse : this.getCurricularCoursesSet()) {
            if (studentCurricularPlan.isEnroledInExecutionPeriod(curricularCourse, this.getCandidacyExecutionInterval())) continue;
            studentCurricularPlan.createNoCourseGroupCurriculumGroupEnrolment(this.createStudentStandaloneEnrolmentBean(studentCurricularPlan, curricularCourse));
        }
    }

    private StudentStandaloneEnrolmentBean createStudentStandaloneEnrolmentBean(StudentCurricularPlan scp, CurricularCourse curricularCourse) {
        StudentStandaloneEnrolmentBean bean = new StudentStandaloneEnrolmentBean(scp, this.getCandidacyExecutionInterval());
        bean.setSelectedCurricularCourse(curricularCourse);
        bean.setCurricularRuleLevel(CurricularRuleLevel.STANDALONE_ENROLMENT);
        return bean;
    }

    protected ExecutionSemester getCandidacyExecutionInterval() {
        return (ExecutionSemester)((Object)super.getCandidacyExecutionInterval());
    }

    public String getDescription() {
        return this.getCandidacyProcess().getDisplayName() + ": " + Degree.readEmptyDegree().getNameI18N();
    }

    public Collection<Degree> getAllDegrees() {
        ArrayList<Degree> result = new ArrayList<Degree>();
        result.add((Degree)((Object)EmptyDegree.getInstance()));
        return result;
    }

    public boolean isStandalone() {
        return true;
    }
}

