/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class PhoneUtil {
    private static final Collection<PhoneNumberUtil.PhoneNumberType> FIXED_NUMBERS = new ArrayList<PhoneNumberUtil.PhoneNumberType>();
    private static final Collection<PhoneNumberUtil.PhoneNumberType> MOBILE_NUMBERS;
    private static final int ALAMEDA_PHONE = 218416000;
    private static final int TAGUS_PHONE_000 = 214233200;
    private static final int TAGUS_PHONE_100 = 214233500;
    private static final PhoneNumberUtil PHONE_UTIL;
    private static final String COUNTRY_CODE = "PT";

    public static Phonenumber.PhoneNumber getPhoneNumber(String numberText) {
        if (!StringUtils.isEmpty((String)numberText)) {
            if (numberText.startsWith("00")) {
                numberText = numberText.replaceFirst("00", "+");
            }
            if (PhoneUtil.isExtension(numberText)) {
                numberText = PhoneUtil.getExternalNumberForExtension(numberText);
            }
            try {
                Phonenumber.PhoneNumber phoneNumber = PHONE_UTIL.parse(numberText, COUNTRY_CODE);
                if (PHONE_UTIL.isValidNumber(phoneNumber)) {
                    return phoneNumber;
                }
            }
            catch (NumberParseException e) {
                System.out.println("O n\ufffdmero n\ufffdo \ufffd v\ufffdlido:" + (Object)((Object)e));
                return null;
            }
        }
        return null;
    }

    private static PhoneNumberUtil.PhoneNumberType getPhoneNumberType(Phonenumber.PhoneNumber phoneNumber) {
        return phoneNumber != null ? PHONE_UTIL.getNumberType(phoneNumber) : null;
    }

    public static boolean isValidNumber(String numberText) {
        Phonenumber.PhoneNumber phoneNumber = PhoneUtil.getPhoneNumber(numberText);
        return phoneNumber != null;
    }

    private static boolean isType(PhoneNumberUtil.PhoneNumberType type, Collection<PhoneNumberUtil.PhoneNumberType> types) {
        return types.contains(type);
    }

    public static boolean isMobileNumber(String numberText) {
        return PhoneUtil.isType(PhoneUtil.getPhoneNumberType(PhoneUtil.getPhoneNumber(numberText)), MOBILE_NUMBERS);
    }

    public static boolean isPortugueseNumber(String numberText) {
        Phonenumber.PhoneNumber phoneNumber = PhoneUtil.getPhoneNumber(numberText);
        if (phoneNumber != null) {
            return phoneNumber.getCountryCode() == 351;
        }
        return false;
    }

    public static boolean isFixedNumber(String numberText) {
        return PhoneUtil.isType(PhoneUtil.getPhoneNumberType(PhoneUtil.getPhoneNumber(numberText)), FIXED_NUMBERS);
    }

    public static String getExternalNumberForExtension(String numberText) {
        int extension;
        try {
            extension = Integer.parseInt(numberText);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (extension >= 1000 && extension <= 3999) {
            return new Integer(218416000 + extension).toString();
        }
        if (extension >= 5000 && extension <= 5099) {
            return new Integer(214233200 + (extension -= 5000)).toString();
        }
        if (extension >= 5100 && extension <= 5199) {
            return new Integer(214233500 + (extension -= 5100)).toString();
        }
        return null;
    }

    public static String getInternacionalFormatNumber(String numberText) {
        Phonenumber.PhoneNumber phoneNumber;
        if (PhoneUtil.isExtension(numberText)) {
            numberText = PhoneUtil.getExternalNumberForExtension(numberText);
        }
        if ((phoneNumber = PhoneUtil.getPhoneNumber(numberText)) != null) {
            return PHONE_UTIL.format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.E164);
        }
        return null;
    }

    private static boolean isExtension(String numberText) {
        return PhoneUtil.getExternalNumberForExtension(numberText) != null;
    }

    public static int getCountry(String numberText) {
        Phonenumber.PhoneNumber phoneNumber = PhoneUtil.getPhoneNumber(numberText);
        if (phoneNumber != null) {
            return phoneNumber.getCountryCode();
        }
        return -1;
    }

    static {
        FIXED_NUMBERS.add(PhoneNumberUtil.PhoneNumberType.VOIP);
        FIXED_NUMBERS.add(PhoneNumberUtil.PhoneNumberType.FIXED_LINE);
        MOBILE_NUMBERS = new ArrayList<PhoneNumberUtil.PhoneNumberType>();
        MOBILE_NUMBERS.add(PhoneNumberUtil.PhoneNumberType.MOBILE);
        PHONE_UTIL = PhoneNumberUtil.getInstance();
    }
}

