/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class LabelFormatter
implements Serializable {
    private final List<Label> labels = new ArrayList<Label>();

    public LabelFormatter() {
    }

    public LabelFormatter(String text) {
        this();
        this.appendLabel(text);
    }

    public LabelFormatter(String key, String bundle) {
        this();
        this.appendLabel(key, bundle);
    }

    public LabelFormatter(String bundle, String key, String ... args) {
        this();
        this.appendLabel(bundle, key, args);
    }

    public LabelFormatter appendLabel(String text) {
        this.labels.add(new Label(null, text, new String[0]));
        return this;
    }

    public LabelFormatter appendLabel(String key, String bundle) {
        this.labels.add(new Label(bundle, key, new String[0]));
        return this;
    }

    public LabelFormatter appendLabel(String bundle, String key, String ... args) {
        this.labels.add(new Label(bundle, key, args));
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Label label : this.getLabels()) {
            if (label.isUseBundle()) {
                result.append(BundleUtil.getString((String)label.getBundle(), (String)label.getKey(), (String[])label.getArgs()));
                continue;
            }
            result.append(label.getKey());
        }
        return result.toString();
    }

    public List<Label> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    public boolean isEmpty() {
        return this.labels.isEmpty();
    }

    private static class Label
    implements Serializable {
        private final String key;
        private final String bundle;
        private final String[] args;

        public Label(String bundle, String key, String ... args) {
            this.bundle = bundle;
            this.key = key;
            this.args = args;
        }

        public String getBundle() {
            return this.bundle;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isUseBundle() {
            return !Strings.isNullOrEmpty((String)this.bundle);
        }

        public String[] getArgs() {
            return this.args;
        }
    }
}

