/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.teacher;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Project;
import org.fenixedu.academic.domain.ProjectSubmission;
import org.fenixedu.academic.domain.ProjectSubmissionLog;
import org.fenixedu.academic.domain.StudentGroup;
import org.fenixedu.academic.dto.VariantBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.teacher.NotifyStudentGroup;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.teacher.ManageExecutionCourseDA;
import org.fenixedu.academic.ui.struts.action.teacher.executionCourse.ExecutionCourseBaseAction;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(module="teacher", path="/projectSubmissionsManagement", functionality=ManageExecutionCourseDA.class)
public class ProjectSubmissionsManagementDispatchAction
extends ExecutionCourseBaseAction {
    protected ActionForward doForward(HttpServletRequest request, String path) {
        request.setAttribute("teacher$actual$page", (Object)path);
        return new ActionForward("/evaluation/evaluationFrame.jsp");
    }

    public ActionForward viewLastProjectSubmissionForEachGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        Project project = this.getProject(request);
        ArrayList<ProjectSubmission> projectSubmissions = new ArrayList<ProjectSubmission>(project.getLastProjectSubmissionForEachStudentGroup());
        ArrayList<ProjectSubmission> deletedGroupsProjectSubmissions = new ArrayList<ProjectSubmission>(project.getLastProjectSubmissionForEachDeletedStudentGroup());
        Collections.sort(projectSubmissions, ProjectSubmission.COMPARATOR_BY_GROUP_NUMBER_AND_MOST_RECENT_SUBMISSION_DATE);
        Collections.sort(deletedGroupsProjectSubmissions, ProjectSubmission.COMPARATOR_BY_GROUP_NUMBER_AND_MOST_RECENT_SUBMISSION_DATE);
        this.setRequestParameters(request, project, projectSubmissions, null);
        request.setAttribute("deletedStudentGroupProjectSubmissions", deletedGroupsProjectSubmissions);
        return this.doForward(request, "/teacher/evaluation/viewLastProjectSubmissionForEachGroup.jsp");
    }

    public ActionForward viewProjectSubmissionsByGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        Project project = this.getProject(request);
        ArrayList<ProjectSubmission> projectSubmissions = new ArrayList<ProjectSubmission>(project.getProjectSubmissionsByStudentGroup(this.getStudentGroup(request)));
        Collections.sort(projectSubmissions, ProjectSubmission.COMPARATOR_BY_MOST_RECENT_SUBMISSION_DATE);
        ArrayList<ProjectSubmissionLog> projectSubmissionLogs = new ArrayList<ProjectSubmissionLog>(project.getProjectSubmissionLogsByStudentGroup(this.getStudentGroup(request)));
        Collections.sort(projectSubmissionLogs, ProjectSubmissionLog.COMPARATOR_BY_MOST_RECENT_SUBMISSION_DATE);
        this.setRequestParameters(request, project, projectSubmissions, projectSubmissionLogs);
        return this.doForward(request, "/teacher/evaluation/viewProjectSubmissionsByGroup.jsp");
    }

    public ActionForward downloadProjectsInZipFormat(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, IOException, ServletException {
        Project project = this.getProject(request);
        ArrayList<ProjectSubmission> projectSubmissions = new ArrayList<ProjectSubmission>(project.getLastProjectSubmissionForEachStudentGroup());
        try (ZipOutputStream stream = new ZipOutputStream((OutputStream)response.getOutputStream());){
            response.setContentType("application/zip");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + project.getName() + ".zip\"");
            for (ProjectSubmission submission : projectSubmissions) {
                StudentGroup group = submission.getStudentGroup();
                ZipEntry zipEntry = new ZipEntry(group.getGroupNumber() + this.getStudentsISTID(group) + "/" + submission.getProjectSubmissionFile().getFilename());
                stream.putNextEntry(zipEntry);
                stream.write(submission.getProjectSubmissionFile().getContent());
                stream.closeEntry();
            }
        }
        return null;
    }

    public ActionForward prepareSelectiveDownload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, IOException, ServletException {
        IViewState viewState = RenderUtils.getViewState((String)"selectiveDownload");
        Integer value = viewState != null ? (Integer)viewState.getMetaObject().getObject() : null;
        VariantBean bean = new VariantBean();
        bean.setInteger(value);
        Project project = this.getProject(request);
        if (bean.getInteger() != null) {
            ArrayList<ProjectSubmission> projectSubmissions = new ArrayList<ProjectSubmission>(project.getLastProjectSubmissionForEachStudentGroup());
            Collections.sort(projectSubmissions, ProjectSubmission.COMPARATOR_BY_MOST_RECENT_SUBMISSION_DATE);
            this.setRequestParameters(request, project, projectSubmissions, null);
        } else {
            this.setRequestParameters(request, project, null, null);
        }
        request.setAttribute("bean", (Object)bean);
        return this.doForward(request, "/teacher/evaluation/selectiveDownload.jsp");
    }

    public ActionForward selectiveDownload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, IOException, ServletException {
        Project project = this.getProject(request);
        Integer startIndex = Integer.valueOf(request.getParameter("startIndex"));
        Integer pageSize = Integer.valueOf(request.getParameter("size"));
        ArrayList<ProjectSubmission> projectSubmissions = new ArrayList<ProjectSubmission>(project.getLastProjectSubmissionForEachStudentGroup());
        Collections.sort(projectSubmissions, ProjectSubmission.COMPARATOR_BY_MOST_RECENT_SUBMISSION_DATE);
        Integer finishIndex = Math.min(projectSubmissions.size(), startIndex + pageSize);
        List subList = projectSubmissions.subList(startIndex, finishIndex);
        try (ZipOutputStream stream = new ZipOutputStream((OutputStream)response.getOutputStream());){
            response.setContentType("application/zip");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + project.getName() + "-" + (startIndex + 1) + "-" + finishIndex + ".zip\"");
            for (ProjectSubmission submission : subList) {
                StudentGroup group = submission.getStudentGroup();
                ZipEntry zipEntry = new ZipEntry(group.getGroupNumber() + this.getStudentsISTID(group) + "/" + submission.getProjectSubmissionFile().getFilename());
                stream.putNextEntry(zipEntry);
                stream.write(submission.getProjectSubmissionFile().getContent());
                stream.closeEntry();
            }
        }
        return null;
    }

    public ActionForward prepareGroupComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Project project = this.getProject(request);
        request.setAttribute("projectSubmission", (Object)project.getLastProjectSubmissionForStudentGroup(this.getStudentGroup(request)));
        this.setRequestParameters(request, project, null, null);
        return this.doForward(request, "/teacher/evaluation/editProjectObservations.jsp");
    }

    public ActionForward sendCommentThroughEmail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        Project project = this.getProject(request);
        ExecutionCourse course = (ExecutionCourse)FenixFramework.getDomainObject((String)this.getExecutionCourseID(request));
        NotifyStudentGroup.run(project.getLastProjectSubmissionForStudentGroup(this.getStudentGroup(request)), course, this.getLoggedPerson(request));
        return this.prepareGroupComment(mapping, form, request, response);
    }

    private void setRequestParameters(HttpServletRequest request, Project project, List<ProjectSubmission> projectSubmissions, List<ProjectSubmissionLog> projectSubmissionLogs) {
        request.setAttribute("executionCourseID", (Object)this.getExecutionCourseID(request));
        request.setAttribute("project", (Object)project);
        request.setAttribute("projectSubmissions", projectSubmissions);
        request.setAttribute("projectSubmissionLogs", projectSubmissionLogs);
    }

    private StudentGroup getStudentGroup(HttpServletRequest request) {
        return (StudentGroup)((Object)this.getDomainObject(request, "studentGroupID"));
    }

    private Project getProject(HttpServletRequest request) {
        String projectExtId = request.getParameter("projectOID");
        if (projectExtId != null) {
            Project project = (Project)FenixFramework.getDomainObject((String)projectExtId);
            request.setAttribute("projectID", (Object)project.getExternalId().toString());
            return project;
        }
        Person person = ProjectSubmissionsManagementDispatchAction.getUserView(request).getPerson();
        String projectId = request.getParameter("projectID");
        for (Professorship professorship : person.getProfessorshipsSet()) {
            for (Project project : professorship.getExecutionCourse().getAssociatedProjects()) {
                if (!project.getExternalId().equals(projectId)) continue;
                request.setAttribute("projectOID", (Object)project.getExternalId());
                return project;
            }
        }
        return null;
    }

    private String getExecutionCourseID(HttpServletRequest request) {
        return request.getParameter("executionCourseID");
    }

    private String getStudentsISTID(StudentGroup group) {
        ArrayList sortedAttends = new ArrayList(group.getAttendsSet());
        Collections.sort(sortedAttends, Attends.COMPARATOR_BY_STUDENT_NUMBER);
        String studentsISTID = "";
        for (Attends attends : sortedAttends) {
            studentsISTID = studentsISTID + "-" + attends.getAluno().getStudent().getPerson().getUsername();
        }
        return studentsISTID;
    }
}

