/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student.residence;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.ResidenceEvent;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.student.StudentApplication;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=StudentApplication.StudentViewApp.class, path="residence-payments", titleKey="link.title.residencePayments")
@Mapping(path="/viewResidencePayments", module="student")
@Forwards(value={@Forward(name="showEvents", path="/student/residenceServices/showResidenceEvents.jsp"), @Forward(name="eventDetails", path="/student/residenceServices/showDetails.jsp")})
public class ViewResidencePayments
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward listEvents(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = this.getLoggedPerson(request);
        request.setAttribute("person", (Object)person);
        request.setAttribute("payedEntries", person.getPayments(ResidenceEvent.class));
        request.setAttribute("notPayedEvents", person.getNotPayedEventsPayableOn(null, ResidenceEvent.class, false));
        return mapping.findForward("showEvents");
    }

    public ActionForward showEventDetails(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String eventOID = request.getParameter("event");
        ResidenceEvent residenceEvent = (ResidenceEvent)FenixFramework.getDomainObject((String)eventOID);
        request.setAttribute("person", (Object)this.getLoggedPerson(request));
        request.setAttribute("event", (Object)residenceEvent);
        request.setAttribute("entryDTOs", (Object)residenceEvent.calculateEntries());
        request.setAttribute("accountingEventPaymentCodes", (Object)residenceEvent.getNonProcessedPaymentCodes());
        return mapping.findForward("eventDetails");
    }
}

