/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EntryPhase;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.dto.resourceAllocationManager.FirstYearShiftsBean;
import org.fenixedu.academic.ui.struts.action.base.FenixContextDispatchAction;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.RAMApplication;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.Spreadsheet;

@StrutsFunctionality(app=RAMApplication.RAMFirstYearShiftsApp.class, path="export-shifts", titleKey="link.firstYearShifts.export")
@Mapping(module="resourceAllocationManager", path="/exportFirstYearShifts")
@Forwards(value={@Forward(name="chooseExport", path="/resourceAllocationManager/exportFirstYearShifts_bd.jsp")})
public class ExportFirstYearShiftsDA
extends FenixContextDispatchAction {
    @EntryPoint
    public ActionForward chooseExport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        FirstYearShiftsBean bean = (FirstYearShiftsBean)this.getRenderedObject();
        if (bean == null) {
            bean = new FirstYearShiftsBean();
        }
        request.setAttribute("first_year_shifts_export", (Object)bean);
        return mapping.findForward("chooseExport");
    }

    public ActionForward export(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        FirstYearShiftsBean bean = (FirstYearShiftsBean)this.getRenderedObject();
        if (bean == null) {
            return this.chooseExport(mapping, form, request, response);
        }
        AcademicInterval executionYear = bean.getExecutionYear().getAcademicInterval();
        EntryPhase phase = bean.getEntryPhase();
        List<Degree> degrees = Degree.readAllMatching(DegreeType.oneOf(DegreeType::isBolonhaDegree, DegreeType::isIntegratedMasterDegree));
        if (executionYear == null) {
            return this.chooseExport(mapping, form, request, response);
        }
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=occupationMap_" + executionYear.getPresentationName().replace('/', '_') + " " + phase.getLocalizedName() + ".xls");
        Spreadsheet spreadsheet = new Spreadsheet("Shifts");
        this.addHeader(spreadsheet, phase);
        for (Degree degree : degrees) {
            for (DegreeCurricularPlan degreeCurricularPlan : degree.getActiveDegreeCurricularPlans()) {
                ExecutionDegree executionDegree = degreeCurricularPlan.getExecutionDegreeByAcademicInterval(executionYear);
                if (executionDegree == null) continue;
                for (SchoolClass schoolClass : executionDegree.getSchoolClassesSet()) {
                    if (!schoolClass.getAnoCurricular().equals(1) || !schoolClass.getExecutionPeriod().isFirstOfYear()) continue;
                    for (Shift shift : schoolClass.getAssociatedShiftsSet()) {
                        ExecutionCourse executionCourse = shift.getExecutionCourse();
                        String ecName = executionCourse.getNome();
                        this.addRow(spreadsheet, degreeCurricularPlan, executionCourse, schoolClass, shift, phase);
                    }
                }
            }
        }
        ServletOutputStream writer = response.getOutputStream();
        spreadsheet.exportToXLSSheet((OutputStream)writer);
        writer.flush();
        response.flushBuffer();
        return null;
    }

    private void addHeader(Spreadsheet spreadsheet, EntryPhase phase) {
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ResourceAllocationManagerResources", (String)"label.manager.degree.name", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ResourceAllocationManagerResources", (String)"label.class", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ResourceAllocationManagerResources", (String)"property.executionCourse.name", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ResourceAllocationManagerResources", (String)"property.shift", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ResourceAllocationManagerResources", (String)"property.shift.type", (String[])new String[0]));
        spreadsheet.setHeader(BundleUtil.getString((String)"resources.ResourceAllocationManagerResources", (String)"property.shift.capacity", (String[])new String[0]));
        if (!phase.equals((Object)EntryPhase.FIRST_PHASE)) {
            spreadsheet.setHeader(BundleUtil.getString((String)"resources.ResourceAllocationManagerResources", (String)"property.shift.ocupation", (String[])new String[0]));
        }
    }

    private void addRow(Spreadsheet spreadsheet, DegreeCurricularPlan degreeCurricularPlan, ExecutionCourse executionCourse, SchoolClass schoolClass, Shift shift, EntryPhase phase) {
        Spreadsheet.Row row = spreadsheet.addRow();
        row.setCell(degreeCurricularPlan.getName());
        row.setCell(schoolClass.getNome());
        row.setCell(executionCourse.getNome());
        row.setCell(shift.getNome());
        row.setCell(shift.getShiftTypesPrettyPrint());
        int capacity = shift.getLotacao() - shift.getStudentsSet().size();
        if (phase.equals((Object)EntryPhase.FIRST_PHASE)) {
            row.setCell(String.valueOf(capacity < 0 ? capacity * -1 : capacity));
        } else {
            row.setCell(String.valueOf(capacity));
        }
        if (!phase.equals((Object)EntryPhase.FIRST_PHASE)) {
            row.setCell(String.valueOf(shift.getStudentsSet().size()));
        }
    }
}

