/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.studentEnrolment.bolonha;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceEvent;
import org.fenixedu.academic.domain.accounting.events.AnnualEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.events.insurance.InsuranceEvent;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.StudentStatute;
import org.fenixedu.academic.dto.student.enrollment.bolonha.SpecialSeasonBolonhaStudentEnrolmentBean;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.studentEnrolment.bolonha.AcademicAdminOfficeBolonhaStudentEnrollmentDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;

@Mapping(path="/specialSeasonBolonhaStudentEnrollment", module="academicAdministration", formBean="bolonhaStudentEnrollmentForm", functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="showDegreeModulesToEnrol", path="/academicAdminOffice/student/enrollment/bolonha/showDegreeModulesToEnrol.jsp"), @Forward(name="showStudentEnrollmentMenu", path="/academicAdministration/studentEnrolments.do?method=prepareFromStudentEnrollmentWithRules"), @Forward(name="changeSpecialSeasonCode", path="/academicAdminOffice/student/enrollment/bolonha/chooseSpecialSeasonCode.jsp")})
public class AcademicAdminOfficeSpecialSeasonBolonhaStudentEnrolmentDA
extends AcademicAdminOfficeBolonhaStudentEnrollmentDA {
    @Override
    protected CurricularRuleLevel getCurricularRuleLevel(ActionForm form) {
        return CurricularRuleLevel.SPECIAL_SEASON_ENROLMENT;
    }

    @Override
    protected ActionForward prepareShowDegreeModulesToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester) {
        request.setAttribute("action", (Object)this.getAction());
        request.setAttribute("bolonhaStudentEnrollmentBean", (Object)new SpecialSeasonBolonhaStudentEnrolmentBean(studentCurricularPlan, executionSemester));
        this.addDebtsWarningMessages(studentCurricularPlan.getRegistration().getStudent(), executionSemester, request);
        return mapping.findForward("showDegreeModulesToEnrol");
    }

    @Override
    protected void addDebtsWarningMessages(Student student, ExecutionSemester executionSemester, HttpServletRequest request) {
        if (this.hasAnyAdministrativeOfficeFeeAndInsuranceInDebt(student, executionSemester.getExecutionYear())) {
            this.addActionMessage("warning", request, "registration.has.not.payed.insurance.fees");
        }
        if (this.hasAnyGratuityDebt(student, executionSemester.getExecutionYear())) {
            this.addActionMessage("warning", request, "registration.has.not.payed.gratuities");
        }
    }

    protected boolean hasAnyAdministrativeOfficeFeeAndInsuranceInDebt(Student student, ExecutionYear executionYear) {
        for (Event event : student.getPerson().getEventsSet()) {
            AnnualEvent annualEvent;
            if (event instanceof AnnualEvent && (annualEvent = (AnnualEvent)((Object)event)).getExecutionYear().isAfter(executionYear) || !(event instanceof AdministrativeOfficeFeeAndInsuranceEvent) && !(event instanceof InsuranceEvent) || !event.isOpen()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasAnyGratuityDebt(Student student, ExecutionYear executionYear) {
        for (Registration registration : student.getRegistrationsSet()) {
            for (StudentCurricularPlan studentCurricularPlan : registration.getStudentCurricularPlansSet()) {
                for (GratuityEvent gratuityEvent : studentCurricularPlan.getGratuityEventsSet()) {
                    if (!gratuityEvent.getExecutionYear().isBeforeOrEquals(executionYear) || !gratuityEvent.isInDebt()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected String getAction() {
        return "/specialSeasonBolonhaStudentEnrollment.do";
    }

    public ActionForward checkPermission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        StudentCurricularPlan studentCurricularPlan = this.getStudentCurricularPlan(request);
        ExecutionSemester executionSemester = this.getExecutionPeriod(request);
        if (!this.hasStatute(studentCurricularPlan.getRegistration().getStudent(), executionSemester, studentCurricularPlan.getRegistration()) && !studentCurricularPlan.getRegistration().getStudent().isSenior(executionSemester.getExecutionYear())) {
            this.addActionMessage(request, "error.special.season.not.granted");
            request.setAttribute("studentCurricularPlan", (Object)studentCurricularPlan);
            request.setAttribute("executionPeriod", (Object)executionSemester);
            return mapping.findForward("showStudentEnrollmentMenu");
        }
        request.setAttribute("action", (Object)this.getAction());
        request.setAttribute("bolonhaStudentEnrollmentBean", (Object)new SpecialSeasonBolonhaStudentEnrolmentBean(studentCurricularPlan, executionSemester));
        this.addDebtsWarningMessages(studentCurricularPlan.getRegistration().getStudent(), executionSemester, request);
        return mapping.findForward("showDegreeModulesToEnrol");
    }

    protected boolean hasStatute(Student student, ExecutionSemester executionSemester, Registration registration) {
        Set statutes = student.getStudentStatutesSet();
        for (StudentStatute statute : statutes) {
            if (!statute.getType().isSpecialSeasonGranted() && !statute.hasSeniorStatuteForRegistration(registration) || !statute.isValidInExecutionPeriod(executionSemester)) continue;
            return true;
        }
        return false;
    }
}

