/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.student;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.Credits;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.fenixedu.academic.dto.administrativeOffice.dismissal.CreditsBean;
import org.fenixedu.academic.dto.administrativeOffice.dismissal.DismissalBean;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.administrativeOffice.dismissal.DeleteCredits;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/studentDismissals", module="academicAdministration", formBean="studentDismissalForm", functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="manage", path="/academicAdminOffice/dismissal/managementDismissals.jsp"), @Forward(name="chooseEquivalents", path="/academicAdminOffice/dismissal/chooseEquivalents.jsp"), @Forward(name="visualizeRegistration", path="/academicAdministration/student.do?method=visualizeRegistration"), @Forward(name="chooseDismissalEnrolments", path="/academicAdminOffice/dismissal/chooseDismissalEnrolments.jsp"), @Forward(name="confirmCreateDismissals", path="/academicAdminOffice/dismissal/confirmCreateDismissals.jsp"), @Forward(name="editCredits", path="/academicAdminOffice/dismissal/editCredits.jsp")})
public class StudentDismissalsDA
extends FenixDispatchAction {
    private StudentCurricularPlan getSCP(HttpServletRequest request) {
        return (StudentCurricularPlan)((Object)this.getDomainObject(request, "scpID"));
    }

    @EntryPoint
    public ActionForward manage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("studentCurricularPlan", (Object)this.getSCP(request));
        return mapping.findForward("manage");
    }

    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DismissalBean dismissalBean = this.createDismissalBean();
        dismissalBean.setStudentCurricularPlan(this.getSCP(request));
        request.setAttribute("dismissalBean", (Object)dismissalBean);
        dismissalBean.setEnrolments(this.buildStudentEnrolmentsInformation(dismissalBean));
        dismissalBean.setExternalEnrolments(this.buildStudentExternalEnrolmentsInformation(dismissalBean));
        return mapping.findForward("chooseDismissalEnrolments");
    }

    protected DismissalBean createDismissalBean() {
        return new DismissalBean();
    }

    protected Collection<DismissalBean.SelectedExternalEnrolment> buildStudentExternalEnrolmentsInformation(DismissalBean dismissalBean) {
        HashSet<DismissalBean.SelectedExternalEnrolment> externalEnrolments = new HashSet<DismissalBean.SelectedExternalEnrolment>();
        for (ExternalEnrolment externalEnrolment : dismissalBean.getStudentCurricularPlan().getRegistration().getStudent().getSortedExternalEnrolments()) {
            externalEnrolments.add(new DismissalBean.SelectedExternalEnrolment(externalEnrolment));
        }
        return externalEnrolments;
    }

    protected Collection<DismissalBean.SelectedEnrolment> buildStudentEnrolmentsInformation(DismissalBean dismissalBean) {
        HashSet<DismissalBean.SelectedEnrolment> enrolments = new HashSet<DismissalBean.SelectedEnrolment>();
        for (StudentCurricularPlan scp : dismissalBean.getStudent().getAllStudentCurricularPlans()) {
            if (scp.equals((Object)dismissalBean.getStudentCurricularPlan())) continue;
            ArrayList<Enrolment> approvedEnrolments = new ArrayList<Enrolment>(scp.getDismissalApprovedEnrolments());
            Collections.sort(approvedEnrolments, Enrolment.COMPARATOR_BY_EXECUTION_YEAR_AND_NAME_AND_ID);
            for (Enrolment enrolment : approvedEnrolments) {
                enrolments.add(new DismissalBean.SelectedEnrolment(enrolment));
            }
        }
        return enrolments;
    }

    public ActionForward chooseEquivalents(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DismissalBean dismissalBean = (DismissalBean)this.getRenderedObject("dismissalBean");
        dismissalBean.setDismissalType(DismissalBean.DismissalType.CURRICULAR_COURSE_CREDITS);
        DegreeCurricularPlan dcp = dismissalBean.getStudentCurricularPlan().getDegreeCurricularPlan();
        ExecutionSemester actualEP = ExecutionSemester.readActualExecutionSemester();
        dismissalBean.setExecutionPeriod(dcp.hasExecutionDegreeFor(actualEP.getExecutionYear()) ? actualEP : dcp.getMostRecentExecutionYear().getFirstExecutionPeriod());
        request.setAttribute("dismissalBean", (Object)dismissalBean);
        return mapping.findForward("chooseEquivalents");
    }

    public ActionForward dismissalTypePostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DismissalBean dismissalBean = (DismissalBean)this.getRenderedObject();
        dismissalBean.setCredits(null);
        dismissalBean.setCourseGroup(null);
        dismissalBean.setDismissals(null);
        dismissalBean.setCurriculumGroup(null);
        RenderUtils.invalidateViewState();
        request.setAttribute("dismissalBean", (Object)dismissalBean);
        return mapping.findForward("chooseEquivalents");
    }

    private void checkArguments(HttpServletRequest request, DismissalBean dismissalBean) throws FenixActionException {
        if (dismissalBean.getDismissalType() == DismissalBean.DismissalType.CURRICULAR_COURSE_CREDITS) {
            if (!dismissalBean.hasAnyDismissals() && !dismissalBean.hasAnyOptionalDismissals()) {
                this.addActionMessage("error", request, "error.studentDismissal.curricularCourse.required");
                throw new FenixActionException();
            }
        } else if (dismissalBean.getDismissalType() == DismissalBean.DismissalType.CURRICULUM_GROUP_CREDITS) {
            if (dismissalBean.getCourseGroup() == null) {
                this.addActionMessage("error", request, "error.studentDismissal.curriculumGroup.required");
                throw new FenixActionException();
            }
        } else if (dismissalBean.getCurriculumGroup() == null) {
            this.addActionMessage("error", request, "error.studentDismissal.curriculumGroup.required");
            throw new FenixActionException();
        }
    }

    public ActionForward confirmCreateDismissals(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DismissalBean dismissalBean = (DismissalBean)this.getRenderedObject();
        request.setAttribute("dismissalBean", (Object)dismissalBean);
        try {
            this.checkArguments(request, dismissalBean);
        }
        catch (FenixActionException e) {
            return this.stepTwo(mapping, actionForm, request, response);
        }
        if (dismissalBean.getDismissalType() == DismissalBean.DismissalType.CURRICULAR_COURSE_CREDITS) {
            this.setCurriculumGroups(dismissalBean);
        }
        return mapping.findForward("confirmCreateDismissals");
    }

    private void setCurriculumGroups(DismissalBean dismissalBean) {
        block0: for (DismissalBean.SelectedCurricularCourse selectedCurricularCourse : dismissalBean.getDismissals()) {
            Collection<CurriculumGroup> curricularCoursePossibleGroups = dismissalBean.getStudentCurricularPlan().getCurricularCoursePossibleGroups(selectedCurricularCourse.getCurricularCourse());
            if (curricularCoursePossibleGroups.isEmpty()) continue;
            if (curricularCoursePossibleGroups.size() == 1) {
                selectedCurricularCourse.setCurriculumGroup(curricularCoursePossibleGroups.iterator().next());
                continue;
            }
            for (CurriculumGroup curriculumGroup : curricularCoursePossibleGroups) {
                if (curriculumGroup.isNoCourseGroupCurriculumGroup()) continue;
                selectedCurricularCourse.setCurriculumGroup(curriculumGroup);
                continue block0;
            }
        }
    }

    public ActionForward stepOne(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("dismissalBean", this.getRenderedObject());
        return mapping.findForward("chooseDismissalEnrolments");
    }

    public ActionForward stepTwo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("dismissalBean", this.getRenderedObject());
        return mapping.findForward("chooseEquivalents");
    }

    public ActionForward stepThree(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("dismissalBean", this.getRenderedObject());
        return mapping.findForward("confirmCreateDismissals");
    }

    public ActionForward createDismissals(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        DismissalBean dismissalBean = (DismissalBean)this.getRenderedObject();
        try {
            this.checkArguments(request, dismissalBean);
        }
        catch (FenixActionException e) {
            return this.stepTwo(mapping, form, request, response);
        }
        try {
            this.executeCreateDismissalService(dismissalBean);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            return this.confirmCreateDismissals(mapping, form, request, response);
        }
        return this.manage(mapping, form, request, response);
    }

    protected void executeCreateDismissalService(DismissalBean dismissalBean) throws FenixServiceException {
    }

    public ActionForward deleteCredits(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        String[] creditsIDs = ((DynaActionForm)form).getStrings("creditsToDelete");
        StudentCurricularPlan studentCurricularPlan = this.getSCP(request);
        try {
            DeleteCredits.run(studentCurricularPlan, creditsIDs);
        }
        catch (IllegalDataAccessException e) {
            this.addActionMessage(request, "error.notAuthorized");
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage());
        }
        request.setAttribute("studentCurricularPlan", (Object)studentCurricularPlan);
        return mapping.findForward("manage");
    }

    public ActionForward backViewRegistration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("registrationId", (Object)this.getSCP(request).getRegistration().getExternalId().toString());
        return mapping.findForward("visualizeRegistration");
    }

    public ActionForward prepareChooseNotNeedToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("dismissalBean", this.getRenderedObject());
        return mapping.findForward("chooseNotNeedToEnrol");
    }

    public ActionForward prepareEditCredits(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("creditsBean", (Object)new CreditsBean((Credits)((Object)this.getDomainObject(request, "creditsId"))));
        return mapping.findForward("editCredits");
    }

    public ActionForward prepareEditCreditsInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("creditsBean", this.getRenderedObject("creditsBean"));
        return mapping.findForward("editCredits");
    }

    public ActionForward editCredits(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CreditsBean bean = (CreditsBean)this.getRenderedObject("creditsBean");
        try {
            this.atomic(() -> bean.getCredits().setOfficialDate(bean.getOfficialDate()));
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey(), e.getArgs());
            request.setAttribute("creditsBean", (Object)bean);
            return mapping.findForward("edit");
        }
        request.setAttribute("scpID", (Object)bean.getCredits().getStudentCurricularPlan().getExternalId());
        return this.manage(mapping, form, request, response);
    }
}

