/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.externalUnits;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExternalCurricularCourse;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitUtils;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.fenixedu.academic.dto.administrativeOffice.externalUnits.CreateExternalCurricularCourseBean;
import org.fenixedu.academic.dto.administrativeOffice.externalUnits.CreateExternalUnitBean;
import org.fenixedu.academic.dto.administrativeOffice.externalUnits.EditExternalCurricularCourseBean;
import org.fenixedu.academic.dto.administrativeOffice.externalUnits.EditExternalEnrolmentBean;
import org.fenixedu.academic.dto.administrativeOffice.externalUnits.EditExternalUnitBean;
import org.fenixedu.academic.dto.administrativeOffice.externalUnits.ExternalCurricularCourseResultBean;
import org.fenixedu.academic.dto.administrativeOffice.externalUnits.ExternalUnitResultBean;
import org.fenixedu.academic.dto.administrativeOffice.externalUnits.ExternalUnitsSearchBean;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.administrativeOffice.externalUnits.CreateExternalCurricularCourse;
import org.fenixedu.academic.service.services.administrativeOffice.externalUnits.CreateExternalUnit;
import org.fenixedu.academic.service.services.administrativeOffice.externalUnits.DeleteExternalCurricularCourse;
import org.fenixedu.academic.service.services.administrativeOffice.externalUnits.DeleteExternalUnit;
import org.fenixedu.academic.service.services.administrativeOffice.externalUnits.EditExternalCurricularCourse;
import org.fenixedu.academic.service.services.administrativeOffice.externalUnits.EditExternalEnrolment;
import org.fenixedu.academic.service.services.administrativeOffice.externalUnits.EditExternalUnit;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminInstitutionsApp.class, path="external-units", titleKey="label.externalUnits", accessGroup="academic(MANAGE_EXTERNAL_UNITS)")
@Mapping(path="/externalUnits", module="academicAdministration", formBean="externalUnitsForm")
@Forwards(value={@Forward(name="searchExternalUnits", path="/academicAdminOffice/externalUnits/searchExternalUnit.jsp"), @Forward(name="viewCountryUnit", path="/academicAdminOffice/externalUnits/viewCountryUnit.jsp"), @Forward(name="viewUniversityUnit", path="/academicAdminOffice/externalUnits/viewUniversityUnit.jsp"), @Forward(name="viewSchoolUnit", path="/academicAdminOffice/externalUnits/viewSchoolUnit.jsp"), @Forward(name="viewDepartmentUnit", path="/academicAdminOffice/externalUnits/viewDepartmentUnit.jsp"), @Forward(name="viewExternalCurricularCourse", path="/academicAdminOffice/externalUnits/viewExternalCurricularCourse.jsp"), @Forward(name="prepareCreateUnit", path="/academicAdminOffice/externalUnits/createExternalUnit.jsp"), @Forward(name="prepareEditUnit", path="/academicAdminOffice/externalUnits/editExternalUnit.jsp"), @Forward(name="prepareDeleteUnit", path="/academicAdminOffice/externalUnits/deleteExternalUnit.jsp"), @Forward(name="prepareDeleteExternalCurricularCourse", path="/academicAdminOffice/externalUnits/deleteExternalCurricularCourse.jsp"), @Forward(name="prepareCreateExternalCurricularCourse", path="/academicAdminOffice/externalUnits/createExternalCurricularCourse.jsp"), @Forward(name="prepareEditExternalCurricularCourse", path="/academicAdminOffice/externalUnits/editExternalCurricularCourse.jsp"), @Forward(name="prepareEditExternalEnrolment", path="/academicAdminOffice/externalUnits/editExternalEnrolment.jsp")})
public class ExternalUnitsDispatchAction
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepareSearch(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("searchBean", (Object)new ExternalUnitsSearchBean());
        return mapping.findForward("searchExternalUnits");
    }

    public ActionForward search(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ExternalUnitsSearchBean searchBean = (ExternalUnitsSearchBean)this.getRenderedObject();
        request.setAttribute("searchBean", (Object)searchBean);
        if (StringUtils.isEmpty((String)searchBean.getUnitName())) {
            this.addActionMessage("error", request, "error.externalUnits.invalid.unit.name");
        } else {
            searchBean.clearResults();
            this.searchUnits(searchBean);
            this.searchExternalCurricularCourses(searchBean);
            Collections.sort(searchBean.getResults(), new BeanComparator("fullName"));
            searchBean.setEarthUnit(UnitUtils.readEarthUnit());
        }
        return mapping.findForward("searchExternalUnits");
    }

    private String buildNameToSearch(String name) {
        String result = name.replaceAll("[ ]", "%");
        result = !name.startsWith("%") ? "%" + result : result;
        result = !name.endsWith("%") ? result + "%" : result;
        return result;
    }

    private void searchUnits(ExternalUnitsSearchBean searchBean) {
        for (Unit unit : UnitUtils.readExternalUnitsByNameAndTypesStartingAtEarth(this.buildNameToSearch(searchBean.getUnitName()), this.getUnitTypes(searchBean))) {
            searchBean.add(new ExternalUnitResultBean(unit));
        }
    }

    private void searchExternalCurricularCourses(ExternalUnitsSearchBean searchBean) {
        for (ExternalCurricularCourse externalCurricularCourse : ExternalCurricularCourse.readByName(this.buildNameToSearch(searchBean.getUnitName()))) {
            searchBean.add(new ExternalCurricularCourseResultBean(externalCurricularCourse));
        }
    }

    private List<PartyTypeEnum> getUnitTypes(ExternalUnitsSearchBean searchBean) {
        return searchBean.getUnitType() == null ? searchBean.getValidPartyTypes() : Collections.singletonList(searchBean.getUnitType());
    }

    public ActionForward viewUnit(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Unit unit = this.getUnit(request);
        return this.viewUnit(mapping, request, unit);
    }

    private ActionForward viewUnit(ActionMapping mapping, HttpServletRequest request, Unit unit) {
        if (unit.isPlanetUnit()) {
            request.setAttribute("searchBean", (Object)new ExternalUnitsSearchBean());
            return mapping.findForward("searchExternalUnits");
        }
        request.setAttribute("unitResultBean", (Object)new ExternalUnitResultBean(unit));
        this.buildUnitBean(request, unit);
        return mapping.findForward(this.findForwardNameFor(unit));
    }

    private void buildUnitBean(HttpServletRequest request, Unit unit) {
        switch (unit.getType()) {
            case COUNTRY: {
                request.setAttribute("universities", ExternalUnitResultBean.buildFrom(unit, PartyTypeEnum.UNIVERSITY));
            }
            case UNIVERSITY: {
                request.setAttribute("schools", ExternalUnitResultBean.buildFrom(unit, PartyTypeEnum.SCHOOL));
            }
            case SCHOOL: {
                request.setAttribute("departments", ExternalUnitResultBean.buildFrom(unit, PartyTypeEnum.DEPARTMENT));
            }
            case DEPARTMENT: {
                request.setAttribute("externalCurricularCourses", ExternalCurricularCourseResultBean.buildFrom(unit));
            }
        }
    }

    private String findForwardNameFor(Unit unit) {
        switch (unit.getType()) {
            case COUNTRY: {
                return "viewCountryUnit";
            }
            case UNIVERSITY: {
                return "viewUniversityUnit";
            }
            case SCHOOL: {
                return "viewSchoolUnit";
            }
            case DEPARTMENT: {
                return "viewDepartmentUnit";
            }
        }
        return null;
    }

    private Unit getUnit(HttpServletRequest request) {
        return (Unit)((Object)this.getDomainObject(request, "oid"));
    }

    public ActionForward prepareCreateCountry(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareCreateUnit(mapping, actionForm, request, response, PartyTypeEnum.COUNTRY);
    }

    public ActionForward prepareCreateUniversity(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareCreateUnit(mapping, actionForm, request, response, PartyTypeEnum.UNIVERSITY);
    }

    public ActionForward prepareCreateSchool(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareCreateUnit(mapping, actionForm, request, response, PartyTypeEnum.SCHOOL);
    }

    public ActionForward prepareCreateDepartment(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareCreateUnit(mapping, actionForm, request, response, PartyTypeEnum.DEPARTMENT);
    }

    private ActionForward prepareCreateUnit(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, PartyTypeEnum type) {
        request.setAttribute("createUnitBean", (Object)new CreateExternalUnitBean(this.getUnit(request), type));
        return mapping.findForward("prepareCreateUnit");
    }

    public ActionForward prepareEditUnit(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("editUnitBean", (Object)new EditExternalUnitBean(this.getUnit(request)));
        return mapping.findForward("prepareEditUnit");
    }

    public ActionForward prepareDeleteUnit(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("unit", (Object)this.getUnit(request));
        return mapping.findForward("prepareDeleteUnit");
    }

    public ActionForward createExternalUnit(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CreateExternalUnitBean externalUnitBean = (CreateExternalUnitBean)this.getRenderedObject();
        try {
            Unit unit = CreateExternalUnit.run(externalUnitBean);
            String oid = !externalUnitBean.getParentUnit().isPlanetUnit() ? externalUnitBean.getParentUnit().getExternalId() : unit.getExternalId();
            request.setAttribute("oid", (Object)oid);
            return this.viewUnit(mapping, actionForm, request, response);
        }
        catch (NotAuthorizedException e) {
            this.addActionMessage("error", request, "error.notAuthorized");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage());
        }
        request.setAttribute("createUnitBean", (Object)externalUnitBean);
        return mapping.findForward("prepareCreateUnit");
    }

    public ActionForward editExternalUnit(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        EditExternalUnitBean externalUnitBean = (EditExternalUnitBean)this.getRenderedObject();
        try {
            EditExternalUnit.run(externalUnitBean);
            request.setAttribute("oid", (Object)externalUnitBean.getExternalUnit().getExternalId());
            return this.viewUnit(mapping, actionForm, request, response);
        }
        catch (IllegalDataAccessException e) {
            this.addActionMessage("error", request, "error.notAuthorized");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage());
        }
        request.setAttribute("editUnitBean", (Object)externalUnitBean);
        return mapping.findForward("prepareCreateUnit");
    }

    public ActionForward deleteExternalUnit(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        Unit unit = this.getUnit(request);
        Unit parent = this.getAnyParentUnit(unit);
        try {
            DeleteExternalUnit.run(unit);
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage());
            request.setAttribute("unit", (Object)unit);
            return mapping.findForward("prepareDeleteUnit");
        }
        return this.viewUnit(mapping, request, parent);
    }

    private Unit getAnyParentUnit(Unit unit) {
        return unit.getParentUnits().iterator().next();
    }

    public ActionForward prepareCreateExternalCurricularCourse(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("createExternalCurricularCourseBean", (Object)new CreateExternalCurricularCourseBean(this.getUnit(request)));
        return mapping.findForward("prepareCreateExternalCurricularCourse");
    }

    public ActionForward prepareEditExternalCurricularCourse(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("editExternalCurricularCourseBean", (Object)new EditExternalCurricularCourseBean(this.getExternalCurricularCourse(request)));
        return mapping.findForward("prepareEditExternalCurricularCourse");
    }

    public ActionForward prepareDeleteExternalCurricularCourse(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("externalCurricularCourse", (Object)this.getExternalCurricularCourse(request));
        return mapping.findForward("prepareDeleteExternalCurricularCourse");
    }

    public ActionForward createExternalCurricularCoursePostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("createExternalCurricularCourseBean", this.getRenderedObject());
        RenderUtils.invalidateViewState();
        return mapping.findForward("prepareCreateExternalCurricularCourse");
    }

    public ActionForward createExternalCurricularCourseInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("createExternalCurricularCourseBean", this.getRenderedObject());
        return mapping.findForward("prepareCreateExternalCurricularCourse");
    }

    public ActionForward createExternalCurricularCourse(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CreateExternalCurricularCourseBean externalCurricularCourseBean = (CreateExternalCurricularCourseBean)this.getRenderedObject();
        try {
            CreateExternalCurricularCourse.run(externalCurricularCourseBean);
            request.setAttribute("oid", (Object)externalCurricularCourseBean.getParentUnit().getExternalId());
            return this.viewUnit(mapping, actionForm, request, response);
        }
        catch (NotAuthorizedException e) {
            this.addActionMessage("error", request, "error.notAuthorized");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage());
        }
        request.setAttribute("createExternalCurricularCourseBean", (Object)externalCurricularCourseBean);
        return mapping.findForward("prepareCreateExternalCurricularCourse");
    }

    public ActionForward editExternalCurricularCoursePostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("editExternalCurricularCourseBean", this.getRenderedObject());
        RenderUtils.invalidateViewState();
        return mapping.findForward("prepareEditExternalCurricularCourse");
    }

    public ActionForward deleteExternalCurricularCourse(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        ExternalCurricularCourse externalCurricularCourse = this.getExternalCurricularCourse(request);
        Unit parent = externalCurricularCourse.getUnit();
        try {
            DeleteExternalCurricularCourse.run(externalCurricularCourse);
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage());
            request.setAttribute("externalCurricularCourse", (Object)this.getExternalCurricularCourse(request));
            return mapping.findForward("prepareDeleteExternalCurricularCourse");
        }
        return this.viewUnit(mapping, request, parent);
    }

    public ActionForward editExternalCurricularCourseInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("editExternalCurricularCourseBean", this.getRenderedObject());
        return mapping.findForward("prepareEditExternalCurricularCourse");
    }

    public ActionForward editExternalCurricularCourse(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        EditExternalCurricularCourseBean externalCurricularCourseBean = (EditExternalCurricularCourseBean)this.getRenderedObject();
        try {
            EditExternalCurricularCourse.run(externalCurricularCourseBean);
            request.setAttribute("oid", (Object)externalCurricularCourseBean.getExternalCurricularCourse().getExternalId());
            return this.viewExternalCurricularCourse(mapping, actionForm, request, response);
        }
        catch (IllegalDataAccessException e) {
            this.addActionMessage("error", request, "error.notAuthorized");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage());
        }
        request.setAttribute("editExternalCurricularCourseBean", (Object)externalCurricularCourseBean);
        return mapping.findForward("prepareCreateExternalCurricularCourse");
    }

    public ActionForward viewExternalCurricularCourse(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ExternalCurricularCourse externalCurricularCourse = this.getExternalCurricularCourse(request);
        request.setAttribute("externalCurricularCourseBean", (Object)new ExternalCurricularCourseResultBean(externalCurricularCourse));
        request.setAttribute("externalEnrolments", (Object)externalCurricularCourse.getExternalEnrolmentsSet());
        return mapping.findForward("viewExternalCurricularCourse");
    }

    private ExternalCurricularCourse getExternalCurricularCourse(HttpServletRequest request) {
        return (ExternalCurricularCourse)((Object)this.getDomainObject(request, "oid"));
    }

    public ActionForward prepareEditExternalEnrolment(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("externalEnrolmentBean", (Object)new EditExternalEnrolmentBean(this.getExternalEnrolment(request)));
        return mapping.findForward("prepareEditExternalEnrolment");
    }

    private ExternalEnrolment getExternalEnrolment(HttpServletRequest request) {
        return (ExternalEnrolment)this.getDomainObject(request, "oid");
    }

    public ActionForward editExternalEnrolment(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        EditExternalEnrolmentBean externalEnrolmentBean = (EditExternalEnrolmentBean)this.getRenderedObject();
        try {
            EditExternalEnrolment.run(externalEnrolmentBean, externalEnrolmentBean.getExternalEnrolment().getRegistration());
            request.setAttribute("oid", (Object)externalEnrolmentBean.getExternalCurricularCourse().getExternalId());
            return this.viewExternalCurricularCourse(mapping, actionForm, request, response);
        }
        catch (IllegalDataAccessException e) {
            this.addActionMessage("error", request, "error.notAuthorized");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage());
        }
        request.setAttribute("externalEnrolmentBean", (Object)externalEnrolmentBean);
        return mapping.findForward("prepareEditExternalEnrolment");
    }
}

