/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.academic.dto.manager.academicCalendarManagement.CalendarEntryBean;
import org.fenixedu.academic.service.services.manager.academicCalendarManagement.CreateAcademicCalendarEntry;
import org.fenixedu.academic.service.services.manager.academicCalendarManagement.DeleteAcademicCalendarEntry;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.util.renderer.GanttDiagram;
import org.fenixedu.academic.util.renderer.GanttDiagramEvent;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.DateTime;
import org.joda.time.Partial;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminCalendarsApp.class, path="manage", titleKey="title.academic.calendars.management", accessGroup="academic(MANAGE_ACADEMIC_CALENDARS)")
@Mapping(module="academicAdministration", path="/academicCalendarsManagement", input="/index.do", formBean="academicCalendarsManagementForm")
@Forwards(value={@Forward(name="viewAcademicCalendar", path="/academicAdministration/academicCalendarsManagement/viewAcademicCalendar.jsp"), @Forward(name="prepareCreateCalendarEntry", path="/academicAdministration/academicCalendarsManagement/createCalendarEntry.jsp"), @Forward(name="prepareChooseCalendar", path="/academicAdministration/academicCalendarsManagement/chooseCalendar.jsp")})
public class AcademicCalendarsManagementDA
extends FenixDispatchAction {
    public ActionForward prepareCreateAcademicCalendar(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Partial end;
        Partial begin;
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        if (currentExecutionYear != null) {
            begin = CalendarEntryBean.getPartialFromYearMonthDay(currentExecutionYear.getBeginDateYearMonthDay());
            end = CalendarEntryBean.getPartialFromYearMonthDay(currentExecutionYear.getEndDateYearMonthDay());
        } else {
            begin = CalendarEntryBean.getPartialFromYearMonthDay(new YearMonthDay());
            end = CalendarEntryBean.getPartialFromYearMonthDay(new YearMonthDay().plusMonths(3));
        }
        CalendarEntryBean bean = CalendarEntryBean.createAcademicCalendarBean(begin, end);
        request.setAttribute("parentEntryBean", (Object)bean);
        return mapping.findForward("prepareCreateCalendarEntry");
    }

    @EntryPoint
    public ActionForward prepareChooseCalendar(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Set academicCalendars = rootDomainObject.getAcademicCalendarsSet();
        request.setAttribute("academicCalendars", (Object)academicCalendars);
        return mapping.findForward("prepareChooseCalendar");
    }

    public ActionForward prepareViewAcademicCalendar(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Partial end;
        Partial begin;
        AcademicCalendarEntry academicCalendar = this.getAcademicCalendarEntryFromParameter(request);
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        if (currentExecutionYear != null) {
            begin = CalendarEntryBean.getPartialFromYearMonthDay(currentExecutionYear.getBeginDateYearMonthDay());
            end = CalendarEntryBean.getPartialFromYearMonthDay(currentExecutionYear.getEndDateYearMonthDay());
        } else {
            begin = CalendarEntryBean.getPartialFromYearMonthDay(new YearMonthDay().minusMonths(12));
            end = CalendarEntryBean.getPartialFromYearMonthDay(new YearMonthDay().plusMonths(12));
        }
        CalendarEntryBean bean = CalendarEntryBean.createCalendarEntryBeanToCreateEntry((AcademicCalendarRootEntry)((Object)academicCalendar), academicCalendar, begin, end);
        return this.generateGanttDiagram(mapping, request, bean);
    }

    public ActionForward viewAcademicCalendar(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        YearMonthDay endDate;
        CalendarEntryBean bean = (CalendarEntryBean)this.getRenderedObject("datesToDisplayID");
        YearMonthDay beginDate = bean.getBeginDateToDisplayInYearMonthDayFormat();
        if (beginDate.isAfter((ReadablePartial)(endDate = bean.getEndDateToDisplayInYearMonthDayFormat()))) {
            this.addActionMessage(request, "error.begin.after.end");
            ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
            Partial begin = CalendarEntryBean.getPartialFromYearMonthDay(currentExecutionYear.getBeginDateYearMonthDay());
            Partial end = CalendarEntryBean.getPartialFromYearMonthDay(currentExecutionYear.getEndDateYearMonthDay());
            bean = CalendarEntryBean.createCalendarEntryBeanToCreateEntry(bean.getRootEntry(), (AcademicCalendarEntry)((Object)bean.getRootEntry()), begin, end);
            RenderUtils.invalidateViewState((String)"datesToDisplayID");
            return this.generateGanttDiagram(mapping, request, bean);
        }
        return this.generateGanttDiagram(mapping, request, bean);
    }

    public ActionForward gotBackToViewEntry(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CalendarEntryBean bean = (CalendarEntryBean)this.getRenderedObject();
        return this.generateGanttDiagram(mapping, request, bean);
    }

    public ActionForward viewAcademicCalendarEntry(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AcademicCalendarEntry entry = this.getAcademicCalendarEntryFromParameter(request);
        AcademicCalendarRootEntry rootEntry = this.getAcademicCalendarRootEntryFromParameter(request);
        Partial beginPartial = this.getBeginFromParameter(request);
        Partial endPartial = this.getEndFromParameter(request);
        CalendarEntryBean bean = CalendarEntryBean.createCalendarEntryBeanToCreateEntry(rootEntry, entry, beginPartial, endPartial);
        return this.generateGanttDiagram(mapping, request, bean);
    }

    public ActionForward chooseCalendarEntryTypePostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CalendarEntryBean bean = (CalendarEntryBean)this.getRenderedObject("calendarEntryBeanWithType");
        if (bean == null) {
            bean = (CalendarEntryBean)this.getRenderedObject("createdEntryBeanID");
        }
        request.setAttribute("parentEntryBean", (Object)bean);
        return mapping.findForward("prepareCreateCalendarEntry");
    }

    public ActionForward prepareCreateEntry(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AcademicCalendarEntry parentEntry = this.getAcademicCalendarEntryFromParameter(request);
        AcademicCalendarRootEntry rootEntry = this.getAcademicCalendarRootEntryFromParameter(request);
        Partial beginPartial = this.getBeginFromParameter(request);
        Partial endPartial = this.getEndFromParameter(request);
        request.setAttribute("parentEntryBean", (Object)CalendarEntryBean.createCalendarEntryBeanToCreateEntry(rootEntry, parentEntry, beginPartial, endPartial));
        return mapping.findForward("prepareCreateCalendarEntry");
    }

    public ActionForward createEntry(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CalendarEntryBean bean = (CalendarEntryBean)this.getRenderedObject("createdEntryBeanID");
        AcademicCalendarEntry entry = null;
        try {
            entry = CreateAcademicCalendarEntry.run(bean, true);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute("parentEntryBean", (Object)bean);
            return mapping.findForward("prepareCreateCalendarEntry");
        }
        return this.generateGanttDiagram(mapping, request, CalendarEntryBean.createCalendarEntryBeanToCreateEntry(entry.getRootEntry(), entry, bean.getBeginDateToDisplay(), bean.getEndDateToDisplay()));
    }

    public ActionForward prepareEditEntry(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AcademicCalendarEntry entry = this.getAcademicCalendarEntryFromParameter(request);
        AcademicCalendarRootEntry rootEntry = this.getAcademicCalendarRootEntryFromParameter(request);
        Partial beginPartial = this.getBeginFromParameter(request);
        Partial endPartial = this.getEndFromParameter(request);
        request.setAttribute("entryBean", (Object)CalendarEntryBean.createCalendarEntryBeanToEditEntry(rootEntry, entry, beginPartial, endPartial));
        return mapping.findForward("prepareCreateCalendarEntry");
    }

    public ActionForward editEntry(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CalendarEntryBean bean = (CalendarEntryBean)this.getRenderedObject("editedEntryBeanID");
        AcademicCalendarEntry entry = null;
        try {
            entry = CreateAcademicCalendarEntry.run(bean, false);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute("entryBean", (Object)bean);
            return mapping.findForward("prepareCreateCalendarEntry");
        }
        return this.generateGanttDiagram(mapping, request, CalendarEntryBean.createCalendarEntryBeanToCreateEntry(entry.getRootEntry(), entry, bean.getBeginDateToDisplay(), bean.getEndDateToDisplay()));
    }

    public ActionForward deleteEntry(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AcademicCalendarEntry entry = this.getAcademicCalendarEntryFromParameter(request);
        AcademicCalendarRootEntry rootEntry = this.getAcademicCalendarRootEntryFromParameter(request);
        AcademicCalendarRootEntry entryRootEntry = entry.getRootEntry();
        AcademicCalendarEntry entryParentEntry = entry.getParentEntry();
        boolean deletedRootEntry = entry.isRoot();
        Partial beginPartial = this.getBeginFromParameter(request);
        Partial endPartial = this.getEndFromParameter(request);
        try {
            DeleteAcademicCalendarEntry.run(entry, rootEntry);
        }
        catch (DomainException domainException) {
            this.addActionMessage(request, domainException.getMessage());
            return this.generateGanttDiagram(mapping, request, CalendarEntryBean.createCalendarEntryBeanToCreateEntry(rootEntry, entry, beginPartial, endPartial));
        }
        if (deletedRootEntry) {
            return this.prepareChooseCalendar(mapping, actionForm, request, response);
        }
        if (entryParentEntry != null) {
            return this.generateGanttDiagram(mapping, request, CalendarEntryBean.createCalendarEntryBeanToCreateEntry(rootEntry, entryParentEntry, beginPartial, endPartial));
        }
        return this.generateGanttDiagram(mapping, request, CalendarEntryBean.createCalendarEntryBeanToCreateEntry(rootEntry, (AcademicCalendarEntry)((Object)entryRootEntry), beginPartial, endPartial));
    }

    private ActionForward generateGanttDiagram(ActionMapping mapping, HttpServletRequest request, CalendarEntryBean bean) {
        YearMonthDay beginDate = bean.getBeginDateToDisplayInYearMonthDayFormat();
        YearMonthDay endDate = bean.getEndDateToDisplayInYearMonthDayFormat();
        endDate = endDate.plusMonths(1).withDayOfMonth(1).minusDays(1);
        List<GanttDiagramEvent> newEntries = this.generateEntriesTree(request, bean.getRootEntry(), beginDate, endDate);
        GanttDiagram diagram = GanttDiagram.getNewTotalGanttDiagram(newEntries, beginDate, endDate);
        request.setAttribute("entryBean", (Object)bean);
        request.setAttribute("ganttDiagram", (Object)diagram);
        return mapping.findForward("viewAcademicCalendar");
    }

    private List<GanttDiagramEvent> generateEntriesTree(HttpServletRequest request, AcademicCalendarRootEntry academicCalendar, YearMonthDay begin, YearMonthDay end) {
        DateTime beginDateTime = begin.toDateTimeAtMidnight();
        DateTime endDateTime = end.toDateTimeAtMidnight();
        ArrayList<GanttDiagramEvent> result = new ArrayList<GanttDiagramEvent>();
        for (AcademicCalendarEntry entry : academicCalendar.getChildEntriesWithTemplateEntriesOrderByDate(beginDateTime, endDateTime)) {
            this.getSubEntriesTree(entry, result, beginDateTime, endDateTime);
        }
        return result;
    }

    private void getSubEntriesTree(AcademicCalendarEntry entry, List<GanttDiagramEvent> result, DateTime begin, DateTime end) {
        result.add(entry);
        for (AcademicCalendarEntry subEntry : entry.getChildEntriesWithTemplateEntriesOrderByDate(begin, end)) {
            this.getSubEntriesTree(subEntry, result, begin, end);
        }
    }

    private AcademicCalendarEntry getAcademicCalendarEntryFromParameter(HttpServletRequest request) {
        String calendarIDString = request.getParameter("entryID");
        return (AcademicCalendarEntry)FenixFramework.getDomainObject((String)calendarIDString);
    }

    private AcademicCalendarRootEntry getAcademicCalendarRootEntryFromParameter(HttpServletRequest request) {
        String calendarIDString = request.getParameter("rootEntryID");
        return (AcademicCalendarRootEntry)FenixFramework.getDomainObject((String)calendarIDString);
    }

    private Partial getBeginFromParameter(HttpServletRequest request) {
        String date = request.getParameter("begin");
        return CalendarEntryBean.getPartialFromString(date);
    }

    private Partial getEndFromParameter(HttpServletRequest request) {
        String date = request.getParameter("end");
        return CalendarEntryBean.getPartialFromString(date);
    }
}

