/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.components;

import java.io.IOException;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.fenixedu.academic.ui.faces.components.util.CalendarLink;
import org.fenixedu.academic.util.DateFormatUtil;

public class UIFenixCalendar
extends UIInput {
    public static final String COMPONENT_TYPE = "org.fenixedu.academic.ui.faces.components.UIFenixCalendar";
    public static final String COMPONENT_FAMILY = "org.fenixedu.academic.ui.faces.components.UIFenixCalendar";

    public UIFenixCalendar() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "org.fenixedu.academic.ui.faces.components.UIFenixCalendar";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        Calendar[] begins = this.getDateArgument("begin");
        Calendar[] ends = this.getDateArgument("end");
        for (int i = 0; i < begins.length; ++i) {
            Calendar begin = begins[i];
            Calendar end = ends[i];
            if (begin == null || end == null) {
                writer.write("<!-- begin and end dates must be specified -->");
                continue;
            }
            if (end.before(begin)) {
                writer.write("<!-- end date must be after begin date -->");
                continue;
            }
            if (begin.get(2) == end.get(2)) {
                this.encodeMonthTable(writer, context, "MONTH" + begin.get(2), begin, end);
                continue;
            }
            while (begin.before(end)) {
                Calendar endPeriod = Calendar.getInstance();
                endPeriod.setTime(begin.getTime());
                endPeriod.set(5, begin.getActualMaximum(5));
                if (endPeriod.after(end)) {
                    endPeriod.setTime(end.getTime());
                }
                this.encodeMonthTable(writer, context, "MONTH" + begin.get(2), begin, endPeriod);
                UIFenixCalendar.setToFirstDayOfNextMonth(begin);
            }
        }
    }

    private Calendar[] getDateArgument(String argumentName) {
        Object object = this.getAttributes().get(argumentName);
        if (object instanceof Calendar) {
            return new Calendar[]{(Calendar)object};
        }
        if (object instanceof Date && object != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            return new Calendar[]{calendar};
        }
        if (object instanceof Object[]) {
            Object[] objects = (Object[])object;
            Calendar[] result = new Calendar[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] instanceof Calendar) {
                    result[i] = (Calendar)objects[i];
                    continue;
                }
                if (objects[i] instanceof Date && objects[i] != null) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)objects[i]);
                    result[i] = calendar;
                    continue;
                }
                result[i] = null;
            }
            return result;
        }
        return new Calendar[0];
    }

    private static void setToFirstDayOfNextMonth(Calendar date) {
        if (date.get(2) < 11) {
            date.roll(2, true);
        } else {
            date.roll(2, true);
            date.roll(1, true);
        }
        date.set(5, 1);
    }

    private void encodeMonthTable(ResponseWriter writer, FacesContext context, String key, Calendar begin, Calendar end) throws IOException {
        writer.startElement("table", (UIComponent)this);
        writer.writeAttribute("class", (Object)"table table-bordered", null);
        this.encodeMonthRow(writer, begin, context.getViewRoot().getLocale());
        this.encodeDaysOfWeek(writer, context.getViewRoot().getLocale());
        this.encodeWeeks(writer, begin, end);
        writer.endElement("table");
        writer.startElement("br", (UIComponent)this);
        writer.endElement("br");
    }

    private String getFieldKey(FacesContext context, String key) {
        return new String(this.getClientId(context) + ':' + key);
    }

    private void encodeMonthRow(ResponseWriter writer, Calendar date, Locale locale) throws IOException {
        writer.startElement("caption", (UIComponent)this);
        writer.writeAttribute("style", (Object)"font-weight: 600; background: #bbb", null);
        writer.writeAttribute("class", (Object)"text-center", null);
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm", locale);
        DateFormatSymbols dfs = sdf.getDateFormatSymbols();
        writer.write(dfs.getMonths()[date.get(2)]);
        writer.endElement("caption");
    }

    private void encodeDaysOfWeek(ResponseWriter writer, Locale locale) throws IOException {
        writer.startElement("tr", (UIComponent)this);
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm", locale);
        DateFormatSymbols dfs = sdf.getDateFormatSymbols();
        this.encodeDayOfWeek(writer, dfs.getWeekdays()[2]);
        this.encodeDayOfWeek(writer, dfs.getWeekdays()[3]);
        this.encodeDayOfWeek(writer, dfs.getWeekdays()[4]);
        this.encodeDayOfWeek(writer, dfs.getWeekdays()[5]);
        this.encodeDayOfWeek(writer, dfs.getWeekdays()[6]);
        this.encodeDayOfWeek(writer, dfs.getWeekdays()[7]);
        writer.endElement("tr");
    }

    private void encodeDayOfWeek(ResponseWriter writer, String dayLabel) throws IOException {
        writer.startElement("th", (UIComponent)this);
        writer.write(dayLabel);
        writer.endElement("th");
    }

    private void encodeWeeks(ResponseWriter writer, Calendar begin, Calendar end) throws IOException {
        String createLink = (String)this.getAttributes().get("createLink");
        String editLinkPage = (String)this.getAttributes().get("editLinkPage");
        List editLinkParameters = (List)this.getAttributes().get("editLinkParameters");
        Calendar now = Calendar.getInstance();
        Calendar iter = Calendar.getInstance();
        iter.setTime(begin.getTime());
        for (int beginWeek = begin.get(4); beginWeek <= end.get(4); ++beginWeek) {
            writer.startElement("tr", (UIComponent)this);
            writer.writeAttribute("class", (Object)"text-right", null);
            for (int beginDayOfWeek = 2; beginDayOfWeek <= 7; ++beginDayOfWeek) {
                if (iter.get(7) == 1) {
                    this.doMonthAwareRoll(iter);
                }
                if (iter.after(end)) {
                    writer.startElement("td", (UIComponent)this);
                    writer.writeAttribute("style", (Object)"width: 16.7%", null);
                    this.appendExtraLines(writer);
                    writer.endElement("td");
                    continue;
                }
                if (iter.get(7) == beginDayOfWeek) {
                    writer.startElement("td", (UIComponent)this);
                    List<CalendarLink> toDisplay = this.objectsToDisplayOnThisDay(iter, editLinkParameters);
                    if (toDisplay != null && !toDisplay.isEmpty()) {
                        writer.writeAttribute("style", (Object)"background: #e6e6e6; width: 16.7%", null);
                        this.encodeDay(writer, createLink, now, iter);
                        for (CalendarLink calendarLink : toDisplay) {
                            writer.startElement("br", (UIComponent)this);
                            writer.endElement("br");
                            if (calendarLink.isAsLink()) {
                                writer.startElement("a", (UIComponent)this);
                                writer.writeAttribute("style", (Object)"text-decoration:none", null);
                                writer.writeAttribute("href", (Object)calendarLink.giveLink(editLinkPage), null);
                            }
                            writer.write(calendarLink.getObjectLinkLabel());
                            if (!calendarLink.isAsLink()) continue;
                            writer.endElement("a");
                        }
                    } else {
                        writer.writeAttribute("style", (Object)"background: #eee; width: 16.7%", null);
                        this.encodeDay(writer, createLink, now, iter);
                    }
                    this.appendExtraLines(writer);
                    writer.endElement("td");
                    this.doMonthAwareRoll(iter);
                    continue;
                }
                writer.startElement("td", (UIComponent)this);
                this.appendExtraLines(writer);
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
    }

    private void appendExtraLines(ResponseWriter writer) throws IOException {
        String extraLines = (String)this.getAttributes().get("extraLines");
        if (extraLines != null && extraLines.length() > 0 && Boolean.valueOf(extraLines).equals(Boolean.TRUE)) {
            writer.startElement("br", (UIComponent)this);
            writer.endElement("br");
            writer.startElement("br", (UIComponent)this);
            writer.endElement("br");
            writer.startElement("br", (UIComponent)this);
            writer.endElement("br");
            writer.startElement("br", (UIComponent)this);
            writer.endElement("br");
            writer.startElement("br", (UIComponent)this);
            writer.endElement("br");
            writer.startElement("br", (UIComponent)this);
            writer.endElement("br");
        }
    }

    private void encodeDay(ResponseWriter writer, String createLink, Calendar now, Calendar iter) throws IOException {
        if (createLink == null || iter.before(now)) {
            writer.write(new Integer(iter.get(5)).toString());
        } else {
            writer.startElement("a", (UIComponent)this);
            writer.writeAttribute("style", (Object)"text-decoration:none", null);
            writer.writeAttribute("href", (Object)(createLink + this.dateLink(iter)), null);
            writer.write(new Integer(iter.get(5)).toString());
            writer.endElement("a");
        }
    }

    private List<CalendarLink> objectsToDisplayOnThisDay(Calendar iter, List<CalendarLink> editLinkParameters) {
        ArrayList<CalendarLink> result = new ArrayList<CalendarLink>();
        for (CalendarLink calendarLink : editLinkParameters) {
            if (calendarLink.getObjectOccurrence().get(5) != iter.get(5) || calendarLink.getObjectOccurrence().get(2) != iter.get(2) || calendarLink.getObjectOccurrence().get(1) != iter.get(1)) continue;
            result.add(calendarLink);
        }
        return result;
    }

    private void doMonthAwareRoll(Calendar date) {
        if (date.get(5) < date.getActualMaximum(5)) {
            date.roll(5, true);
        } else {
            date.roll(5, true);
            date.roll(2, true);
        }
    }

    private String dateLink(Calendar date) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&day=");
        stringBuilder.append(date.get(5));
        stringBuilder.append("&month=");
        stringBuilder.append(date.get(2) + 1);
        stringBuilder.append("&year=");
        stringBuilder.append(date.get(1));
        stringBuilder.append("&selectedDate=");
        stringBuilder.append(DateFormatUtil.format("dd/MM/yyyy", date.getTime()));
        return stringBuilder.toString();
    }
}

