/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.bolonhaManager.curricularPlans;

import java.util.List;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroupInformation;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.ui.faces.bean.bolonhaManager.curricularPlans.CurricularCourseManagementBackingBean;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixframework.FenixFramework;

public class CycleCourseGroupInformationManagementBackingBean
extends CurricularCourseManagementBackingBean {
    private String courseGroupID;
    private String informationExecutionYearId;
    private String informationId;
    private String graduateTitleSuffix;
    private String graduateTitleSuffixEn;

    public CycleCourseGroup getCourseGroup(String courseGroupID) {
        return (CycleCourseGroup)FenixFramework.getDomainObject((String)courseGroupID);
    }

    public List<CycleCourseGroupInformation> getCycleCourseGroupInformationList() {
        CycleCourseGroup courseGroup = this.getCourseGroup(this.getCourseGroupID());
        return courseGroup.getCycleCourseGroupInformationOrderedByExecutionYear();
    }

    public String prepareEditCourseGroupInformation() {
        CycleCourseGroupInformation information = this.getInformation();
        this.setInformationExecutionYearId(information.getExecutionYear().getExternalId());
        this.setInformationId(information.getExternalId());
        this.setGraduateTitleSuffix(information.getGraduateTitleSuffixDefault());
        this.setGraduateTitleSuffixEn(information.getGraduateTitleSuffixEn());
        return "";
    }

    public String editCourseGroupInformation() {
        try {
            CycleCourseGroupInformation information = this.getInformation();
            if (information != null) {
                information.edit(this.getInformationExecutionYear(), this.getGraduateTitleSuffix(), this.getGraduateTitleSuffixEn());
            } else {
                CycleCourseGroup courseGroup = this.getCourseGroup(this.getCourseGroupID());
                courseGroup.createCycleCourseGroupInformation(this.getInformationExecutionYear(), this.getGraduateTitleSuffix(), this.getGraduateTitleSuffixEn());
            }
            this.addInfoMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"cycleCourseGroupInformationEdit", (String[])new String[0]));
            this.setGraduateTitleSuffix("");
            this.setGraduateTitleSuffixEn("");
            this.setInformationExecutionYearId(null);
            return "editCurricularPlanStructure";
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
            return "";
        }
    }

    @Override
    public String getCourseGroupID() {
        return this.courseGroupID != null ? this.courseGroupID : this.getAndHoldStringParameter("courseGroupID");
    }

    @Override
    public void setCourseGroupID(String courseGroupID) {
        this.courseGroupID = courseGroupID;
    }

    public String getInformationExecutionYearId() {
        return this.informationExecutionYearId != null ? this.informationExecutionYearId : "-1";
    }

    public void setInformationExecutionYearId(String informationExecutionYearId) {
        this.informationExecutionYearId = informationExecutionYearId;
    }

    public ExecutionYear getInformationExecutionYear() {
        return (ExecutionYear)FenixFramework.getDomainObject((String)this.getInformationExecutionYearId());
    }

    public String getInformationId() {
        return this.informationId != null ? this.informationId : (this.informationId = this.getAndHoldStringParameter("informationId"));
    }

    public CycleCourseGroupInformation getInformation() {
        return this.getInformationId() != null ? (CycleCourseGroupInformation)FenixFramework.getDomainObject((String)this.getInformationId()) : null;
    }

    public void setInformationId(String informationId) {
        this.informationId = informationId;
    }

    public String getGraduateTitleSuffix() {
        return this.graduateTitleSuffix;
    }

    public void setGraduateTitleSuffix(String graduateTitleSuffix) {
        this.graduateTitleSuffix = graduateTitleSuffix;
    }

    public String getGraduateTitleSuffixEn() {
        return this.graduateTitleSuffixEn;
    }

    public void setGraduateTitleSuffixEn(String graduateTitleSuffixEn) {
        this.graduateTitleSuffixEn = graduateTitleSuffixEn;
    }
}

