/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.bolonhaManager.curricularPlans;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.faces.model.SelectItem;
import org.apache.commons.beanutils.BeanComparator;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.degreeStructure.BranchCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.services.bolonhaManager.AddContextToCourseGroup;
import org.fenixedu.academic.service.services.bolonhaManager.CreateCourseGroup;
import org.fenixedu.academic.service.services.bolonhaManager.DeleteContextFromDegreeModule;
import org.fenixedu.academic.service.services.bolonhaManager.EditCourseGroup;
import org.fenixedu.academic.service.services.bolonhaManager.OrderDegreeModule;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.faces.bean.bolonhaManager.curricularPlans.CurricularCourseManagementBackingBean;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.util.CurricularRuleLabelFormatter;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;
import pt.ist.fenixframework.FenixFramework;

public class CourseGroupManagementBackingBean
extends CurricularCourseManagementBackingBean {
    private String name = null;
    private String nameEn = null;
    private String courseGroupID;
    private String programConclusionID = null;
    private List<SelectItem> courseGroups = null;
    private Boolean isOptional;

    public String getParentCourseGroupID() {
        return this.getAndHoldStringParameter("parentCourseGroupID");
    }

    public String getProgramConclusionID() {
        if (this.programConclusionID != null) {
            return this.programConclusionID;
        }
        if (this.getCourseGroup() != null && this.getCourseGroup().getProgramConclusion() != null) {
            return this.getCourseGroup().getProgramConclusion().getExternalId();
        }
        return null;
    }

    @Override
    public String getCourseGroupID() {
        return this.courseGroupID != null ? this.courseGroupID : this.getAndHoldStringParameter("courseGroupID");
    }

    @Override
    public void setCourseGroupID(String courseGroupID) {
        this.courseGroupID = courseGroupID;
    }

    public void setProgramConclusionID(String programConclusionID) {
        this.programConclusionID = programConclusionID;
    }

    @Override
    public String getName() {
        return this.name == null && this.getCourseGroupID() != null ? this.getCourseGroup(this.getCourseGroupID()).getName() : this.name;
    }

    @Override
    public String getNameEn() {
        return this.nameEn == null && this.getCourseGroupID() != null ? this.getCourseGroup(this.getCourseGroupID()).getNameEn() : this.nameEn;
    }

    public String getParentName() {
        return this.getParentCourseGroupID() != null ? this.getCourseGroup(this.getParentCourseGroupID()).getName() : null;
    }

    public Boolean getIsOptional() {
        return this.isOptional == null && this.getCourseGroupID() != null ? this.getCourseGroup(this.getCourseGroupID()).getIsOptional() : this.isOptional.booleanValue();
    }

    public void setIsOptional(Boolean isOptional) {
        this.isOptional = isOptional;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setNameEn(String nameEn) {
        this.nameEn = nameEn;
    }

    public CourseGroup getCourseGroup(String courseGroupID) {
        return (CourseGroup)FenixFramework.getDomainObject((String)courseGroupID);
    }

    @Override
    public List<SelectItem> getCourseGroups() {
        return this.courseGroups == null ? (this.courseGroups = this.readCourseGroups()) : this.courseGroups;
    }

    @Override
    public List<String> getRulesLabels() {
        ArrayList<String> resultLabels = new ArrayList<String>();
        for (CurricularRule curricularRule : this.getCourseGroup(this.getCourseGroupID()).getParticipatingCurricularRules()) {
            resultLabels.add(CurricularRuleLabelFormatter.getLabel(curricularRule));
        }
        return resultLabels;
    }

    @Override
    protected ExecutionSemester getMinimumExecutionPeriod() {
        Context context;
        CourseGroup courseGroup = this.getCourseGroup(this.getParentCourseGroupID());
        if (courseGroup == null && (context = this.getContext(this.getContextID())) != null) {
            courseGroup = context.getParentCourseGroup();
        }
        return courseGroup == null ? null : courseGroup.getMinimumExecutionPeriod();
    }

    public String createCourseGroup() {
        try {
            CreateCourseGroup.run(this.getDegreeCurricularPlanID(), this.getParentCourseGroupID(), this.getName(), this.getNameEn(), this.getBeginExecutionPeriodID(), this.getFinalEndExecutionPeriodID(), this.getProgramConclusionID());
            this.addInfoMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"courseGroupCreated", (String[])new String[0]));
            return "editCurricularPlanStructure";
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
        }
        return "";
    }

    public String editCourseGroup() {
        try {
            EditCourseGroup.run(this.getCourseGroupID(), this.getContextID(), this.getName(), this.getNameEn(), this.getBeginExecutionPeriodID(), this.getFinalEndExecutionPeriodID(), this.getIsOptional(), this.getProgramConclusionID());
            this.addInfoMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"courseGroupEdited", (String[])new String[0]));
            return "editCurricularPlanStructure";
        }
        catch (IllegalDataAccessException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.notAuthorized", (String[])new String[0]));
            return "editCurricularPlanStructure";
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage());
        }
        return "";
    }

    public String deleteCourseGroup() {
        try {
            DeleteContextFromDegreeModule.run(this.getCourseGroupID(), this.getContextID());
            this.addInfoMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"courseGroupDeleted", (String[])new String[0]));
            return "editCurricularPlanStructure";
        }
        catch (IllegalDataAccessException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.notAuthorized", (String[])new String[0]));
            return "editCurricularPlanStructure";
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
        }
        return "";
    }

    @Override
    public String addContext() {
        try {
            this.checkCourseGroup();
            AddContextToCourseGroup.run(this.getCourseGroup(this.getCourseGroupID()), this.getCourseGroup(this.getParentCourseGroupID()), this.getBeginExecutionPeriodID(), this.getFinalEndExecutionPeriodID());
            this.addInfoMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"courseGroupAssociated", (String[])new String[0]));
            return "editCurricularPlanStructure";
        }
        catch (FenixActionException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (Exception e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"general.error", (String[])new String[0]));
            return "editCurricularPlanStructure";
        }
        return "";
    }

    private boolean isBranch() {
        return this.getCourseGroup() instanceof BranchCourseGroup;
    }

    public String getIfBranchShowType() {
        if (this.isBranch()) {
            return "<p class=\"mtop25\">" + BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"branchType", (String[])new String[0]) + ": " + "<em><strong>" + ((BranchCourseGroup)((Object)this.getCourseGroup())).getBranchType().getDescription(I18N.getLocale()) + "</strong></em>" + "</p>";
        }
        return "";
    }

    private List<SelectItem> readCourseGroups() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        List<List<DegreeModule>> degreeModulesSet = this.getDegreeCurricularPlan().getDcpDegreeModulesIncludingFullPath(CourseGroup.class, null);
        Set allParents = this.getCourseGroup(this.getParentCourseGroupID()).getAllParentCourseGroups();
        for (List<DegreeModule> degreeModules : degreeModulesSet) {
            DegreeModule lastDegreeModule = degreeModules.size() > 0 ? degreeModules.get(degreeModules.size() - 1) : null;
            if (allParents.contains((Object)lastDegreeModule) || lastDegreeModule == this.getCourseGroup(this.getParentCourseGroupID())) continue;
            StringBuilder pathName = new StringBuilder();
            for (DegreeModule degreeModule : degreeModules) {
                pathName.append(pathName.length() == 0 ? "" : " > ").append(degreeModule.getName());
            }
            result.add(new SelectItem((Object)lastDegreeModule.getExternalId(), pathName.toString()));
        }
        Collections.sort(result, new BeanComparator("label"));
        this.getClass();
        result.add(0, new SelectItem((Object)"-1", BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"choose", (String[])new String[0])));
        return result;
    }

    public Integer getPosition() {
        return this.getAndHoldIntegerParameter("pos");
    }

    public String orderCourseGroup() {
        try {
            OrderDegreeModule.run(this.getContextID(), this.getPosition());
            this.addInfoMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"courseGroupMoved", (String[])new String[0]));
            return "editCurricularPlanStructure";
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (Exception e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"general.error", (String[])new String[0]));
            return "editCurricularPlanStructure";
        }
        return "";
    }

    public List<SelectItem> getProgramConclusionItems() {
        return Bennu.getInstance().getProgramConclusionSet().stream().map(pc -> {
            String name = pc.getName().getContent();
            String description = pc.getDescription().getContent();
            if (!Strings.isNullOrEmpty((String)description)) {
                name = name + " - " + description;
            }
            return new SelectItem((Object)pc.getExternalId(), name);
        }).collect(Collectors.toList());
    }
}

