/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.task;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.QueueJob;
import org.fenixedu.academic.domain.QueueJobResult;
import org.fenixedu.academic.domain.QueueJobResultFile;
import org.fenixedu.academic.domain.QueueJobWithFile;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.task.JobQueueDispatcher$callable$fail;
import org.fenixedu.academic.task.JobQueueDispatcher$callable$runJob;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.annotation.Task;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Task(englishTitle="JobQueueDispatcher", readOnly=true)
public class JobQueueDispatcher
extends CronTask {
    public static final Advice advice$runJob = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$fail = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    public void runTask() {
        QueueJob queueJob;
        Set undoneJobs = Bennu.getInstance().getQueueJobUndoneSet();
        QueueJob queueJob2 = queueJob = undoneJobs.isEmpty() ? null : Collections.min(undoneJobs, new QueueComparator());
        if (queueJob != null) {
            try {
                this.taskLog("Started: %s (%s) requested by %s on %s\n", new Object[]{((Object)((Object)queueJob)).getClass().getName(), queueJob.getExternalId(), this.getQueueJobResponsibleName(queueJob), queueJob.getRequestDate()});
                this.runJob(queueJob);
                this.taskLog("Finished Successfully\n", new Object[0]);
            }
            catch (Throwable e) {
                this.fail(queueJob, e);
                this.taskLog("Failed %s times\n", new Object[]{queueJob.getFailedCounter()});
                throw new Error(e);
            }
        }
    }

    public String getQueueJobResponsibleName(QueueJob queueJob) {
        return queueJob.getPerson() != null ? queueJob.getPerson().getName() + "(" + queueJob.getPerson().getUsername() + ")" : "system";
    }

    protected void runJob(QueueJob queueJob) throws Exception {
        Object object = advice$runJob.perform((Callable)new JobQueueDispatcher$callable$runJob(this, queueJob));
    }

    protected static /* synthetic */ void advised$runJob(JobQueueDispatcher this_, QueueJob job) throws Exception {
        job.setJobStartTime(new DateTime());
        QueueJobResult result = job.execute();
        if (job instanceof QueueJobWithFile) {
            QueueJobWithFile queueJobWithFile = (QueueJobWithFile)((Object)job);
            queueJobWithFile.setContentType(result.getContentType());
            QueueJobResultFile.store(queueJobWithFile, queueJobWithFile.getPerson(), queueJobWithFile.getFilename(), result.getContent());
        }
        job.setDone(true);
        job.setRootDomainObjectQueueUndone(null);
        job.setJobEndTime(new DateTime());
        if (job.getPerson() != null) {
            ArrayList<String> emails = new ArrayList<String>();
            emails.add(job.getPerson().getInstitutionalOrDefaultEmailAddressValue());
            String subject = "Pedido de " + job.getDescription() + " concluido";
            String body = "O seu pedido de " + job.getDescription() + " j\u00e1 se encontra dispon\u00edvel no sistema F\u00e9nix.";
            new Message((Sender)((Object)Bennu.getInstance().getSystemSender()), job.getPerson().getEmailForSendingEmails(), subject, body);
        }
    }

    protected void fail(QueueJob queueJob, Throwable throwable) {
        Object object = advice$fail.perform((Callable)new JobQueueDispatcher$callable$fail(this, queueJob, throwable));
    }

    protected static /* synthetic */ void advised$fail(JobQueueDispatcher this_, QueueJob job, Throwable t) {
        job.setFailedCounter(job.getFailedCounter() + 1);
        job.setJobEndTime(new DateTime());
        if (job.getFailedCounter() == 3) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            String subject = "Job " + ((Object)((Object)job)).getClass().getName() + "failed 3 times";
            String body = "Viva\n\nO trabalho com o externalId de " + job.getExternalId() + " falhou mais de 3 vezes.\n\n" + "Request Time : " + job.getRequestDate() + "\n" + "Start Time : " + job.getJobStartTime() + "\n" + "User : " + this_.getQueueJobResponsibleName(job) + "\n" + "\n\n Error Stack Trace:\n" + sw.toString();
            new Message((Sender)((Object)Bennu.getInstance().getSystemSender()), Bennu.getInstance().getSystemSender().getRoleRecipient(RoleType.MANAGER), subject, body);
        }
    }

    private static class QueueComparator
    implements Comparator<QueueJob> {
        private QueueComparator() {
        }

        @Override
        public int compare(QueueJob queueJob1, QueueJob queueJob2) {
            int result;
            Integer fc1 = queueJob1.getFailedCounter();
            Integer fc2 = queueJob1.getFailedCounter();
            if (fc1 != null && fc2 != null && (result = fc1.compareTo(fc2)) != 0) {
                return result;
            }
            result = queueJob1.getPriority().compareTo(queueJob2.getPriority());
            if (result != 0) {
                return result;
            }
            return queueJob1.getExternalId().compareTo(queueJob2.getExternalId());
        }
    }
}

