/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.servlet.taglib.sop.v3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.struts.util.RequestUtils;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.dto.InfoShowOccupation;
import org.fenixedu.academic.servlet.taglib.sop.v3.ColorPicker;
import org.fenixedu.academic.servlet.taglib.sop.v3.DayColumn;
import org.fenixedu.academic.servlet.taglib.sop.v3.InfoLessonWrapper;
import org.fenixedu.academic.servlet.taglib.sop.v3.LessonSlot;
import org.fenixedu.academic.servlet.taglib.sop.v3.LessonSlotContentRenderer;
import org.fenixedu.academic.servlet.taglib.sop.v3.LessonSlotContentRendererShift;
import org.fenixedu.academic.servlet.taglib.sop.v3.TimeTable;
import org.fenixedu.academic.servlet.taglib.sop.v3.TimeTableSlot;
import org.fenixedu.academic.servlet.taglib.sop.v3.renderers.ClassTimeTableWithoutLinksLessonContentRenderer;
import org.fenixedu.academic.servlet.taglib.sop.v3.renderers.ShiftEnrollmentTimeTableLessonContentRenderer;

public class TimeTableRenderer {
    private final Integer startHour;
    private final Integer slotSize;
    private final TimeTable timeTable;
    private final LessonSlotContentRenderer lessonSlotContentRenderer;
    private final ColorPicker colorPicker;

    public TimeTableRenderer(TimeTable timeTable, LessonSlotContentRenderer lessonSlotContentRenderer, Integer slotSize, Integer startHour, Integer endHour, ColorPicker colorPicker) {
        if (colorPicker == null) {
            throw new IllegalArgumentException(this.getClass().getName() + ":Color picker must be not null!");
        }
        this.timeTable = timeTable;
        this.lessonSlotContentRenderer = lessonSlotContentRenderer;
        this.startHour = startHour;
        this.slotSize = slotSize;
        this.colorPicker = colorPicker;
    }

    public StringBuilder render(Locale locale, PageContext pageContext, boolean definedWidth) {
        StringBuilder strBuffer = new StringBuilder("");
        HashMap<String, InfoLessonWrapper> slotLessons = new HashMap<String, InfoLessonWrapper>();
        TimeTableSlot[][] grid = this.timeTable.getTimeTableGrid();
        strBuffer.append("<table class='timetable' cellspacing='0' cellpadding='0'");
        if (definedWidth) {
            strBuffer.append("width='90%'");
        }
        strBuffer.append(">");
        SchoolClass schoolClass = (SchoolClass)((Object)pageContext.getRequest().getAttribute("schoolClass"));
        if (schoolClass != null) {
            String className = schoolClass.getNome();
            strBuffer.append("<caption>");
            String captionPrefix = this.getMessageResource(pageContext, "public.degree.information.title.class.timetable", locale);
            strBuffer.append(captionPrefix);
            strBuffer.append(' ');
            strBuffer.append(className);
            strBuffer.append("</caption>");
        }
        this.renderHeader(strBuffer, locale, pageContext, definedWidth);
        for (int hourIndex = 0; hourIndex < this.timeTable.getNumberOfHours(); ++hourIndex) {
            strBuffer.append("<tr>\r\n");
            strBuffer.append("<th class='period-hours'");
            strBuffer.append(" id='hour");
            strBuffer.append(hourIndex);
            strBuffer.append("'>");
            strBuffer.append((CharSequence)this.getHourLabelByIndex(hourIndex)).append("</th>\r\n");
            for (int dayIndex = 0; dayIndex < this.timeTable.getNumberOfDays(); ++dayIndex) {
                DayColumn dayColumn = this.timeTable.getDayColumn(dayIndex);
                TimeTableSlot timeTableSlot = grid[dayIndex][hourIndex];
                if (timeTableSlot != null) {
                    List colisionList = timeTableSlot.getLessonSlotList();
                    InfoLessonWrapper[] lessonSlotListResolved = this.resolveColisions(colisionList, this.timeTable.getDayColumn(dayIndex));
                    for (int slotIndex = 0; slotIndex < lessonSlotListResolved.length; ++slotIndex) {
                        String context;
                        HttpServletRequest request;
                        int slotColspan;
                        InfoLessonWrapper infoLessonWrapper = lessonSlotListResolved[slotIndex];
                        strBuffer.append("<td ");
                        if (infoLessonWrapper != null) {
                            strBuffer.append("style='background-color: ").append(this.colorPicker.getBackgroundColor(infoLessonWrapper)).append("' ");
                        }
                        if ((slotColspan = this.calculateColspan(infoLessonWrapper, lessonSlotListResolved, slotIndex, dayColumn)) > 1) {
                            strBuffer.append(" colspan ='").append(slotColspan).append("'");
                            slotIndex += slotColspan - 1;
                        }
                        strBuffer.append(" headers='weekday");
                        strBuffer.append(dayIndex);
                        for (int hourHeader = hourIndex; hourHeader < hourIndex + slotColspan; ++hourHeader) {
                            strBuffer.append(" hour");
                            strBuffer.append(hourHeader);
                        }
                        strBuffer.append("' ");
                        strBuffer.append(" class='");
                        strBuffer.append(this.getSlotCssClass(infoLessonWrapper, hourIndex));
                        strBuffer.append("' ");
                        if (infoLessonWrapper != null) {
                            InfoShowOccupation occupation = infoLessonWrapper.getLessonSlot().getInfoLessonWrapper().getInfoShowOccupation();
                            strBuffer.append(" title='").append(this.lessonSlotContentRenderer.renderTitleText(infoLessonWrapper.getLessonSlot())).append("'");
                        }
                        strBuffer.append(">");
                        String contextPath = ((HttpServletRequest)pageContext.getRequest()).getContextPath();
                        if (infoLessonWrapper != null && infoLessonWrapper.getLessonSlot().getStartIndex() == hourIndex) {
                            request = (HttpServletRequest)pageContext.getRequest();
                            context = request.getContextPath();
                            strBuffer.append((CharSequence)this.lessonSlotContentRenderer.render(context, infoLessonWrapper.getLessonSlot()));
                            if (this.getSlotCssClass(infoLessonWrapper, hourIndex).equalsIgnoreCase("period-single-slot")) {
                                strBuffer.append(this.lessonSlotContentRenderer.renderSecondLine(context, infoLessonWrapper.getLessonSlot()));
                            }
                            if (this.lessonSlotContentRenderer instanceof ShiftEnrollmentTimeTableLessonContentRenderer) {
                                if (this.getSlotCssClass(infoLessonWrapper, hourIndex).equalsIgnoreCase("period-single-slot")) {
                                    LessonSlotContentRendererShift lessonSlotContentRendererShift = (LessonSlotContentRendererShift)this.lessonSlotContentRenderer;
                                    strBuffer.append((CharSequence)lessonSlotContentRendererShift.lastRender(infoLessonWrapper.getLessonSlot(), contextPath));
                                }
                                slotLessons.put(slotIndex + "-" + dayIndex, infoLessonWrapper);
                            }
                        } else {
                            if (infoLessonWrapper != null && !infoLessonWrapper.isSecondRowAlreadyAppended()) {
                                request = (HttpServletRequest)pageContext.getRequest();
                                context = request.getContextPath();
                                strBuffer.append(this.lessonSlotContentRenderer.renderSecondLine(context, infoLessonWrapper.getLessonSlot()));
                            }
                            if (this.lessonSlotContentRenderer instanceof ShiftEnrollmentTimeTableLessonContentRenderer && this.getSlotCssClass((InfoLessonWrapper)slotLessons.get(slotIndex + "-" + dayIndex), hourIndex).equalsIgnoreCase("period-last-slot")) {
                                LessonSlotContentRendererShift lessonSlotContentRendererShift = (LessonSlotContentRendererShift)this.lessonSlotContentRenderer;
                                InfoLessonWrapper infoLessonWrapperHashMap = (InfoLessonWrapper)slotLessons.get(slotIndex + "-" + dayIndex);
                                strBuffer.append((CharSequence)lessonSlotContentRendererShift.lastRender(infoLessonWrapperHashMap.getLessonSlot(), contextPath));
                            } else {
                                if (infoLessonWrapper != null && this.lessonSlotContentRenderer instanceof ClassTimeTableWithoutLinksLessonContentRenderer) {
                                    request = (HttpServletRequest)pageContext.getRequest();
                                    context = request.getContextPath();
                                    strBuffer.append((CharSequence)this.lessonSlotContentRenderer.render(context, infoLessonWrapper.getLessonSlot()));
                                }
                                strBuffer.append("&nbsp;");
                            }
                        }
                        strBuffer.append("</td>\r\n");
                    }
                    continue;
                }
                int colspan = dayColumn.getMaxColisionSize();
                String cssClass = this.getSlotCssClass(null, hourIndex);
                strBuffer.append("<td ").append(" class='").append(cssClass).append("' ");
                if (colspan > 1) {
                    strBuffer.append("colspan='").append(colspan).append("'");
                }
                strBuffer.append(">").append("&nbsp;").append("</td>\r\n");
            }
            strBuffer.append("</tr>\r\n");
        }
        strBuffer.append("</table>");
        return strBuffer;
    }

    private String getMessageResource(PageContext pageContext, String key, Locale locale) {
        try {
            return RequestUtils.message((PageContext)pageContext, (String)"PUBLIC_DEGREE_INFORMATION", (String)"org.apache.struts.action.LOCALE", (String)key);
        }
        catch (JspException e) {
            return "???" + key + "???";
        }
    }

    private int calculateColspan(InfoLessonWrapper infoLessonWrapper, InfoLessonWrapper[] lessonSlotListResolved, int currentSlotIndex, DayColumn dayColumn) {
        int colspan = 1;
        if (infoLessonWrapper != null && infoLessonWrapper.getNumberOfCollisions() == 0) {
            colspan = dayColumn.getMaxColisionSize();
        } else if (infoLessonWrapper == null) {
            InfoLessonWrapper next;
            for (int i = currentSlotIndex + 1; i < lessonSlotListResolved.length && (next = lessonSlotListResolved[i]) == null; ++i) {
                ++colspan;
            }
        }
        return colspan;
    }

    private String getSlotCssClass(InfoLessonWrapper infoLessonWrapper, int hourIndex) {
        String css = "period-empty-slot";
        if (infoLessonWrapper != null) {
            LessonSlot lessonSlot = infoLessonWrapper.getLessonSlot();
            css = lessonSlot.getStartIndex() == hourIndex && lessonSlot.getEndIndex() == hourIndex ? "period-single-slot" : (lessonSlot.getStartIndex() == hourIndex ? "period-first-slot" : (lessonSlot.getEndIndex() == hourIndex ? "period-last-slot" : "period-middle-slot"));
        }
        return css;
    }

    private void renderHeader(StringBuilder strBuffer, Locale locale, PageContext pageContext, boolean definedWidth) {
        String hourDaysTitle;
        try {
            hourDaysTitle = RequestUtils.message((PageContext)pageContext, (String)"PUBLIC_DEGREE_INFORMATION", (String)"org.apache.struts.action.LOCALE", (String)"public.degree.information.label.timesAndDays");
        }
        catch (JspException e) {
            hourDaysTitle = "???label.timesAndDays???";
        }
        strBuffer.append("<tr><th>");
        strBuffer.append(hourDaysTitle);
        strBuffer.append("</th>\r\n");
        int cellWidth = 85 / this.timeTable.getNumberOfDays();
        for (int index = 0; index < this.timeTable.getNumberOfDays(); ++index) {
            strBuffer.append("<th colspan='");
            strBuffer.append(this.timeTable.getDayColumn(index).getMaxColisionSize());
            strBuffer.append("' ");
            if (definedWidth) {
                strBuffer.append("width='");
                strBuffer.append(cellWidth);
                strBuffer.append("%'");
            }
            strBuffer.append(" id='weekday");
            strBuffer.append(index);
            strBuffer.append("'");
            strBuffer.append(">\r\n");
            strBuffer.append(this.timeTable.getDayColumn(index).getLabel());
            strBuffer.append("</th>\r\n");
        }
        strBuffer.append("</tr>");
    }

    protected InfoLessonWrapper[] resolveColisions(List lessonSlotList, DayColumn dayColumn) {
        InfoLessonWrapper[] list = new InfoLessonWrapper[dayColumn.getMaxColisionSize().intValue()];
        Iterator lessonSlotListIterator = lessonSlotList.iterator();
        ArrayList<InfoLessonWrapper> lessonSlotNotLocked = new ArrayList<InfoLessonWrapper>();
        while (lessonSlotListIterator.hasNext()) {
            LessonSlot lessonSlot = (LessonSlot)lessonSlotListIterator.next();
            InfoLessonWrapper infoLessonWrapper = lessonSlot.getInfoLessonWrapper();
            if (infoLessonWrapper.isLocked()) {
                list[infoLessonWrapper.getSlotIndex()] = infoLessonWrapper;
                continue;
            }
            lessonSlotNotLocked.add(infoLessonWrapper);
        }
        Collections.sort(lessonSlotNotLocked);
        block1: for (InfoLessonWrapper infoLessonWrapper : lessonSlotNotLocked) {
            for (int index = 0; index < list.length; ++index) {
                if (list[index] != null) continue;
                list[index] = infoLessonWrapper;
                infoLessonWrapper.setLocked(true, index);
                continue block1;
            }
        }
        return list;
    }

    private StringBuilder getHourLabelByIndex(int hourIndex) {
        double endLabelHour;
        double endMinutes;
        String endMinutesLabel;
        StringBuilder label = new StringBuilder("");
        double startLabelHour = this.startHour.doubleValue() + new Integer(hourIndex).doubleValue() / (60.0 / this.slotSize.doubleValue());
        double startMinutes = startLabelHour - Math.floor(startLabelHour);
        String startMinutesLabel = String.valueOf((int)(startMinutes * 60.0));
        if (startMinutesLabel.length() == 1) {
            startMinutesLabel = "0" + startMinutesLabel;
        }
        if ((endMinutesLabel = String.valueOf((int)((endMinutes = (endLabelHour = this.startHour.doubleValue() + new Integer(hourIndex + 1).doubleValue() / (60.0 / this.slotSize.doubleValue())) - Math.floor(endLabelHour)) * 60.0))).length() == 1) {
            endMinutesLabel = "0" + endMinutesLabel;
        }
        return label.append((int)startLabelHour).append(":").append(startMinutesLabel).append("-").append((int)endLabelHour).append(":").append(endMinutesLabel);
    }
}

