/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.fileManager;

import com.google.common.io.ByteStreams;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PhotoType;
import org.fenixedu.academic.domain.Photograph;
import org.fenixedu.academic.dto.person.PhotographUploadBean;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.service.services.ExcepcaoInexistente;
import org.fenixedu.academic.service.services.fileManager.StorePersonalPhoto$callable$run;
import org.fenixedu.academic.service.services.fileManager.StorePersonalPhoto$callable$uploadPhoto;
import org.fenixedu.academic.util.ContentType;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class StorePersonalPhoto {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$uploadPhoto = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void run(byte[] byArray, ContentType contentType, String string) throws ExcepcaoInexistente {
        Object object = advice$run.perform((Callable)new StorePersonalPhoto$callable$run(byArray, contentType, string));
    }

    static /* synthetic */ void advised$run(byte[] contents, ContentType contentType, String personUsername) throws ExcepcaoInexistente {
        AccessControl.check(RolePredicates.OPERATOR_PREDICATE);
        Person person = Person.readPersonByUsername(personUsername);
        if (person == null) {
            throw new ExcepcaoInexistente("Unknown Person !!");
        }
        StorePersonalPhoto.storePersonalPhoto(contents, contentType, person);
    }

    private static void storePersonalPhoto(byte[] contents, ContentType contentType, Person person) {
        person.setPersonalPhoto(new Photograph(PhotoType.INSTITUTIONAL, contentType, contents));
    }

    public static void uploadPhoto(PhotographUploadBean photographUploadBean, Person person) throws FileNotFoundException, IOException {
        Object object = advice$uploadPhoto.perform((Callable)new StorePersonalPhoto$callable$uploadPhoto(photographUploadBean, person));
    }

    static /* synthetic */ void advised$uploadPhoto(PhotographUploadBean photoBean, Person person) throws FileNotFoundException, IOException {
        AccessControl.check(AcademicPredicates.MANAGE_PHD_PROCESSES);
        try (InputStream stream = photoBean.getFileInputStream();){
            person.setPersonalPhoto(new Photograph(PhotoType.INSTITUTIONAL, ContentType.getContentType(photoBean.getContentType()), ByteStreams.toByteArray((InputStream)stream)));
        }
    }
}

