/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.bolonhaManager;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CurricularStage;
import org.fenixedu.academic.service.services.bolonhaManager.CreateCurricularCourse$callable$run;
import org.fenixedu.academic.service.services.bolonhaManager.CreateCurricularCourse$callable$run$1;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreateCurricularCourse {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$run$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void run(CreateCurricularCourseArgs createCurricularCourseArgs) throws FenixServiceException {
        Object object = advice$run.perform((Callable)new CreateCurricularCourse$callable$run(createCurricularCourseArgs));
    }

    static /* synthetic */ void advised$run(CreateCurricularCourseArgs curricularCourseArgs) throws FenixServiceException {
        DegreeCurricularPlan degreeCurricularPlan = CreateCurricularCourse.readDegreeCurricularPlan(curricularCourseArgs);
        CourseGroup parentCourseGroup = CreateCurricularCourse.readParentCourseGroup(curricularCourseArgs);
        CurricularPeriod curricularPeriod = CreateCurricularCourse.readCurricularPeriod(curricularCourseArgs, degreeCurricularPlan);
        ExecutionSemester beginExecutionPeriod = CreateCurricularCourse.readBeginExecutionPeriod(curricularCourseArgs);
        ExecutionSemester endExecutionPeriod = CreateCurricularCourse.readEndExecutionPeriod(curricularCourseArgs);
        CompetenceCourse competenceCourse = (CompetenceCourse)FenixFramework.getDomainObject((String)curricularCourseArgs.getCompetenceCourseID());
        if (competenceCourse == null) {
            throw new FenixServiceException("error.noCompetenceCourse");
        }
        if (competenceCourse.isAnual()) {
            degreeCurricularPlan.createCurricularPeriodFor(curricularCourseArgs.getYear(), curricularCourseArgs.getSemester() + 1);
        }
        degreeCurricularPlan.createCurricularCourse(curricularCourseArgs.getWeight(), curricularCourseArgs.getPrerequisites(), curricularCourseArgs.getPrerequisitesEn(), CurricularStage.DRAFT, competenceCourse, parentCourseGroup, curricularPeriod, beginExecutionPeriod, endExecutionPeriod);
    }

    public static void run(CreateOptionalCurricularCourseArgs createOptionalCurricularCourseArgs) throws FenixServiceException {
        Object object = advice$run$1.perform((Callable)new CreateCurricularCourse$callable$run$1(createOptionalCurricularCourseArgs));
    }

    static /* synthetic */ void advised$run(CreateOptionalCurricularCourseArgs curricularCourseArgs) throws FenixServiceException {
        DegreeCurricularPlan degreeCurricularPlan = CreateCurricularCourse.readDegreeCurricularPlan(curricularCourseArgs);
        CourseGroup parentCourseGroup = CreateCurricularCourse.readParentCourseGroup(curricularCourseArgs);
        CurricularPeriod curricularPeriod = CreateCurricularCourse.readCurricularPeriod(curricularCourseArgs, degreeCurricularPlan);
        ExecutionSemester beginExecutionPeriod = CreateCurricularCourse.readBeginExecutionPeriod(curricularCourseArgs);
        ExecutionSemester endExecutionPeriod = CreateCurricularCourse.readEndExecutionPeriod(curricularCourseArgs);
        degreeCurricularPlan.createOptionalCurricularCourse(parentCourseGroup, curricularCourseArgs.getName(), curricularCourseArgs.getNameEn(), CurricularStage.DRAFT, curricularPeriod, beginExecutionPeriod, endExecutionPeriod);
    }

    private static DegreeCurricularPlan readDegreeCurricularPlan(CurricularCourseArgs curricularCourseArgs) throws FenixServiceException {
        DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)curricularCourseArgs.getDegreeCurricularPlanID());
        if (degreeCurricularPlan == null) {
            throw new FenixServiceException("error.noDegreeCurricularPlan");
        }
        return degreeCurricularPlan;
    }

    private static CourseGroup readParentCourseGroup(CurricularCourseArgs curricularCourseArgs) throws FenixServiceException {
        CourseGroup parentCourseGroup = (CourseGroup)FenixFramework.getDomainObject((String)curricularCourseArgs.getParentCourseGroupID());
        if (parentCourseGroup == null) {
            throw new FenixServiceException("error.noCourseGroup");
        }
        return parentCourseGroup;
    }

    private static CurricularPeriod readCurricularPeriod(CurricularCourseArgs curricularCourseArgs, DegreeCurricularPlan degreeCurricularPlan) {
        CurricularPeriod curricularPeriod = degreeCurricularPlan.getCurricularPeriodFor(curricularCourseArgs.getYear(), curricularCourseArgs.getSemester());
        if (curricularPeriod == null) {
            curricularPeriod = degreeCurricularPlan.createCurricularPeriodFor(curricularCourseArgs.getYear(), curricularCourseArgs.getSemester());
        }
        return curricularPeriod;
    }

    private static ExecutionSemester readBeginExecutionPeriod(CurricularCourseArgs curricularCourseArgs) {
        ExecutionSemester beginExecutionPeriod = curricularCourseArgs.getBeginExecutionPeriodID() == null ? ExecutionSemester.readActualExecutionSemester() : (ExecutionSemester)FenixFramework.getDomainObject((String)curricularCourseArgs.getBeginExecutionPeriodID());
        return beginExecutionPeriod;
    }

    private static ExecutionSemester readEndExecutionPeriod(CurricularCourseArgs curricularCourseArgs) {
        ExecutionSemester endExecutionPeriod = curricularCourseArgs.getEndExecutionPeriodID() == null ? null : (ExecutionSemester)FenixFramework.getDomainObject((String)curricularCourseArgs.getEndExecutionPeriodID());
        return endExecutionPeriod;
    }

    public static class CreateOptionalCurricularCourseArgs
    extends CurricularCourseArgs {
        private String name;
        private String nameEn;

        public CreateOptionalCurricularCourseArgs(String degreeCurricularPlanID, String parentCourseGroupID, String name, String nameEn, Integer year, Integer semester, String beginExecutionPeriodID, String endExecutionPeriodID) {
            this.setDegreeCurricularPlanID(degreeCurricularPlanID);
            this.setParentCourseGroupID(parentCourseGroupID);
            this.setName(name);
            this.setNameEn(nameEn);
            this.setYear(year);
            this.setSemester(semester);
            this.setBeginExecutionPeriodID(beginExecutionPeriodID);
            this.setEndExecutionPeriodID(endExecutionPeriodID);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNameEn() {
            return this.nameEn;
        }

        public void setNameEn(String nameEn) {
            this.nameEn = nameEn;
        }
    }

    public static class CreateCurricularCourseArgs
    extends CurricularCourseArgs {
        private Double weight;
        private String prerequisites;
        private String prerequisitesEn;
        private String competenceCourseID;

        public CreateCurricularCourseArgs(Double weight, String prerequisites, String prerequisitesEn, String competenceCourseID, String parentCourseGroupID, Integer year, Integer semester, String degreeCurricularPlanID, String beginExecutionPeriodID, String endExecutionPeriodID) {
            this.setWeight(weight);
            this.setPrerequisites(prerequisites);
            this.setPrerequisitesEn(prerequisitesEn);
            this.setCompetenceCourseID(competenceCourseID);
            this.setParentCourseGroupID(parentCourseGroupID);
            this.setYear(year);
            this.setSemester(semester);
            this.setDegreeCurricularPlanID(degreeCurricularPlanID);
            this.setBeginExecutionPeriodID(beginExecutionPeriodID);
            this.setEndExecutionPeriodID(endExecutionPeriodID);
        }

        public String getCompetenceCourseID() {
            return this.competenceCourseID;
        }

        public void setCompetenceCourseID(String competenceCourseID) {
            this.competenceCourseID = competenceCourseID;
        }

        public String getPrerequisites() {
            return this.prerequisites;
        }

        public void setPrerequisites(String prerequisites) {
            this.prerequisites = prerequisites;
        }

        public String getPrerequisitesEn() {
            return this.prerequisitesEn;
        }

        public void setPrerequisitesEn(String prerequisitesEn) {
            this.prerequisitesEn = prerequisitesEn;
        }

        public Double getWeight() {
            return this.weight;
        }

        public void setWeight(Double weight) {
            this.weight = weight;
        }
    }

    private static abstract class CurricularCourseArgs {
        private String degreeCurricularPlanID;
        private String parentCourseGroupID;
        private Integer year;
        private Integer semester;
        private String beginExecutionPeriodID;
        private String endExecutionPeriodID;

        private CurricularCourseArgs() {
        }

        public String getBeginExecutionPeriodID() {
            return this.beginExecutionPeriodID;
        }

        public void setBeginExecutionPeriodID(String beginExecutionPeriodID) {
            this.beginExecutionPeriodID = beginExecutionPeriodID;
        }

        public String getDegreeCurricularPlanID() {
            return this.degreeCurricularPlanID;
        }

        public void setDegreeCurricularPlanID(String degreeCurricularPlanID) {
            this.degreeCurricularPlanID = degreeCurricularPlanID;
        }

        public String getEndExecutionPeriodID() {
            return this.endExecutionPeriodID;
        }

        public void setEndExecutionPeriodID(String endExecutionPeriodID) {
            this.endExecutionPeriodID = endExecutionPeriodID;
        }

        public String getParentCourseGroupID() {
            return this.parentCourseGroupID;
        }

        public void setParentCourseGroupID(String parentCourseGroupID) {
            this.parentCourseGroupID = parentCourseGroupID;
        }

        public Integer getSemester() {
            return this.semester;
        }

        public void setSemester(Integer semester) {
            this.semester = semester;
        }

        public Integer getYear() {
            return this.year;
        }

        public void setYear(Integer year) {
            this.year = year;
        }
    }
}

