/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.alumni;

import java.lang.annotation.Annotation;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Alumni;
import org.fenixedu.academic.domain.AlumniIdentityCheckRequest;
import org.fenixedu.academic.domain.AlumniManager;
import org.fenixedu.academic.domain.Job;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.Phone;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.contacts.PhysicalAddressData;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.alumni.AlumniAddressBean;
import org.fenixedu.academic.dto.alumni.AlumniIdentityCheckRequestBean;
import org.fenixedu.academic.dto.alumni.AlumniJobBean;
import org.fenixedu.academic.dto.alumni.publicAccess.AlumniPasswordBean;
import org.fenixedu.academic.dto.alumni.publicAccess.AlumniPublicAccessBean;
import org.fenixedu.academic.service.services.alumni.RegisterAlumniData$callable$run;
import org.fenixedu.academic.service.services.alumni.RegisterAlumniData$callable$run$1;
import org.fenixedu.academic.service.services.alumni.RegisterAlumniData$callable$run$2;
import org.fenixedu.academic.service.services.alumni.RegisterAlumniData$callable$run$3;
import org.fenixedu.academic.service.services.alumni.RegisterAlumniData$callable$run$4;
import org.fenixedu.academic.service.services.alumni.RegisterAlumniData$callable$run$5;
import org.fenixedu.academic.service.services.alumni.RegisterAlumniData$callable$run$6;
import org.fenixedu.academic.service.services.alumni.RegisterAlumniData$callable$runRegisterAlumniData;
import org.fenixedu.academic.service.services.commons.alumni.AlumniNotificationService;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class RegisterAlumniData
extends AlumniNotificationService {
    private static final RegisterAlumniData serviceInstance;
    public static final Advice advice$run;
    public static final Advice advice$run$1;
    public static final Advice advice$run$2;
    public static final Advice advice$run$3;
    public static final Advice advice$run$4;
    public static final Advice advice$run$5;
    public static final Advice advice$run$6;
    public static final Advice advice$runRegisterAlumniData;

    public static Alumni run(Alumni alumni, UUID uUID) throws FenixServiceException {
        return (Alumni)((Object)advice$run.perform((Callable)new RegisterAlumniData$callable$run(alumni, uUID)));
    }

    static /* synthetic */ Alumni advised$run(Alumni alumni, UUID urlRequestToken) throws FenixServiceException {
        if (alumni == null) {
            throw new FenixServiceException("alumni.uuid.update.alumni.null");
        }
        alumni.setUrlRequestToken(urlRequestToken);
        return alumni;
    }

    public static Alumni run(Alumni alumni, Boolean bl) throws FenixServiceException {
        return (Alumni)((Object)advice$run$1.perform((Callable)new RegisterAlumniData$callable$run$1(alumni, bl)));
    }

    static /* synthetic */ Alumni advised$run(Alumni alumni, Boolean registered) throws FenixServiceException {
        alumni.setRegistered(registered);
        if (registered.booleanValue()) {
            RegisterAlumniData.sendRegistrationSuccessMail(alumni);
        }
        return alumni;
    }

    public static Alumni run(Student student) {
        return (Alumni)((Object)advice$run$2.perform((Callable)new RegisterAlumniData$callable$run$2(student)));
    }

    static /* synthetic */ Alumni advised$run(Student student) {
        return new AlumniManager().registerAlumni(student);
    }

    public static Alumni run(Integer n, String string, String string2) {
        return (Alumni)((Object)advice$run$3.perform((Callable)new RegisterAlumniData$callable$run$3(n, string, string2)));
    }

    static /* synthetic */ Alumni advised$run(Integer studentNumber, String documentIdNumber, String email) {
        Alumni alumni = new AlumniManager().registerAlumni(studentNumber, documentIdNumber, email);
        RegisterAlumniData.sendPublicAccessMail(alumni, email);
        return alumni;
    }

    public static void run(AlumniPublicAccessBean alumniPublicAccessBean, Boolean bl) throws FenixServiceException {
        Object object = advice$run$4.perform((Callable)new RegisterAlumniData$callable$run$4(alumniPublicAccessBean, bl));
    }

    static /* synthetic */ void advised$run(AlumniPublicAccessBean alumniBean, Boolean isEmployed) throws FenixServiceException {
        Person person = alumniBean.getAlumni().getStudent().getPerson();
        if (person == null) {
            throw new FenixServiceException("alumni.partyContact.creation.person.null");
        }
        try {
            RegisterAlumniData.processAlumniPhone(alumniBean, person);
            RegisterAlumniData.processAlumniAddress(alumniBean, person);
            if (isEmployed.booleanValue()) {
                RegisterAlumniData.processAlumniJob(alumniBean);
            }
            alumniBean.getAlumni().setIsEmployed(isEmployed);
        }
        catch (DomainException e) {
            throw new FenixServiceException(e.getMessage());
        }
    }

    public static void run(AlumniIdentityCheckRequestBean alumniIdentityCheckRequestBean) {
        Object object = advice$run$5.perform((Callable)new RegisterAlumniData$callable$run$5(alumniIdentityCheckRequestBean));
    }

    static /* synthetic */ void advised$run(AlumniIdentityCheckRequestBean bean) {
        Alumni alumni = new AlumniManager().checkAlumniIdentity(bean.getDocumentIdNumber(), bean.getContactEmail());
        if (!alumni.hasAnyPendingIdentityRequests()) {
            AlumniIdentityCheckRequest identityRequest = new AlumniIdentityCheckRequest(bean.getContactEmail(), bean.getDocumentIdNumber(), bean.getFullName(), bean.getDateOfBirthYearMonthDay(), bean.getDistrictOfBirth(), bean.getDistrictSubdivisionOfBirth(), bean.getParishOfBirth(), bean.getSocialSecurityNumber(), bean.getNameOfFather(), bean.getNameOfMother(), bean.getRequestType());
            identityRequest.setAlumni(alumni);
            if (identityRequest.isValid()) {
                identityRequest.validate(Boolean.TRUE);
                RegisterAlumniData.sendIdentityCheckEmail(identityRequest, Boolean.TRUE);
            }
        } else {
            throw new DomainException("alumni.has.pending.identity.requests", new String[0]);
        }
    }

    public static void run(AlumniPasswordBean alumniPasswordBean) {
        Object object = advice$run$6.perform((Callable)new RegisterAlumniData$callable$run$6(alumniPasswordBean));
    }

    static /* synthetic */ void advised$run(AlumniPasswordBean bean) {
        bean.getAlumni().setRegistered(Boolean.TRUE);
        if (!bean.getAlumni().hasAnyPendingIdentityRequests()) {
            EmailAddress personalEmail = bean.getAlumni().getPersonalEmail();
            String email = personalEmail == null ? bean.getAlumni().getStudent().getPerson().getEmailForSendingEmails() : personalEmail.getValue();
            AlumniIdentityCheckRequest identityRequest = new AlumniIdentityCheckRequest(email, bean.getAlumni().getStudent().getPerson().getDocumentIdNumber(), bean.getFullName(), bean.getDateOfBirthYearMonthDay(), bean.getDistrictOfBirth(), bean.getDistrictSubdivisionOfBirth(), bean.getParishOfBirth(), bean.getSocialSecurityNumber(), bean.getNameOfFather(), bean.getNameOfMother(), bean.getRequestType());
            identityRequest.setAlumni(bean.getAlumni());
            if (identityRequest.isValid()) {
                identityRequest.validate(Boolean.TRUE);
                RegisterAlumniData.sendIdentityCheckEmail(identityRequest, Boolean.TRUE);
            }
        }
    }

    private static void processAlumniJob(AlumniPublicAccessBean alumniBean) {
        if (alumniBean.getCurrentJob() == null) {
            AlumniJobBean jobBean = alumniBean.getJobBean();
            new Job(jobBean.getAlumni().getStudent().getPerson(), jobBean.getEmployerName(), jobBean.getCity(), jobBean.getCountry(), jobBean.getChildBusinessArea(), jobBean.getParentBusinessArea(), jobBean.getPosition(), jobBean.getBeginDateAsLocalDate(), jobBean.getEndDateAsLocalDate(), jobBean.getApplicationType(), jobBean.getContractType(), jobBean.getSalary());
        } else {
            AlumniJobBean jobBean = alumniBean.getJobBean();
            alumniBean.getCurrentJob().setEmployerName(jobBean.getEmployerName());
            alumniBean.getCurrentJob().setCity(jobBean.getCity());
            alumniBean.getCurrentJob().setCountry(jobBean.getCountry());
            alumniBean.getCurrentJob().setBusinessArea(jobBean.getChildBusinessArea());
            alumniBean.getCurrentJob().setParentBusinessArea(jobBean.getParentBusinessArea());
            alumniBean.getCurrentJob().setPosition(jobBean.getPosition());
            alumniBean.getCurrentJob().setBeginDate(jobBean.getBeginDateAsLocalDate());
            alumniBean.getCurrentJob().setEndDate(jobBean.getEndDateAsLocalDate());
            alumniBean.getCurrentJob().setJobApplicationType(jobBean.getApplicationType());
            alumniBean.getCurrentJob().setContractType(jobBean.getContractType());
            alumniBean.getCurrentJob().setSalary(jobBean.getSalary());
        }
    }

    private static void processAlumniAddress(AlumniPublicAccessBean alumniBean, Person person) {
        AlumniAddressBean addressBean = alumniBean.getAddressBean();
        if (alumniBean.getCurrentPhysicalAddress() == null) {
            PhysicalAddress.createPhysicalAddress((Party)((Object)person), new PhysicalAddressData(addressBean.getAddress(), addressBean.getAreaCode(), addressBean.getAreaOfAreaCode(), null), PartyContactType.PERSONAL, false);
        } else {
            PhysicalAddress address = alumniBean.getCurrentPhysicalAddress();
            address.setAddress(addressBean.getAddress());
            address.setAreaCode(addressBean.getAreaCode());
            address.setAreaOfAreaCode(addressBean.getAreaOfAreaCode());
            address.setCountryOfResidence(addressBean.getCountry());
        }
    }

    private static void processAlumniPhone(AlumniPublicAccessBean alumniBean, Person person) {
        if (alumniBean.getCurrentPhone() == null) {
            Phone.createPhone((Party)((Object)person), alumniBean.getPhone(), PartyContactType.PERSONAL, true);
        } else {
            alumniBean.getCurrentPhone().setNumber(alumniBean.getPhone());
        }
    }

    public static Alumni runRegisterAlumniData(Alumni alumni, UUID uUID) throws FenixServiceException {
        return (Alumni)((Object)advice$runRegisterAlumniData.perform((Callable)new RegisterAlumniData$callable$runRegisterAlumniData(alumni, uUID)));
    }

    static /* synthetic */ Alumni advised$runRegisterAlumniData(Alumni alumni, UUID urlRequestToken) throws FenixServiceException {
        return RegisterAlumniData.run(alumni, urlRequestToken);
    }

    static {
        advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$run$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$run$2 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$run$3 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$run$4 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$run$5 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$run$6 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$runRegisterAlumniData = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new RegisterAlumniData();
    }
}

