/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.accounting;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PaymentPlan;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.DFAGratuityByAmountPerEctsPR;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.DFAGratuityByNumberOfEnrolmentsPR;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.GratuityWithPaymentPlanPR;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.PastDegreeGratuityPR;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.SpecializationDegreeGratuityByAmountPerEctsPR;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.StandaloneEnrolmentGratuityPR;
import org.fenixedu.academic.domain.accounting.serviceAgreementTemplates.DegreeCurricularPlanServiceAgreementTemplate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.accounting.paymentPlan.InstallmentBean;
import org.fenixedu.academic.dto.accounting.paymentPlan.PaymentPlanBean;
import org.fenixedu.academic.dto.accounting.paymentPlan.StandaloneInstallmentBean;
import org.fenixedu.academic.dto.accounting.postingRule.CreateDFAGratuityPostingRuleBean;
import org.fenixedu.academic.dto.accounting.postingRule.CreateGratuityPostingRuleBean;
import org.fenixedu.academic.dto.accounting.postingRule.CreateSpecializationDegreeGratuityPostingRuleBean;
import org.fenixedu.academic.dto.accounting.postingRule.CreateStandaloneEnrolmentGratuityPRBean;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.services.accounting.PostingRulesManager$callable$createDEAGratuityPostingRule;
import org.fenixedu.academic.service.services.accounting.PostingRulesManager$callable$createDEAStandaloneGratuityPostingRule;
import org.fenixedu.academic.service.services.accounting.PostingRulesManager$callable$createDFAGratuityPostingRule;
import org.fenixedu.academic.service.services.accounting.PostingRulesManager$callable$createGraduationGratuityPostingRule;
import org.fenixedu.academic.service.services.accounting.PostingRulesManager$callable$createSpecializationDegreeGratuityPostingRule;
import org.fenixedu.academic.service.services.accounting.PostingRulesManager$callable$createStandaloneGraduationGratuityPostingRule;
import org.fenixedu.academic.service.services.accounting.PostingRulesManager$callable$deleteDEAPostingRule;
import org.fenixedu.academic.service.services.accounting.PostingRulesManager$callable$deletePostingRule;
import org.fenixedu.academic.service.services.accounting.gratuity.paymentPlan.GratuityPaymentPlanManager;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PostingRulesManager {
    public static final Advice advice$createGraduationGratuityPostingRule = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createStandaloneGraduationGratuityPostingRule = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createDFAGratuityPostingRule = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createSpecializationDegreeGratuityPostingRule = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$deleteDEAPostingRule = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$deletePostingRule = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createDEAGratuityPostingRule = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createDEAStandaloneGratuityPostingRule = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void createGraduationGratuityPostingRule(CreateGratuityPostingRuleBean createGratuityPostingRuleBean) {
        Object object = advice$createGraduationGratuityPostingRule.perform((Callable)new PostingRulesManager$callable$createGraduationGratuityPostingRule(createGratuityPostingRuleBean));
    }

    static /* synthetic */ void advised$createGraduationGratuityPostingRule(CreateGratuityPostingRuleBean bean) {
        AccessControl.check(AcademicPredicates.MANAGE_PAYMENTS);
        if (bean.getRule() == GratuityWithPaymentPlanPR.class) {
            for (DegreeCurricularPlan dcp : bean.getDegreeCurricularPlans()) {
                if (dcp.isPast()) continue;
                PostingRulesManager.deactivateExistingPostingRule(EventType.GRATUITY, bean.getStartDate(), (ServiceAgreementTemplate)((Object)dcp.getServiceAgreementTemplate()));
                new GratuityWithPaymentPlanPR(bean.getStartDate(), null, (ServiceAgreementTemplate)((Object)dcp.getServiceAgreementTemplate()));
            }
        } else if (bean.getRule() == PastDegreeGratuityPR.class) {
            for (DegreeCurricularPlan dcp : bean.getDegreeCurricularPlans()) {
                if (!dcp.isPast()) continue;
                PostingRulesManager.deactivateExistingPostingRule(EventType.GRATUITY, bean.getStartDate(), (ServiceAgreementTemplate)((Object)dcp.getServiceAgreementTemplate()));
                new PastDegreeGratuityPR(bean.getStartDate(), null, dcp.getServiceAgreementTemplate());
            }
        } else {
            throw new RuntimeException("Unexpected rule type for gratuity posting rule");
        }
    }

    public static void createStandaloneGraduationGratuityPostingRule(CreateStandaloneEnrolmentGratuityPRBean createStandaloneEnrolmentGratuityPRBean) {
        Object object = advice$createStandaloneGraduationGratuityPostingRule.perform((Callable)new PostingRulesManager$callable$createStandaloneGraduationGratuityPostingRule(createStandaloneEnrolmentGratuityPRBean));
    }

    static /* synthetic */ void advised$createStandaloneGraduationGratuityPostingRule(CreateStandaloneEnrolmentGratuityPRBean bean) {
        AccessControl.check(AcademicPredicates.MANAGE_PAYMENTS);
        if (bean.getRule() == StandaloneEnrolmentGratuityPR.class) {
            for (DegreeCurricularPlan degreeCurricularPlan : bean.getDegreeCurricularPlans()) {
                DegreeCurricularPlanServiceAgreementTemplate serviceAgreementTemplate = degreeCurricularPlan.getServiceAgreementTemplate();
                PostingRulesManager.deactivateExistingPostingRule(EventType.STANDALONE_ENROLMENT_GRATUITY, bean.getStartDate(), (ServiceAgreementTemplate)((Object)serviceAgreementTemplate));
                new StandaloneEnrolmentGratuityPR(bean.getStartDate(), null, (ServiceAgreementTemplate)((Object)serviceAgreementTemplate), bean.getEctsForYear(), bean.getGratuityFactor(), bean.getEctsFactor());
            }
        } else {
            throw new RuntimeException("Unexpected rule type for gratuity posting rule");
        }
    }

    private static void deactivateExistingPostingRule(EventType eventType, DateTime when, ServiceAgreementTemplate serviceAgreementTemplate) {
        if (!serviceAgreementTemplate.hasPostingRuleFor(eventType, when)) {
            return;
        }
        PostingRule existingPostingRule = serviceAgreementTemplate.findPostingRuleByEventTypeAndDate(eventType, when);
        if (existingPostingRule != null) {
            existingPostingRule.deactivate(when);
        }
    }

    public static void createDFAGratuityPostingRule(CreateDFAGratuityPostingRuleBean createDFAGratuityPostingRuleBean) {
        Object object = advice$createDFAGratuityPostingRule.perform((Callable)new PostingRulesManager$callable$createDFAGratuityPostingRule(createDFAGratuityPostingRuleBean));
    }

    static /* synthetic */ void advised$createDFAGratuityPostingRule(CreateDFAGratuityPostingRuleBean bean) {
        AccessControl.check(AcademicPredicates.MANAGE_PAYMENTS);
        if (bean.getRule() == DFAGratuityByAmountPerEctsPR.class) {
            new DFAGratuityByAmountPerEctsPR(bean.getStartDate(), null, (ServiceAgreementTemplate)((Object)bean.getServiceAgreementTemplate()), bean.getTotalAmount(), bean.getPartialAcceptedPercentage(), bean.getAmountPerEctsCredit());
        } else if (bean.getRule() == DFAGratuityByNumberOfEnrolmentsPR.class) {
            new DFAGratuityByNumberOfEnrolmentsPR(bean.getStartDate(), null, (ServiceAgreementTemplate)((Object)bean.getServiceAgreementTemplate()), bean.getTotalAmount(), bean.getPartialAcceptedPercentage());
        } else {
            throw new RuntimeException("Unexpected rule type for DFA gratuity posting rule");
        }
    }

    public static void createSpecializationDegreeGratuityPostingRule(CreateSpecializationDegreeGratuityPostingRuleBean createSpecializationDegreeGratuityPostingRuleBean) {
        Object object = advice$createSpecializationDegreeGratuityPostingRule.perform((Callable)new PostingRulesManager$callable$createSpecializationDegreeGratuityPostingRule(createSpecializationDegreeGratuityPostingRuleBean));
    }

    static /* synthetic */ void advised$createSpecializationDegreeGratuityPostingRule(CreateSpecializationDegreeGratuityPostingRuleBean bean) {
        AccessControl.check(AcademicPredicates.MANAGE_PAYMENTS);
        if (bean.getRule() != SpecializationDegreeGratuityByAmountPerEctsPR.class) {
            throw new RuntimeException("Unexpected rule type for Specialization Degree gratuity posting rule");
        }
        new SpecializationDegreeGratuityByAmountPerEctsPR(bean.getStartDate(), null, (ServiceAgreementTemplate)((Object)bean.getServiceAgreementTemplate()), bean.getTotalAmount(), bean.getPartialAcceptedPercentage(), bean.getAmountPerEctsCredit());
    }

    public static void deleteDEAPostingRule(PostingRule postingRule) {
        Object object = advice$deleteDEAPostingRule.perform((Callable)new PostingRulesManager$callable$deleteDEAPostingRule(postingRule));
    }

    static /* synthetic */ void advised$deleteDEAPostingRule(PostingRule postingRule) {
        AccessControl.check(AcademicPredicates.MANAGE_PAYMENTS);
        for (PaymentPlan paymentPlan : postingRule.getServiceAgreementTemplate().getPaymentPlansSet()) {
            paymentPlan.delete();
        }
        PostingRulesManager.deletePostingRule(postingRule);
    }

    public static void deletePostingRule(PostingRule postingRule) {
        Object object = advice$deletePostingRule.perform((Callable)new PostingRulesManager$callable$deletePostingRule(postingRule));
    }

    static /* synthetic */ void advised$deletePostingRule(PostingRule postingRule) {
        AccessControl.check(AcademicPredicates.MANAGE_PAYMENTS);
        postingRule.delete();
    }

    public static void createDEAGratuityPostingRule(PaymentPlanBean paymentPlanBean) {
        Object object = advice$createDEAGratuityPostingRule.perform((Callable)new PostingRulesManager$callable$createDEAGratuityPostingRule(paymentPlanBean));
    }

    static /* synthetic */ void advised$createDEAGratuityPostingRule(PaymentPlanBean paymentPlanBean) {
        AccessControl.check(AcademicPredicates.MANAGE_PAYMENTS);
        CreateGratuityPostingRuleBean createGratuityPostingRuleBean = new CreateGratuityPostingRuleBean();
        createGratuityPostingRuleBean.setExecutionYear(paymentPlanBean.getExecutionYear());
        createGratuityPostingRuleBean.setDegreeCurricularPlans(paymentPlanBean.getDegreeCurricularPlans());
        DateTime minStartDate = null;
        for (InstallmentBean installmentBean : paymentPlanBean.getInstallments()) {
            if (minStartDate == null) {
                minStartDate = installmentBean.getStartDate().toDateMidnight().toDateTime();
                continue;
            }
            if (!installmentBean.getStartDate().toDateMidnight().toDateTime().isBefore((ReadableInstant)minStartDate)) continue;
            minStartDate = installmentBean.getStartDate().toDateMidnight().toDateTime();
        }
        createGratuityPostingRuleBean.setStartDate(minStartDate);
        createGratuityPostingRuleBean.setRule(GratuityWithPaymentPlanPR.class);
        PostingRulesManager.createGraduationGratuityPostingRule(createGratuityPostingRuleBean);
        GratuityPaymentPlanManager.create(paymentPlanBean);
    }

    public static void createDEAStandaloneGratuityPostingRule(StandaloneInstallmentBean standaloneInstallmentBean, DegreeCurricularPlan degreeCurricularPlan) {
        Object object = advice$createDEAStandaloneGratuityPostingRule.perform((Callable)new PostingRulesManager$callable$createDEAStandaloneGratuityPostingRule(standaloneInstallmentBean, degreeCurricularPlan));
    }

    static /* synthetic */ void advised$createDEAStandaloneGratuityPostingRule(StandaloneInstallmentBean bean, DegreeCurricularPlan degreeCurricularPlan) {
        AccessControl.check(AcademicPredicates.MANAGE_PAYMENTS);
        DegreeCurricularPlanServiceAgreementTemplate dcpSAT = degreeCurricularPlan.getServiceAgreementTemplate();
        if (dcpSAT == null) {
            throw new DomainException("StandaloneEnrolmentGratuityPR.DegreeCurricularPlanServiceAgreementTemplate.cannot.be.null", new String[0]);
        }
        YearMonthDay startDate = bean.getStartDate();
        LocalDate startLocalDate = new LocalDate(startDate.getYear(), startDate.getMonthOfYear(), startDate.getDayOfMonth());
        BigDecimal ectsForYear = bean.getEctsForYear();
        BigDecimal gratuityFactor = bean.getGratuityFactor();
        BigDecimal ectsFactor = bean.getEctsFactor();
        new StandaloneEnrolmentGratuityPR(startLocalDate.toDateTimeAtStartOfDay(), null, (ServiceAgreementTemplate)((Object)dcpSAT), ectsForYear, gratuityFactor, ectsFactor);
    }
}

