/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.spaceManager;

import java.io.Serializable;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Partial;
import org.joda.time.YearMonthDay;

public class ViewEventSpaceOccupationsBean
implements Serializable {
    private Partial year;
    private Partial month;
    private YearMonthDay day;
    private Space allocatableSpaceReference;
    public static int MONDAY_IN_JODA_TIME = 1;
    public static int SATURDAY_IN_JODA_TIME = 6;

    public ViewEventSpaceOccupationsBean(YearMonthDay day, Space allocatableSpace) {
        this.setAllocatableSpace(allocatableSpace);
        if (day != null) {
            this.setYear(new Partial(DateTimeFieldType.year(), day.getYear()));
            this.setMonth(new Partial(DateTimeFieldType.monthOfYear(), day.getMonthOfYear()));
            YearMonthDay monday = day.toDateTimeAtMidnight().withDayOfWeek(MONDAY_IN_JODA_TIME).toYearMonthDay();
            if (monday.getMonthOfYear() < day.getMonthOfYear() || monday.getYear() < day.getYear()) {
                monday = monday.plusDays(Lesson.NUMBER_OF_DAYS_IN_WEEK);
            }
            this.setDay(monday);
        }
    }

    public Space getAllocatableSpace() {
        return this.allocatableSpaceReference;
    }

    public void setAllocatableSpace(Space space) {
        this.allocatableSpaceReference = space;
    }

    public Partial getYear() {
        return this.year;
    }

    public void setYear(Partial year) {
        this.year = year;
    }

    public Partial getMonth() {
        return this.month;
    }

    public void setMonth(Partial month) {
        this.month = month;
    }

    public YearMonthDay getDay() {
        return this.day;
    }

    public void setDay(YearMonthDay firstDayOWeek) {
        this.day = firstDayOWeek;
    }
}

