/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeInfo;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.dto.InfoDegreeCurricularPlan;
import org.fenixedu.academic.dto.InfoDegreeInfo;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.commons.i18n.I18N;

public class InfoDegree
extends InfoObject
implements Comparable {
    private final Degree degreeDomainReference;
    private final boolean showEnVersion = I18N.getLocale().equals(MultiLanguageString.en);

    public InfoDegree(Degree degree) {
        this.degreeDomainReference = degree;
    }

    public Degree getDegree() {
        return this.degreeDomainReference;
    }

    public String toString() {
        return this.getDegree().toString();
    }

    public String getSigla() {
        return this.getDegree().getSigla();
    }

    public String getNome() {
        return this.showEnVersion && !StringUtils.isEmpty((String)this.getNameEn()) ? this.getNameEn() : this.getDegree().getNome();
    }

    public String getPresentationName() {
        return this.getDegree().getPresentationName();
    }

    public String getNameEn() {
        return this.getDegree().getNameEn();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof InfoDegree && this.getDegree().equals(((InfoDegree)obj).getDegree());
    }

    public boolean isBolonhaDegree() {
        return this.getDegree().isBolonhaDegree();
    }

    public DegreeType getDegreeType() {
        return this.getDegree().getDegreeType();
    }

    public DegreeType getTipoCurso() {
        return this.getDegree().getDegreeType();
    }

    public List<InfoDegreeCurricularPlan> getInfoDegreeCurricularPlans() {
        ArrayList<InfoDegreeCurricularPlan> infoDegreeCurricularPlans = new ArrayList<InfoDegreeCurricularPlan>();
        for (DegreeCurricularPlan degreeCurricularPlan : this.getDegree().getDegreeCurricularPlansSet()) {
            infoDegreeCurricularPlans.add(InfoDegreeCurricularPlan.newInfoFromDomain(degreeCurricularPlan));
        }
        return infoDegreeCurricularPlans;
    }

    public int compareTo(Object arg0) {
        InfoDegree degree = (InfoDegree)arg0;
        return this.getNome().compareTo(degree.getNome());
    }

    public List<InfoDegreeInfo> getInfoDegreeInfos() {
        ArrayList<InfoDegreeInfo> infoDegreeInfos = new ArrayList<InfoDegreeInfo>();
        for (DegreeInfo degreeInfo : this.getDegree().getDegreeInfosSet()) {
            infoDegreeInfos.add(InfoDegreeInfo.newInfoFromDomain(degreeInfo));
        }
        return infoDegreeInfos;
    }

    public GradeScale getGradeScale() {
        return this.getDegree().getGradeScale();
    }

    public static InfoDegree newInfoFromDomain(Degree degree) {
        return degree == null ? null : new InfoDegree(degree);
    }

    @Override
    public String getExternalId() {
        return this.getDegree().getExternalId();
    }

    @Override
    public void setExternalId(String integer) {
        throw new Error("Method should not be called!");
    }
}

