/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import java.util.Comparator;
import jvstm.cps.ConsistencyPredicate;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.candidacy.PersonalInformationBean;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitUtils;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.student.PersonalIngressionData;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.candidacy.PrecedentDegreeInformationBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;

public class PrecedentDegreeInformation
extends PrecedentDegreeInformation_Base {
    public static Comparator<PrecedentDegreeInformation> COMPARATOR_BY_EXECUTION_YEAR = new Comparator<PrecedentDegreeInformation>(){

        @Override
        public int compare(PrecedentDegreeInformation info1, PrecedentDegreeInformation info2) {
            return info1.getExecutionYear().getYear().compareTo(info2.getExecutionYear().getYear());
        }
    };

    public PrecedentDegreeInformation() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setLastModifiedDate(new DateTime());
    }

    public void edit(PersonalIngressionData personalIngressionData, Registration registration, PrecedentDegreeInformationBean precedentDegreeInformationBean, StudentCandidacy studentCandidacy) {
        this.setPersonalIngressionData(personalIngressionData);
        this.setRegistration(registration);
        this.setStudentCandidacy(studentCandidacy);
        Unit institution = precedentDegreeInformationBean.getInstitution();
        if (institution == null && !StringUtils.isEmpty((String)precedentDegreeInformationBean.getInstitutionName()) && (institution = UnitUtils.readExternalInstitutionUnitByName(precedentDegreeInformationBean.getInstitutionName())) == null) {
            institution = Unit.createNewNoOfficialExternalInstitution(precedentDegreeInformationBean.getInstitutionName());
        }
        this.setInstitution(institution);
        this.setDegreeDesignation(precedentDegreeInformationBean.getDegreeDesignation());
        this.setConclusionGrade(precedentDegreeInformationBean.getConclusionGrade());
        this.setConclusionYear(precedentDegreeInformationBean.getConclusionYear());
        this.setCountry(precedentDegreeInformationBean.getCountry());
        this.setCountryHighSchool(precedentDegreeInformationBean.getCountryWhereFinishedHighSchoolLevel());
        this.setSchoolLevel(precedentDegreeInformationBean.getSchoolLevel());
        this.setOtherSchoolLevel(precedentDegreeInformationBean.getOtherSchoolLevel());
        this.checkAndUpdatePrecedentInformation(precedentDegreeInformationBean);
        this.setLastModifiedDate(new DateTime());
    }

    public void edit(PrecedentDegreeInformationBean precedentDegreeInformationBean) {
        Unit institution = precedentDegreeInformationBean.getInstitution();
        if (institution == null && !StringUtils.isEmpty((String)precedentDegreeInformationBean.getInstitutionName()) && (institution = UnitUtils.readExternalInstitutionUnitByName(precedentDegreeInformationBean.getInstitutionName())) == null) {
            institution = Unit.createNewNoOfficialExternalInstitution(precedentDegreeInformationBean.getInstitutionName());
        }
        this.setInstitution(institution);
        this.setDegreeDesignation(precedentDegreeInformationBean.getDegreeDesignation());
        this.setConclusionGrade(precedentDegreeInformationBean.getConclusionGrade());
        this.setConclusionYear(precedentDegreeInformationBean.getConclusionYear());
        this.setCountry(precedentDegreeInformationBean.getCountry());
        this.setCountryHighSchool(precedentDegreeInformationBean.getCountryWhereFinishedHighSchoolLevel());
        this.setSchoolLevel(precedentDegreeInformationBean.getSchoolLevel());
        this.setOtherSchoolLevel(precedentDegreeInformationBean.getOtherSchoolLevel());
        this.setLastModifiedDate(new DateTime());
    }

    public String getInstitutionName() {
        return this.getInstitution() != null ? this.getInstitution().getName() : null;
    }

    public ExecutionYear getExecutionYear() {
        return this.getPersonalIngressionData().getExecutionYear();
    }

    public void edit(PersonalInformationBean bean, boolean isStudentEditing) {
        this.setConclusionGrade(bean.getConclusionGrade());
        this.setConclusionYear(bean.getConclusionYear());
        this.setCountry(bean.getCountryWhereFinishedPreviousCompleteDegree());
        this.setCountryHighSchool(bean.getCountryWhereFinishedHighSchoolLevel());
        Unit institution = bean.getInstitution();
        if (institution == null && !StringUtils.isEmpty((String)bean.getInstitutionName()) && (institution = UnitUtils.readExternalInstitutionUnitByName(bean.getInstitutionName())) == null) {
            institution = Unit.createNewNoOfficialExternalInstitution(bean.getInstitutionName());
        }
        this.setInstitution(institution);
        this.setDegreeDesignation(bean.getDegreeDesignation());
        this.setSchoolLevel(bean.getSchoolLevel());
        this.setOtherSchoolLevel(bean.getOtherSchoolLevel());
        if (!isStudentEditing) {
            this.checkAndUpdatePrecedentInformation(bean);
        }
        this.setLastModifiedDate(new DateTime());
    }

    private void checkAndUpdatePrecedentInformation(PrecedentDegreeInformationBean precedentDegreeInformationBean) {
        if (precedentDegreeInformationBean.isDegreeChangeOrTransferOrErasmusStudent()) {
            Unit precedentInstitution = precedentDegreeInformationBean.getPrecedentInstitution();
            if (precedentInstitution == null && !StringUtils.isEmpty((String)precedentDegreeInformationBean.getPrecedentInstitutionName()) && (precedentInstitution = UnitUtils.readExternalInstitutionUnitByName(precedentDegreeInformationBean.getPrecedentInstitutionName())) == null) {
                precedentInstitution = Unit.createNewNoOfficialExternalInstitution(precedentDegreeInformationBean.getPrecedentInstitutionName());
            }
            this.setPrecedentInstitution(precedentInstitution);
            this.setPrecedentDegreeDesignation(precedentDegreeInformationBean.getPrecedentDegreeDesignation());
            this.setPrecedentSchoolLevel(precedentDegreeInformationBean.getPrecedentSchoolLevel());
            this.setNumberOfEnrolmentsInPreviousDegrees(precedentDegreeInformationBean.getNumberOfPreviousYearEnrolmentsInPrecedentDegree());
            this.setMobilityProgramDuration(precedentDegreeInformationBean.getMobilityProgramDuration());
        }
    }

    private void checkAndUpdatePrecedentInformation(PersonalInformationBean personalInformationBean) {
        if (personalInformationBean.isDegreeChangeOrTransferOrErasmusStudent()) {
            Unit precedentInstitution = personalInformationBean.getPrecedentInstitution();
            if (precedentInstitution == null && !StringUtils.isEmpty((String)personalInformationBean.getPrecedentInstitutionName()) && (precedentInstitution = UnitUtils.readExternalInstitutionUnitByName(personalInformationBean.getPrecedentInstitutionName())) == null) {
                precedentInstitution = Unit.createNewNoOfficialExternalInstitution(personalInformationBean.getPrecedentInstitutionName());
            }
            this.setPrecedentInstitution(precedentInstitution);
            this.setPrecedentDegreeDesignation(personalInformationBean.getPrecedentDegreeDesignation());
            this.setPrecedentSchoolLevel(personalInformationBean.getPrecedentSchoolLevel());
            if (personalInformationBean.getPrecedentSchoolLevel().equals((Object)SchoolLevelType.OTHER)) {
                this.setOtherPrecedentSchoolLevel(personalInformationBean.getOtherPrecedentSchoolLevel());
            } else {
                this.setOtherPrecedentSchoolLevel(null);
            }
            this.setNumberOfEnrolmentsInPreviousDegrees(personalInformationBean.getNumberOfPreviousYearEnrolmentsInPrecedentDegree());
            this.setMobilityProgramDuration(personalInformationBean.getMobilityProgramDuration());
        }
    }

    public String getDegreeAndInstitutionName() {
        String institutionName = null;
        institutionName = this.getInstitution() != null ? this.getInstitution().getName() : this.getPrecedentInstitution().getName();
        return this.getDegreeDesignation() + " / " + institutionName;
    }

    public void delete() {
        this.setCountry(null);
        this.setCountryHighSchool(null);
        this.setInstitution(null);
        this.setSourceInstitution(null);
        this.setStudent(null);
        this.setRegistration(null);
        this.setPhdIndividualProgramProcess(null);
        this.setStudentCandidacy(null);
        this.setIndividualCandidacy(null);
        this.setPrecedentCountry(null);
        this.setPrecedentInstitution(null);
        this.setPersonalIngressionData(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public void setPersonalIngressionData(PersonalIngressionData personalIngressionData) {
        super.setPersonalIngressionData(personalIngressionData);
        if (personalIngressionData != null && this.getRegistration() != null && PrecedentDegreeInformation.registrationHasRepeatedPDI(this.getRegistration(), personalIngressionData.getExecutionYear())) {
            throw new DomainException("A Registration cannot have two PrecedentDegreeInformations for the same ExecutionYear.", new String[0]);
        }
        if (this.getPhdIndividualProgramProcess() != null && PrecedentDegreeInformation.phdProcessHasRepeatedPDI(this.getPhdIndividualProgramProcess(), personalIngressionData.getExecutionYear())) {
            throw new DomainException("A Phd Process cannot have two PrecedentDegreeInformations for the same ExecutionYear.", new String[0]);
        }
    }

    public void setRegistration(Registration registration) {
        super.setRegistration(registration);
        if (registration != null && this.getPersonalIngressionData() != null && PrecedentDegreeInformation.registrationHasRepeatedPDI(registration, this.getPersonalIngressionData().getExecutionYear())) {
            throw new DomainException("A Registration cannot have two PrecedentDegreeInformations for the same ExecutionYear.", new String[0]);
        }
    }

    public void setPhdIndividualProgramProcess(PhdIndividualProgramProcess phdIndividualProgramProcess) {
        super.setPhdIndividualProgramProcess(phdIndividualProgramProcess);
        if (phdIndividualProgramProcess != null && this.getPersonalIngressionData() != null && PrecedentDegreeInformation.phdProcessHasRepeatedPDI(phdIndividualProgramProcess, this.getPersonalIngressionData().getExecutionYear())) {
            throw new DomainException("A Registration cannot have two PrecedentDegreeInformations for the same ExecutionYear.", new String[0]);
        }
    }

    private static boolean registrationHasRepeatedPDI(Registration registration, ExecutionYear executionYear) {
        PrecedentDegreeInformation existingPdi = null;
        for (PrecedentDegreeInformation pdi : registration.getPrecedentDegreesInformationsSet()) {
            if (!pdi.getExecutionYear().equals(executionYear)) continue;
            if (existingPdi == null) {
                existingPdi = pdi;
                continue;
            }
            return true;
        }
        return false;
    }

    private static boolean phdProcessHasRepeatedPDI(PhdIndividualProgramProcess phdProcess, ExecutionYear executionYear) {
        PrecedentDegreeInformation existingPdi = null;
        for (PrecedentDegreeInformation pdi : phdProcess.getPrecedentDegreeInformationsSet()) {
            if (!pdi.getExecutionYear().equals(executionYear)) continue;
            if (existingPdi == null) {
                existingPdi = pdi;
                continue;
            }
            return true;
        }
        return false;
    }

    @ConsistencyPredicate
    public boolean checkHasAllRegistrationOrPhdInformation() {
        return this.hasAllRegistrationInformation() && !this.hasAllPhdInformation() || !this.hasAllRegistrationInformation() && this.hasAllPhdInformation() || this.hasNoPersonalInformation() && this.hasAtLeastOneCandidacy();
    }

    private boolean hasAllRegistrationInformation() {
        return this.getPersonalIngressionData() != null && this.getRegistration() != null;
    }

    private boolean hasAllPhdInformation() {
        return this.getPersonalIngressionData() != null && this.getPhdIndividualProgramProcess() != null;
    }

    private boolean hasNoPersonalInformation() {
        return this.getPersonalIngressionData() == null && this.getRegistration() == null && this.getPhdIndividualProgramProcess() == null;
    }

    private boolean hasAtLeastOneCandidacy() {
        return this.getStudentCandidacy() != null || this.getIndividualCandidacy() != null;
    }

    public boolean isCandidacyInternal() {
        return this.getCandidacyInternal() != null && this.getCandidacyInternal() != false;
    }

    public boolean isCandidacyExternal() {
        return !this.isCandidacyInternal();
    }

    public Unit getPrecedentInstitution() {
        if (this.isCandidacyInternal()) {
            return Bennu.getInstance().getInstitutionUnit();
        }
        return super.getPrecedentInstitution();
    }
}

