/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import java.util.Comparator;
import jvstm.cps.ConsistencyPredicate;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.GrantOwnerType;
import org.fenixedu.academic.domain.candidacy.PersonalInformationBean;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.PersonalIngressionData_Base;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.candidacy.OriginInformationBean;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;

public class PersonalIngressionData
extends PersonalIngressionData_Base {
    public static Comparator<PersonalIngressionData> COMPARATOR_BY_EXECUTION_YEAR = new Comparator<PersonalIngressionData>(){

        @Override
        public int compare(PersonalIngressionData data1, PersonalIngressionData data2) {
            return data1.getExecutionYear().getYear().compareTo(data2.getExecutionYear().getYear());
        }
    };

    public PersonalIngressionData() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setLastModifiedDate(new DateTime());
    }

    public PersonalIngressionData(ExecutionYear executionYear, PrecedentDegreeInformation precedentDegreeInformation) {
        this();
        this.setExecutionYear(executionYear);
        this.addPrecedentDegreesInformations(precedentDegreeInformation);
    }

    public PersonalIngressionData(Student student, ExecutionYear executionYear, PrecedentDegreeInformation precedentDegreeInformation) {
        this(executionYear, precedentDegreeInformation);
        this.setStudent(student);
    }

    public PersonalIngressionData(OriginInformationBean originInformationBean, PersonBean personBean, Student student, ExecutionYear executionYear) {
        this();
        this.setStudent(student);
        this.setExecutionYear(executionYear);
        this.setDistrictSubdivisionOfResidence(personBean.getDistrictSubdivisionOfResidenceObject());
        this.setCountryOfResidence(personBean.getCountryOfResidence());
        this.setSchoolTimeDistrictSubDivisionOfResidence(originInformationBean.getSchoolTimeDistrictSubdivisionOfResidence());
        this.setDislocatedFromPermanentResidence(originInformationBean.getDislocatedFromPermanentResidence());
        this.setGrantOwnerType(originInformationBean.getGrantOwnerType());
        if (this.getGrantOwnerType() != null && this.getGrantOwnerType() == GrantOwnerType.OTHER_INSTITUTION_GRANT_OWNER && originInformationBean.getGrantOwnerProvider() == null) {
            throw new DomainException("error.CandidacyInformationBean.grantOwnerProviderInstitutionUnitName.is.required.for.other.institution.grant.ownership", new String[0]);
        }
        this.setGrantOwnerProvider(originInformationBean.getGrantOwnerProvider());
        this.setHighSchoolType(originInformationBean.getHighSchoolType());
        this.setMaritalStatus(personBean.getMaritalStatus());
        this.setProfessionType(personBean.getProfessionType());
        this.setProfessionalCondition(personBean.getProfessionalCondition());
        this.setMotherSchoolLevel(originInformationBean.getMotherSchoolLevel());
        this.setMotherProfessionType(originInformationBean.getMotherProfessionType());
        this.setMotherProfessionalCondition(originInformationBean.getMotherProfessionalCondition());
        this.setFatherSchoolLevel(originInformationBean.getFatherSchoolLevel());
        this.setFatherProfessionType(originInformationBean.getFatherProfessionType());
        this.setFatherProfessionalCondition(originInformationBean.getFatherProfessionalCondition());
    }

    public void edit(OriginInformationBean originInformationBean, PersonBean personBean) {
        this.setDistrictSubdivisionOfResidence(personBean.getDistrictSubdivisionOfResidenceObject());
        this.setCountryOfResidence(personBean.getCountryOfResidence());
        this.setSchoolTimeDistrictSubDivisionOfResidence(originInformationBean.getSchoolTimeDistrictSubdivisionOfResidence());
        this.setDislocatedFromPermanentResidence(originInformationBean.getDislocatedFromPermanentResidence());
        this.setGrantOwnerType(originInformationBean.getGrantOwnerType());
        if (this.getGrantOwnerType() != null && this.getGrantOwnerType() == GrantOwnerType.OTHER_INSTITUTION_GRANT_OWNER && originInformationBean.getGrantOwnerProvider() == null) {
            throw new DomainException("error.CandidacyInformationBean.grantOwnerProviderInstitutionUnitName.is.required.for.other.institution.grant.ownership", new String[0]);
        }
        this.setGrantOwnerProvider(originInformationBean.getGrantOwnerProvider());
        this.setHighSchoolType(originInformationBean.getHighSchoolType());
        this.setMaritalStatus(personBean.getMaritalStatus());
        this.setProfessionType(personBean.getProfessionType());
        this.setProfessionalCondition(personBean.getProfessionalCondition());
        this.setMotherSchoolLevel(originInformationBean.getMotherSchoolLevel());
        this.setMotherProfessionType(originInformationBean.getMotherProfessionType());
        this.setMotherProfessionalCondition(originInformationBean.getMotherProfessionalCondition());
        this.setFatherSchoolLevel(originInformationBean.getFatherSchoolLevel());
        this.setFatherProfessionType(originInformationBean.getFatherProfessionType());
        this.setFatherProfessionalCondition(originInformationBean.getFatherProfessionalCondition());
        this.setLastModifiedDate(new DateTime());
    }

    public void edit(PersonalInformationBean bean) {
        this.setCountryOfResidence(bean.getCountryOfResidence());
        this.setDistrictSubdivisionOfResidence(bean.getDistrictSubdivisionOfResidence());
        this.setDislocatedFromPermanentResidence(bean.getDislocatedFromPermanentResidence());
        this.setSchoolTimeDistrictSubDivisionOfResidence(bean.getSchoolTimeDistrictSubdivisionOfResidence());
        this.setGrantOwnerType(bean.getGrantOwnerType());
        this.setGrantOwnerProvider(bean.getGrantOwnerProvider());
        this.setHighSchoolType(bean.getHighSchoolType());
        this.setMaritalStatus(bean.getMaritalStatus());
        this.setProfessionType(bean.getProfessionType());
        this.setProfessionalCondition(bean.getProfessionalCondition());
        this.setMotherSchoolLevel(bean.getMotherSchoolLevel());
        this.setMotherProfessionType(bean.getMotherProfessionType());
        this.setMotherProfessionalCondition(bean.getMotherProfessionalCondition());
        this.setFatherSchoolLevel(bean.getFatherSchoolLevel());
        this.setFatherProfessionType(bean.getFatherProfessionType());
        this.setFatherProfessionalCondition(bean.getFatherProfessionalCondition());
        this.setLastModifiedDate(new DateTime());
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        super.setExecutionYear(executionYear);
        if (executionYear != null && this.getStudent() != null && PersonalIngressionData.studentHasRepeatedPID(this.getStudent(), executionYear)) {
            throw new DomainException("A Student cannot have two PersonalIngressionData objects for the same ExecutionYear.", new String[0]);
        }
    }

    public void setStudent(Student student) {
        super.setStudent(student);
        if (student != null && this.getExecutionYear() != null && PersonalIngressionData.studentHasRepeatedPID(student, this.getExecutionYear())) {
            throw new DomainException("A Student cannot have two PersonalIngressionData objects for the same ExecutionYear.", new String[0]);
        }
    }

    private static boolean studentHasRepeatedPID(Student student, ExecutionYear executionYear) {
        PersonalIngressionData existingPid = null;
        for (PersonalIngressionData pid : student.getPersonalIngressionsDataSet()) {
            if (!pid.getExecutionYear().equals(executionYear)) continue;
            if (existingPid == null) {
                existingPid = pid;
                continue;
            }
            return true;
        }
        return false;
    }

    public void delete() {
        this.setStudent(null);
        this.setExecutionYear(null);
        this.getPrecedentDegreesInformationsSet().clear();
        this.setRootDomainObject(null);
        this.setCountryOfResidence(null);
        this.setGrantOwnerProvider(null);
        this.setDistrictSubdivisionOfResidence(null);
        this.setSchoolTimeDistrictSubDivisionOfResidence(null);
        this.deleteDomainObject();
    }

    @ConsistencyPredicate
    public boolean checkHasExecutionYear() {
        return this.getExecutionYear() != null;
    }

    @ConsistencyPredicate
    public boolean checkHasStudent() {
        return this.getStudent() != null;
    }

    @ConsistencyPredicate
    public boolean checkMultiplicityOfPrecedentDegreesInformations() {
        return this.getPrecedentDegreesInformationsSet().size() > 0;
    }
}

