/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ExtraCurricularCertificateRequest_Base;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;

public class ExtraCurricularCertificateRequest
extends ExtraCurricularCertificateRequest_Base {
    public ExtraCurricularCertificateRequest() {
    }

    public ExtraCurricularCertificateRequest(DocumentRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkParameters(bean);
        super.getEnrolmentsSet().addAll(bean.getEnrolments());
    }

    protected void checkParameters(DocumentRequestCreateBean bean) {
        if (bean.getEnrolments() == null || bean.getEnrolments().isEmpty()) {
            throw new DomainException("error.ExtraCurricularCertificateRequest.no.enrolments", new String[0]);
        }
    }

    public Integer getNumberOfUnits() {
        return super.getEnrolmentsSet().size();
    }

    public DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.EXTRA_CURRICULAR_CERTIFICATE;
    }

    public String getDocumentTemplateKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public EventType getEventType() {
        return this.getRegistration().getRegistrationProtocol().isExempted() ? null : EventType.EXTRA_CURRICULAR_APPROVEMENT_CERTIFICATE_REQUEST;
    }

    public boolean isAvailableForTransitedRegistrations() {
        return true;
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToCancelOrReject()) {
            while (!this.getEnrolmentsSet().isEmpty()) {
                this.removeEnrolments((Enrolment)this.getEnrolmentsSet().iterator().next());
            }
        }
    }
}

