/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import com.google.common.base.Joiner;
import java.util.Locale;
import java.util.function.Supplier;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeOfficialPublication;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.EctsGraduationGradeConversionTable;
import org.fenixedu.academic.domain.degreeStructure.EctsTableIndex;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.IDiplomaSupplementRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DiplomaSupplementRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.RegistryDiplomaRequest;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcess;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcess_Base;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;
import org.fenixedu.academic.dto.serviceRequests.RegistrationAcademicServiceRequestCreateBean;
import org.fenixedu.academic.report.academicAdministrativeOffice.DiplomaSupplement;
import org.fenixedu.academic.util.MultiLanguageString;
import org.joda.time.DateTime;

public class DiplomaSupplementRequest
extends DiplomaSupplementRequest_Base
implements IDiplomaSupplementRequest {
    public DiplomaSupplementRequest() {
    }

    public DiplomaSupplementRequest(DocumentRequestCreateBean bean) {
        this();
        super.init((RegistrationAcademicServiceRequestCreateBean)bean);
        this.checkParameters(bean);
        this.setLanguage(MultiLanguageString.pt);
        this.setProgramConclusion(bean.getProgramConclusion());
    }

    protected void checkParameters(DocumentRequestCreateBean bean) {
        String composedName;
        if (bean.getProgramConclusion() == null) {
            throw new DomainException("error.program.conclusion.empty", new String[0]);
        }
        String fullName = this.getRegistration().getStudent().getPerson().getName();
        String familyName = bean.getFamilyNames();
        String string = composedName = familyName == null || familyName.isEmpty() ? bean.getGivenNames() : bean.getGivenNames() + " " + familyName;
        if (!fullName.equals(composedName)) {
            throw new DomainException("error.diplomaSupplementRequest.splittedNamesDoNotMatch", new String[0]);
        }
        this.getRegistration().getPerson().getProfile().changeName(bean.getGivenNames(), bean.getFamilyNames(), null);
        RegistryDiplomaRequest registry = this.getRegistration().getRegistryDiplomaRequest(bean.getProgramConclusion());
        DiplomaRequest diploma = this.getRegistration().getDiplomaRequest(bean.getProgramConclusion());
        if (registry == null && diploma == null) {
            throw new DomainException("error.diplomaSupplementRequest.cannotAskForSupplementWithoutEitherRegistryDiplomaOrDiplomaRequest", new String[0]);
        }
        DiplomaSupplementRequest supplement = this.getRegistration().getDiplomaSupplementRequest(bean.getProgramConclusion());
        if (supplement != null) {
            throw new DomainException("error.diplomaSupplementRequest.alreadyRequested", new String[0]);
        }
    }

    @Override
    public DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.DIPLOMA_SUPPLEMENT_REQUEST;
    }

    @Override
    public final String getDescription() {
        return Joiner.on((String)" : ").join((Object)super.getDescription(this.getAcademicServiceRequestType()), (Object)this.getProgramConclusion().getName().getContent(), new Object[0]);
    }

    @Override
    public String getDocumentTemplateKey() {
        return DiplomaSupplement.class.getName();
    }

    public String getGivenNames() {
        return this.getRegistration().getPerson().getGivenNames();
    }

    public String getFamilyNames() {
        return this.getRegistration().getPerson().getFamilyNames();
    }

    public boolean isPagedDocument() {
        return true;
    }

    public boolean isAvailableForTransitedRegistrations() {
        return false;
    }

    @Override
    public EventType getEventType() {
        return null;
    }

    public boolean hasPersonalInfo() {
        return false;
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return false;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return false;
    }

    public boolean isToPrint() {
        return true;
    }

    public boolean isPiggyBackedOnRegistry() {
        return this.getRegistryDiplomaRequest() != null;
    }

    public AcademicServiceRequestType getAcademicServiceRequestType() {
        return AcademicServiceRequestType.DIPLOMA_SUPPLEMENT_REQUEST;
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToProcess()) {
            if (!this.getProgramConclusion().isConclusionProcessed(this.getRegistration())) {
                throw new DomainException("error.diplomaSupplement.registration.not.submited.to.conclusion.process", new String[0]);
            }
            if (this.getRegistryCode() == null) {
                RegistryDiplomaRequest registryRequest = this.getRegistration().getRegistryDiplomaRequest(this.getProgramConclusion());
                DiplomaRequest diploma = this.getRegistration().getDiplomaRequest(this.getProgramConclusion());
                if (registryRequest != null) {
                    registryRequest.getRegistryCode().addDocumentRequest((AcademicServiceRequest)((Object)this));
                } else if (diploma != null && diploma.hasRegistryCode()) {
                    diploma.getRegistryCode().addDocumentRequest((AcademicServiceRequest)((Object)this));
                } else {
                    this.getRootDomainObject().getInstitutionUnit().getRegistryCodeGenerator().createRegistryFor((AcademicServiceRequest)((Object)this));
                }
            }
            if (this.getLastGeneratedDocument() == null) {
                this.generateDocument();
            }
        }
    }

    @Override
    public String getGraduateTitle(Locale locale) {
        return this.getProgramConclusion().groupFor(this.getRegistration()).map(cg -> cg.getDegreeModule().getGraduateTitle(this.getConclusionYear(), locale)).orElse(null);
    }

    @Override
    public Integer getRegistrationNumber() {
        return this.getRegistration().getNumber();
    }

    @Override
    public String getPrevailingScientificArea(Locale locale) {
        Degree degree = this.getDegree();
        ExecutionYear conclusion = this.getConclusionYear();
        return degree.getFilteredName(conclusion, locale);
    }

    @Override
    public double getEctsCredits() {
        ExecutionYear conclusion = this.getConclusionYear();
        Supplier<DomainException> noDefaultCredits = () -> new DomainException("error.CycleCourseGroup.cannot.calculate.default.ects.credits", new String[0]);
        return this.getProgramConclusion().groupFor(this.getRegistration()).map(cg -> cg.getDegreeModule().getDefaultEcts(conclusion)).orElseThrow(noDefaultCredits);
    }

    @Override
    public DegreeOfficialPublication getDegreeOfficialPublication() {
        ConclusionProcess conclusionProcess = this.getProgramConclusion().groupFor(this.getRegistration()).map(cg -> cg.getConclusionProcess()).orElse(null);
        DegreeOfficialPublication dr = this.getRegistration().getDegree().getOfficialPublication(conclusionProcess.getConclusionDate().toDateTimeAtStartOfDay());
        return dr;
    }

    @Override
    public Integer getFinalAverage() {
        return this.getRegistration().getFinalGrade(this.getProgramConclusion()).getIntegerValue();
    }

    @Override
    public String getFinalAverageQualified(Locale locale) {
        Integer finalGrade = this.getFinalAverage();
        String qualifiedAverageGrade = finalGrade <= 13 ? "sufficient" : (finalGrade <= 15 ? "good" : (finalGrade <= 17 ? "verygood" : "excelent"));
        return "diploma.supplement.qualifiedgrade." + qualifiedAverageGrade;
    }

    @Override
    public ExecutionYear getConclusionYear() {
        return this.getProgramConclusion().groupFor(this.getRegistration()).map(CurriculumGroup::getConclusionProcess).map(ConclusionProcess_Base::getConclusionYear).orElse(null);
    }

    @Override
    public CycleType getRequestedCycle() {
        return this.getProgramConclusion().groupFor(this.getRegistration()).filter(CurriculumModule::isCycleCurriculumGroup).map(cg -> ((CycleCurriculumGroup)((Object)((Object)cg))).getCycleType()).orElse(null);
    }

    @Override
    public EctsGraduationGradeConversionTable getGraduationConversionTable() {
        return EctsTableIndex.getGraduationGradeConversionTable(this.getRegistration().getDegree(), this.getRequestedCycle(), this.getConclusionYear().getAcademicInterval(), this.getProcessingDate() != null ? this.getProcessingDate() : new DateTime());
    }

    @Override
    public Integer getNumberOfCurricularYears() {
        return this.getRegistration().getLastStudentCurricularPlan().getDegreeCurricularPlan().getDurationInYears(this.getRequestedCycle());
    }

    @Override
    public Integer getNumberOfCurricularSemesters() {
        return this.getRegistration().getLastStudentCurricularPlan().getDegreeCurricularPlan().getDurationInSemesters(this.getRequestedCycle());
    }

    @Override
    public Boolean isExemptedFromStudy() {
        return false;
    }
}

