/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reports;

import java.util.Set;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationConfiguration;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curriculum.EnrollmentState;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.reports.EtiReportFile_Base;
import org.fenixedu.academic.domain.reports.GepReportFile;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.commons.spreadsheet.Spreadsheet;

public class EtiReportFile
extends EtiReportFile_Base {
    public String getJobName() {
        return "Listagem para ETI";
    }

    protected String getPrefix() {
        return "etiGrades";
    }

    public void renderReport(Spreadsheet spreadsheet) throws Exception {
        Set seasons = EvaluationConfiguration.getInstance().getEvaluationSeasonSet();
        spreadsheet.setHeader("n\u00famero aluno");
        this.setDegreeHeaders(spreadsheet, "aluno");
        spreadsheet.setHeader("semestre");
        spreadsheet.setHeader("ano lectivo");
        spreadsheet.setHeader("nome Disciplina");
        this.setDegreeHeaders(spreadsheet, "disciplina");
        spreadsheet.setHeader("creditos");
        spreadsheet.setHeader("estado");
        spreadsheet.setHeader("\u00e9poca");
        spreadsheet.setHeader("nota");
        for (EvaluationSeason season : seasons) {
            spreadsheet.setHeader(season.getName().getContent());
        }
        spreadsheet.setHeader("tipo Aluno");
        spreadsheet.setHeader("n\u00famero inscricoes anteriores");
        spreadsheet.setHeader("c\u00f3digo disciplina execu\u00e7\u00e3o");
        for (Degree degree : Degree.readNotEmptyDegrees()) {
            if (!EtiReportFile.checkDegreeType((DegreeType)this.getDegreeType(), (Degree)degree)) continue;
            for (DegreeCurricularPlan degreeCurricularPlan : degree.getDegreeCurricularPlansSet()) {
                if (!EtiReportFile.checkExecutionYear((ExecutionYear)this.getExecutionYear(), (DegreeCurricularPlan)degreeCurricularPlan)) continue;
                for (CurricularCourse curricularCourse : degreeCurricularPlan.getAllCurricularCourses()) {
                    if (!EtiReportFile.checkExecutionYear((ExecutionYear)this.getExecutionYear(), (CurricularCourse)curricularCourse)) continue;
                    for (CurriculumModule curriculumModule : curricularCourse.getCurriculumModulesSet()) {
                        Enrolment enrolment;
                        if (!curriculumModule.isEnrolment() || (enrolment = (Enrolment)((Object)curriculumModule)).getExecutionYear() != this.getExecutionYear()) continue;
                        ExecutionSemester executionSemester = enrolment.getExecutionPeriod();
                        if (curricularCourse.isAnual()) {
                            this.addEtiRow(spreadsheet, curricularCourse.getDegree(), curricularCourse, enrolment, executionSemester, executionSemester, seasons);
                            if (executionSemester.getSemester() != 1) continue;
                            ExecutionSemester nextSemester = executionSemester.getNextExecutionPeriod();
                            this.addEtiRow(spreadsheet, curricularCourse.getDegree(), curricularCourse, enrolment, nextSemester, executionSemester, seasons);
                            continue;
                        }
                        this.addEtiRow(spreadsheet, curricularCourse.getDegree(), curricularCourse, enrolment, executionSemester, executionSemester, seasons);
                    }
                }
            }
        }
    }

    private void addEtiRow(Spreadsheet spreadsheet, Degree degree, CurricularCourse curricularCourse, Enrolment enrolment, ExecutionSemester executionSemester, ExecutionSemester executionSemesterForPreviousEnrolmentCount, Set<EvaluationSeason> seasons) {
        StudentCurricularPlan studentCurricularPlan = enrolment.getStudentCurricularPlan();
        Registration registration = studentCurricularPlan.getRegistration();
        Student student = registration.getStudent();
        Spreadsheet.Row row = spreadsheet.addRow();
        row.setCell(registration.getNumber());
        this.setDegreeCells(row, registration.getDegree());
        row.setCell(executionSemester.getSemester().toString());
        row.setCell(executionSemester.getExecutionYear().getYear());
        row.setCell(curricularCourse.getName());
        this.setDegreeCells(row, degree);
        row.setCell(enrolment.getEctsCredits().toString().replace('.', ','));
        row.setCell(enrolment.isApproved() ? EnrollmentState.APROVED.getDescription() : enrolment.getEnrollmentState().getDescription());
        row.setCell(enrolment.getEvaluationSeason().getName().getContent());
        row.setCell(enrolment.getGradeValue());
        for (EvaluationSeason evaluationSeason : seasons) {
            row.setCell((String)enrolment.getFinalEnrolmentEvaluationBySeason(evaluationSeason).map(EnrolmentEvaluation::getGradeValue).orElse(null));
        }
        row.setCell(registration.getRegistrationProtocol().getCode());
        row.setCell(this.countPreviousEnrolments(curricularCourse, executionSemesterForPreviousEnrolmentCount, student));
        Attends attends = null;
        for (Attends a : enrolment.getAttendsSet()) {
            if (!a.isFor(executionSemester) || attends != null) continue;
            attends = a;
        }
        if (attends == null) {
            row.setCell("");
        } else {
            ExecutionCourse executionCourse = attends.getExecutionCourse();
            row.setCell(GepReportFile.getExecutionCourseCode(executionCourse));
        }
    }

    private String countPreviousEnrolments(CurricularCourse curricularCourse, ExecutionSemester executionPeriod, Student student) {
        int count = 0;
        for (CurriculumModule curriculumModule : curricularCourse.getCurriculumModulesSet()) {
            Enrolment enrolment;
            if (!curriculumModule.isEnrolment() || executionPeriod.compareTo((enrolment = (Enrolment)((Object)curriculumModule)).getExecutionPeriod()) <= 0 || enrolment.getStudentCurricularPlan().getRegistration().getStudent() != student) continue;
            ++count;
        }
        return Integer.toString(count);
    }
}

