/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reports;

import java.util.Iterator;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeInfo;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.reports.EctsLabelDegreeReportFile_Base;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.commons.spreadsheet.Spreadsheet;

public class EctsLabelDegreeReportFile
extends EctsLabelDegreeReportFile_Base {
    public String getJobName() {
        return "Listagem para ECTS LABEL Cursos";
    }

    protected String getPrefix() {
        return "ectsLabel_Cursos";
    }

    public void renderReport(Spreadsheet spreadsheet) throws Exception {
        this.createEctsLabelDegreesHeader(spreadsheet);
        for (Degree degree : Degree.readNotEmptyDegrees()) {
            if (!EctsLabelDegreeReportFile.checkDegreeType((DegreeType)this.getDegreeType(), (Degree)degree)) continue;
            for (DegreeCurricularPlan degreeCurricularPlan : degree.getDegreeCurricularPlansSet()) {
                if (!EctsLabelDegreeReportFile.checkExecutionYear((ExecutionYear)this.getExecutionYear(), (DegreeCurricularPlan)degreeCurricularPlan)) continue;
                this.addEctsLabelDegreeRow(spreadsheet, degreeCurricularPlan, this.getExecutionYear());
            }
        }
    }

    private void createEctsLabelDegreesHeader(Spreadsheet spreadsheet) {
        spreadsheet.setHeaders(new String[]{"Nome", "Nome Ingl\u00eas", "Tipo Curso", "Dura\u00e7\u00e3o em anos", "Dura\u00e7\u00e3o em Semanas de Estudo", "Cr\u00e9ditos ECTS", "Requisitos de Ingresso", "Requisitos de Ingresso (ingl\u00eas)", "Objectivos Educacionais", "Objectivos Educacionais (ingl\u00eas)", "Acesso a um n\u00edvel superior de estudos", "Acesso a um n\u00edvel superior de estudos (ingl\u00eas)", "Normas e Regulamentos", "Normas e Regulamentos (ingl\u00eas)", "Coordenador", "Contactos", "Contactos (ingl\u00eas)"});
    }

    private String getResponsibleCoordinatorNames(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        StringBuilder builder = new StringBuilder();
        ExecutionDegree executionDegree = degreeCurricularPlan.getExecutionDegreeByYear(executionYear);
        Iterator<Coordinator> coordinators = executionDegree.getResponsibleCoordinators().iterator();
        while (coordinators.hasNext()) {
            builder.append(coordinators.next().getPerson().getName()).append(coordinators.hasNext() ? ", " : "");
        }
        return builder.toString();
    }

    private void addEctsLabelDegreeRow(Spreadsheet spreadsheet, DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        Spreadsheet.Row row = spreadsheet.addRow();
        Degree degree = degreeCurricularPlan.getDegree();
        row.setCell(this.normalize(degree.getNameFor(executionYear).getContent(MultiLanguageString.pt)));
        row.setCell(this.normalize(degree.getNameFor(executionYear).getContent(MultiLanguageString.en)));
        row.setCell(degree.getDegreeType().getName().getContent());
        row.setCell(Integer.valueOf(degreeCurricularPlan.getDurationInYears()));
        row.setCell(Integer.valueOf(degreeCurricularPlan.getDurationInYears() * 40));
        row.setCell(degree.getEctsCredits());
        DegreeInfo degreeInfo = degree.getMostRecentDegreeInfo(executionYear);
        if (degreeInfo != null) {
            row.setCell(this.normalize(degreeInfo.getDesignedFor(MultiLanguageString.pt)));
            row.setCell(this.normalize(degreeInfo.getDesignedFor(MultiLanguageString.en)));
            row.setCell(this.normalize(degreeInfo.getObjectives(MultiLanguageString.pt)));
            row.setCell(this.normalize(degreeInfo.getObjectives(MultiLanguageString.en)));
            row.setCell(this.normalize(degreeInfo.getProfessionalExits(MultiLanguageString.pt)));
            row.setCell(this.normalize(degreeInfo.getProfessionalExits(MultiLanguageString.en)));
            row.setCell(this.normalize(degreeInfo.getOperationalRegime(MultiLanguageString.pt)));
            row.setCell(this.normalize(degreeInfo.getOperationalRegime(MultiLanguageString.en)));
            row.setCell(this.normalize(this.getResponsibleCoordinatorNames(degreeCurricularPlan, executionYear)));
            row.setCell(this.normalize(degreeInfo.getAdditionalInfo(MultiLanguageString.pt)));
            row.setCell(this.normalize(degreeInfo.getAdditionalInfo(MultiLanguageString.en)));
        }
    }
}

