/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.PhdThesisReportFeedbackDocument;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisJuryElementBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.ThesisJuryElement$callable$delete;
import org.fenixedu.academic.domain.phd.thesis.ThesisJuryElement_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ThesisJuryElement
extends ThesisJuryElement_Base {
    public static final Comparator<ThesisJuryElement> COMPARATOR_BY_ELEMENT_ORDER;
    public static final Advice advice$delete;

    public static ThesisJuryElement createPresident(PhdThesisProcess process2, PhdThesisJuryElementBean bean) {
        if (process2.getPresidentJuryElement() != null) {
            throw new DomainException("error.ThesisJuryElement.president.already.exists", new String[0]);
        }
        PhdParticipant participant = PhdParticipant.getUpdatedOrCreate(process2.getIndividualProgramProcess(), bean);
        ThesisJuryElement element = new ThesisJuryElement();
        element.checkParticipant(process2, participant, true);
        element.setElementOrder(0);
        element.setProcessForPresidentJuryElement(process2);
        element.setParticipant(participant);
        element.setReporter(false);
        element.setExpert(false);
        return element;
    }

    protected ThesisJuryElement() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setCreationDate(new DateTime());
    }

    protected ThesisJuryElement init(PhdThesisProcess process2, PhdParticipant participant, PhdThesisJuryElementBean bean) {
        String[] args = new String[]{};
        if (process2 == null) {
            throw new DomainException("error.ThesisJuryElement.invalid.process", args);
        }
        this.checkParticipant(process2, participant, false);
        this.setElementOrder(this.generateNextElementOrder(process2));
        this.setProcess(process2);
        this.setParticipant(participant);
        this.setReporter(bean.isReporter());
        this.setExpert(bean.isExpert());
        return this;
    }

    private void checkParticipant(PhdThesisProcess process2, PhdParticipant participant, boolean isPresident) {
        String[] args = new String[]{};
        if (participant == null) {
            throw new DomainException("error.ThesisJuryElement.participant.cannot.be.null", args);
        }
        for (ThesisJuryElement element : participant.getThesisJuryElementsSet()) {
            if (element.getProcess() == null || !element.getProcess().equals((Object)process2) || isPresident || element.isPresident()) continue;
            throw new DomainException("error.ThesisJuryElement.participant.already.has.jury.element.in.process", new String[0]);
        }
    }

    private Integer generateNextElementOrder(PhdThesisProcess process2) {
        if (process2.getThesisJuryElementsSet().isEmpty()) {
            return 1;
        }
        return Collections.max(process2.getThesisJuryElementsSet(), COMPARATOR_BY_ELEMENT_ORDER).getElementOrder() + 1;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new ThesisJuryElement$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(ThesisJuryElement this_) {
        this_.checkIfCanBeDeleted();
        this_.disconnect();
        this_.deleteDomainObject();
    }

    private void checkIfCanBeDeleted() {
        if (!this.getFeedbackDocumentsSet().isEmpty()) {
            throw new DomainException("error.ThesisJuryElement.has.feedback.documents", new String[0]);
        }
    }

    protected void disconnect() {
        PhdParticipant participant = this.getParticipant();
        this.setParticipant(null);
        participant.tryDelete();
        this.setProcess(null);
        this.setProcessForPresidentJuryElement(null);
        this.setRootDomainObject(null);
    }

    public boolean isInternal() {
        return this.getParticipant().isInternal();
    }

    public String getName() {
        return this.getParticipant().getName();
    }

    public String getNameWithTitle() {
        return this.getParticipant().getNameWithTitle();
    }

    public String getNameWithTitleAndRoleOnProcess() {
        StringBuilder stringBuilder = new StringBuilder(this.getNameWithTitle());
        if (this.getProcess().getIndividualProgramProcess().isGuider(this.getParticipant())) {
            stringBuilder.append(" (").append(BundleUtil.getString((String)"resources.PhdResources", (String)"label.phd.guiding", (String[])new String[0])).append(")");
        }
        if (this.getProcess().getIndividualProgramProcess().isAssistantGuider(this.getParticipant())) {
            stringBuilder.append(" (").append(BundleUtil.getString((String)"resources.PhdResources", (String)"label.phd.assistant.guiding", (String[])new String[0])).append(")");
        }
        return stringBuilder.toString();
    }

    public String getQualification() {
        return this.getParticipant().getQualification();
    }

    public String getCategory() {
        return this.getParticipant().getCategory();
    }

    public String getWorkLocation() {
        return this.getParticipant().getWorkLocation();
    }

    public String getInstitution() {
        return this.getParticipant().getInstitution();
    }

    public String getAddress() {
        return this.getParticipant().getAddress();
    }

    public String getPhone() {
        return this.getParticipant().getPhone();
    }

    public String getEmail() {
        return this.getParticipant().getEmail();
    }

    public String getTitle() {
        return this.getParticipant().getTitle();
    }

    public boolean isTopElement() {
        return this.getElementOrder() == 1;
    }

    public boolean isBottomElement() {
        return this.getElementOrder().intValue() == this.getProcess().getThesisJuryElementsSet().size();
    }

    public static ThesisJuryElement create(PhdThesisProcess process2, PhdThesisJuryElementBean bean) {
        return new ThesisJuryElement().init(process2, PhdParticipant.getUpdatedOrCreate(process2.getIndividualProgramProcess(), bean), bean);
    }

    public boolean isGuidingOrAssistantGuiding() {
        return this.getParticipant().isGuidingOrAssistantGuiding();
    }

    public boolean isMainGuiding() {
        return this.getParticipant().getProcessForGuiding() != null;
    }

    public boolean isAssistantGuiding() {
        return this.getParticipant().getProcessForAssistantGuiding() != null;
    }

    public boolean isFor(PhdThesisProcess process2) {
        return this.getProcess().equals((Object)process2);
    }

    public PhdThesisReportFeedbackDocument getLastFeedbackDocument() {
        return !this.getFeedbackDocumentsSet().isEmpty() ? (PhdThesisReportFeedbackDocument)((Object)Collections.max(this.getFeedbackDocumentsSet(), PhdProgramProcessDocument.COMPARATOR_BY_UPLOAD_TIME)) : null;
    }

    public boolean isFor(Person person) {
        return this.getParticipant().isFor(person);
    }

    public boolean isDocumentValidated() {
        PhdThesisReportFeedbackDocument document = this.getLastFeedbackDocument();
        return document != null && document.isAssignedToProcess();
    }

    public void edit(PhdThesisJuryElementBean bean) {
        this.getParticipant().edit(bean);
        this.setReporter(bean.isReporter());
        this.setExpert(bean.isExpert());
    }

    public boolean isJuryValidated() {
        return this.getProcess().isJuryValidated();
    }

    public boolean isPresident() {
        return this.getProcessForPresidentJuryElement() != null;
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_ELEMENT_ORDER = new Comparator<ThesisJuryElement>(){

            @Override
            public int compare(ThesisJuryElement o1, ThesisJuryElement o2) {
                return o1.getElementOrder().compareTo(o2.getElementOrder());
            }
        };
    }
}

