/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdParticipantBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.ThesisJuryElement;

public class PhdThesisJuryElementBean
extends PhdParticipantBean {
    private static final long serialVersionUID = -5365333247731361583L;
    private PhdThesisProcess thesisProcess;
    private boolean reporter;
    private boolean expert;
    private ThesisJuryElement juryElement;

    public PhdThesisJuryElementBean(PhdThesisProcess process2) {
        super(process2.getIndividualProgramProcess());
        this.setThesisProcess(process2);
    }

    public PhdThesisJuryElementBean(PhdThesisProcess process2, ThesisJuryElement element) {
        this(process2);
        this.setParticipant(element.getParticipant());
        this.setParticipantType(element.getParticipant().isInternal() ? PhdParticipantBean.PhdParticipantType.INTERNAL : PhdParticipantBean.PhdParticipantType.EXTERNAL);
        this.setJuryElement(element);
        this.setName(element.getName());
        this.setTitle(element.getTitle());
        this.setCategory(element.getCategory());
        this.setWorkLocation(element.getWorkLocation());
        this.setInstitution(element.getInstitution());
        if (!element.getParticipant().isInternal()) {
            this.setQualification(element.getQualification());
            this.setAddress(element.getAddress());
            this.setEmail(element.getEmail());
            this.setPhone(element.getPhone());
        }
        this.setReporter(element.getReporter());
        this.setExpert(element.getExpert());
    }

    public PhdThesisProcess getThesisProcess() {
        return this.thesisProcess;
    }

    public void setThesisProcess(PhdThesisProcess thesisProcess) {
        this.thesisProcess = thesisProcess;
    }

    public boolean isReporter() {
        return this.reporter;
    }

    public void setReporter(boolean reporter) {
        this.reporter = reporter;
    }

    public ThesisJuryElement getJuryElement() {
        return this.juryElement;
    }

    public void setJuryElement(ThesisJuryElement juryElement) {
        this.juryElement = juryElement;
    }

    public boolean isExpert() {
        return this.expert;
    }

    public void setExpert(boolean expert) {
        this.expert = expert;
    }

    public List<PhdParticipant> getExistingParticipants() {
        ArrayList<PhdParticipant> result = new ArrayList<PhdParticipant>();
        for (PhdParticipant participant : this.getIndividualProgramProcess().getParticipantsSet()) {
            result.add(participant);
        }
        return result;
    }
}

