/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.seminar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.seminar.PublicPresentationSeminarProcessBean;
import org.fenixedu.academic.domain.phd.seminar.PublicPresentationSeminarProcessStateType;
import org.fenixedu.academic.domain.phd.seminar.PublicPresentationSeminarProcess_Base;
import org.fenixedu.academic.domain.phd.seminar.PublicPresentationSeminarState;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.LocalDate;

public class PublicPresentationSeminarProcess
extends PublicPresentationSeminarProcess_Base {
    private static List<Activity> activities = new ArrayList<Activity>();

    public boolean isAllowedToManageProcess(User userView) {
        return this.getIndividualProgramProcess().isAllowedToManageProcess(userView);
    }

    private PublicPresentationSeminarProcess(PhdIndividualProgramProcess individualProcess, PublicPresentationSeminarProcessBean bean) {
        String[] args = new String[]{};
        if (individualProcess == null) {
            throw new DomainException("error.phd.PublicPresentationSeminarProcess.individualProgramProcess.cannot.be.null", args);
        }
        this.setIndividualProgramProcess(individualProcess);
        if (!individualProcess.isMigratedProcess() && bean.getPresentationRequestDate() == null) {
            throw new DomainException("error.seminar.PublicPresentationSeminarProcess.presentation.request.date.required", new String[0]);
        }
        this.setPresentationRequestDate(bean.getPresentationRequestDate());
    }

    public boolean hasReportDocument() {
        return this.getReportDocument() != null;
    }

    public PhdProgramProcessDocument getReportDocument() {
        return this.getLatestDocumentVersionFor(PhdIndividualProgramDocumentType.PUBLIC_PRESENTATION_SEMINAR_REPORT);
    }

    public boolean hasComissionDocument() {
        return this.getComissionDocument() != null;
    }

    public PhdProgramProcessDocument getComissionDocument() {
        return this.getLatestDocumentVersionFor(PhdIndividualProgramDocumentType.PUBLIC_PRESENTATION_SEMINAR_COMISSION);
    }

    public String getDisplayName() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)((Object)((Object)this)).getClass().getSimpleName(), (String[])new String[0]);
    }

    public boolean canExecuteActivity(User userView) {
        return false;
    }

    public List<Activity> getActivities() {
        return activities;
    }

    public PublicPresentationSeminarState getMostRecentState() {
        return (PublicPresentationSeminarState)((Object)super.getMostRecentState());
    }

    public PublicPresentationSeminarProcessStateType getActiveState() {
        return (PublicPresentationSeminarProcessStateType)super.getActiveState();
    }

    public void createState(PublicPresentationSeminarProcessStateType type, Person person, String remarks) {
        PublicPresentationSeminarState.createWithInferredStateDate(this, type, person, remarks);
    }

    protected Person getPerson() {
        return this.getIndividualProgramProcess().getPerson();
    }

    public boolean isExempted() {
        return this.getActiveState() == PublicPresentationSeminarProcessStateType.EXEMPTED;
    }

    public boolean isConcluded() {
        return this.getActiveState() == PublicPresentationSeminarProcessStateType.REPORT_VALIDATED;
    }

    public List<PublicPresentationSeminarProcessStateType> getPossibleNextStates() {
        PublicPresentationSeminarProcessStateType activeState = this.getActiveState();
        if (activeState == null) {
            return Collections.singletonList(PublicPresentationSeminarProcessStateType.WAITING_FOR_COMMISSION_CONSTITUTION);
        }
        switch (activeState) {
            case WAITING_FOR_COMMISSION_CONSTITUTION: {
                ArrayList<PublicPresentationSeminarProcessStateType> result = new ArrayList<PublicPresentationSeminarProcessStateType>();
                result.add(PublicPresentationSeminarProcessStateType.COMMISSION_WAITING_FOR_VALIDATION);
                result.add(PublicPresentationSeminarProcessStateType.EXEMPTED);
                return result;
            }
            case COMMISSION_WAITING_FOR_VALIDATION: {
                return Collections.singletonList(PublicPresentationSeminarProcessStateType.COMMISSION_VALIDATED);
            }
            case COMMISSION_VALIDATED: {
                return Collections.singletonList(PublicPresentationSeminarProcessStateType.PUBLIC_PRESENTATION_DATE_SCHEDULED);
            }
            case PUBLIC_PRESENTATION_DATE_SCHEDULED: {
                return Collections.singletonList(PublicPresentationSeminarProcessStateType.REPORT_WAITING_FOR_VALIDATION);
            }
            case REPORT_WAITING_FOR_VALIDATION: {
                return Collections.singletonList(PublicPresentationSeminarProcessStateType.REPORT_VALIDATED);
            }
            case EXEMPTED: {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    public void removeLastState() {
        if (this.getStates().size() == 1) {
            throw new DomainException("phd.seminar.PublicPresentationSeminarProcess.process.has.only.one.state", new String[0]);
        }
        this.getMostRecentState().delete();
    }

    public LocalDate getPresentationRequestDate() {
        if (super.getPresentationRequestDate() != null) {
            return super.getPresentationRequestDate();
        }
        if (!this.getIndividualProgramProcess().getStudyPlan().isExempted() && this.getIndividualProgramProcess().getRegistration().isConcluded()) {
            return this.getIndividualProgramProcess().getRegistration().getConclusionDate().toLocalDate();
        }
        if (this.getPresentationDate() != null) {
            return this.getPresentationDate().minusMonths(1);
        }
        return this.getIndividualProgramProcess().getWhenStartedStudies();
    }

    public Set<PublicPresentationSeminarState> getStates() {
        return this.getStatesSet();
    }

    public boolean hasAnyStates() {
        return !this.getStatesSet().isEmpty();
    }

    static {
        activities.add(new SubmitComission());
        activities.add(new ValidateComission());
        activities.add(new RejectComission());
        activities.add(new SchedulePresentationDate());
        activities.add(new UploadReport());
        activities.add(new ValidateReport());
        activities.add(new RejectReport());
        activities.add(new DownloadReportDocument());
        activities.add(new DownloadComissionDocument());
        activities.add(new RevertToWaitingForComissionConstitution());
        activities.add(new RevertToWaitingComissionForValidation());
        activities.add(new AddState());
        activities.add(new RemoveLastState());
        activities.add(new EditProcessAttributes());
    }

    public static class EditProcessAttributes
    extends PhdActivity {
        @Override
        protected void processPreConditions(PublicPresentationSeminarProcess process2, User userView) {
        }

        @Override
        protected void activityPreConditions(PublicPresentationSeminarProcess process2, User userView) {
            if (!process2.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected PublicPresentationSeminarProcess executeActivity(PublicPresentationSeminarProcess process2, User userView, Object object) {
            PublicPresentationSeminarProcessBean bean = (PublicPresentationSeminarProcessBean)object;
            process2.setPresentationDate(bean.getPresentationDate());
            process2.setPresentationRequestDate(bean.getPresentationRequestDate());
            return process2;
        }
    }

    public static class RemoveLastState
    extends PhdActivity {
        @Override
        protected void processPreConditions(PublicPresentationSeminarProcess process2, User userView) {
        }

        @Override
        protected void activityPreConditions(PublicPresentationSeminarProcess process2, User userView) {
            if (!process2.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected PublicPresentationSeminarProcess executeActivity(PublicPresentationSeminarProcess process2, User userView, Object object) {
            process2.removeLastState();
            return process2;
        }
    }

    public static class AddState
    extends PhdActivity {
        @Override
        protected void activityPreConditions(PublicPresentationSeminarProcess process2, User userView) {
            if (!process2.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected PublicPresentationSeminarProcess executeActivity(PublicPresentationSeminarProcess process2, User userView, Object object) {
            PublicPresentationSeminarProcessBean bean = (PublicPresentationSeminarProcessBean)object;
            process2.createState(bean.getProcessState(), AccessControl.getPerson(), bean.getRemarks());
            return process2;
        }
    }

    public static class RevertToWaitingComissionForValidation
    extends PhdActivity {
        @Override
        protected void activityPreConditions(PublicPresentationSeminarProcess process2, User userView) {
            if (!process2.getActiveState().equals(PublicPresentationSeminarProcessStateType.COMMISSION_VALIDATED)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected PublicPresentationSeminarProcess executeActivity(PublicPresentationSeminarProcess process2, User userView, Object object) {
            if (!process2.getActiveState().equals(PublicPresentationSeminarProcessStateType.COMMISSION_VALIDATED)) {
                throw new DomainException("error.PublicPresentationSeminarProcess.is.not.in.comission.validated.state", new String[0]);
            }
            PublicPresentationSeminarState mostRecentState = process2.getMostRecentState();
            PublicPresentationSeminarState.createWithGivenStateDate(process2, PublicPresentationSeminarProcessStateType.COMMISSION_WAITING_FOR_VALIDATION, userView.getPerson(), "", mostRecentState.getStateDate().plusMinutes(1));
            return process2;
        }
    }

    public static class RevertToWaitingForComissionConstitution
    extends PhdActivity {
        @Override
        public void activityPreConditions(PublicPresentationSeminarProcess process2, User userView) {
            if (!process2.getActiveState().equals(PublicPresentationSeminarProcessStateType.COMMISSION_WAITING_FOR_VALIDATION)) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected PublicPresentationSeminarProcess executeActivity(PublicPresentationSeminarProcess process2, User userView, Object object) {
            if (!process2.getActiveState().equals(PublicPresentationSeminarProcessStateType.COMMISSION_WAITING_FOR_VALIDATION)) {
                throw new DomainException("error.PublicPresentationSeminarProcess.is.not.in.comission.waiting.for.validation", new String[0]);
            }
            PublicPresentationSeminarState mostRecentState = process2.getMostRecentState();
            PublicPresentationSeminarState.createWithGivenStateDate(process2, PublicPresentationSeminarProcessStateType.WAITING_FOR_COMMISSION_CONSTITUTION, userView.getPerson(), "", mostRecentState.getStateDate().plusMinutes(1));
            return process2;
        }
    }

    public static class DownloadComissionDocument
    extends PhdActivity {
        @Override
        protected void activityPreConditions(PublicPresentationSeminarProcess process2, User userView) {
            if (!process2.hasComissionDocument()) {
                throw new PreConditionNotValidException();
            }
            if (process2.isAllowedToManageProcess(userView) || process2.getIndividualProgramProcess().isCoordinatorForPhdProgram(userView.getPerson()) || process2.getIndividualProgramProcess().isGuiderOrAssistentGuider(userView.getPerson())) {
                return;
            }
            if (process2.hasState(PublicPresentationSeminarProcessStateType.COMMISSION_VALIDATED) && process2.getIndividualProgramProcess().getPerson() == userView.getPerson()) {
                return;
            }
            throw new PreConditionNotValidException();
        }

        @Override
        protected PublicPresentationSeminarProcess executeActivity(PublicPresentationSeminarProcess process2, User userView, Object object) {
            return null;
        }
    }

    public static class DownloadReportDocument
    extends PhdActivity {
        @Override
        protected void activityPreConditions(PublicPresentationSeminarProcess process2, User userView) {
            if (!process2.hasReportDocument()) {
                throw new PreConditionNotValidException();
            }
            if (process2.isAllowedToManageProcess(userView) || process2.getIndividualProgramProcess().isCoordinatorForPhdProgram(userView.getPerson()) || process2.getIndividualProgramProcess().isGuiderOrAssistentGuider(userView.getPerson())) {
                return;
            }
            if (process2.getActiveState() == PublicPresentationSeminarProcessStateType.REPORT_VALIDATED && process2.getIndividualProgramProcess().getPerson() == userView.getPerson()) {
                return;
            }
            throw new PreConditionNotValidException();
        }

        @Override
        protected PublicPresentationSeminarProcess executeActivity(PublicPresentationSeminarProcess process2, User userView, Object object) {
            return null;
        }
    }

    public static class RejectReport
    extends PhdActivity {
        @Override
        protected void activityPreConditions(PublicPresentationSeminarProcess process2, User userView) {
            if (process2.getActiveState() != PublicPresentationSeminarProcessStateType.REPORT_WAITING_FOR_VALIDATION) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected PublicPresentationSeminarProcess executeActivity(PublicPresentationSeminarProcess process2, User userView, Object object) {
            PublicPresentationSeminarProcessBean bean = (PublicPresentationSeminarProcessBean)object;
            process2.createState(PublicPresentationSeminarProcessStateType.PUBLIC_PRESENTATION_DATE_SCHEDULED, userView.getPerson(), bean.getRemarks());
            if (bean.getGenerateAlert().booleanValue()) {
                AlertService.alertGuiders(process2.getIndividualProgramProcess(), "message.phd.alert.public.presentation.seminar.report.rejected.subject", "message.phd.alert.public.presentation.seminar.report.rejected.body");
            }
            return process2;
        }
    }

    public static class ValidateReport
    extends PhdActivity {
        @Override
        protected void activityPreConditions(PublicPresentationSeminarProcess process2, User userView) {
            if (process2.getActiveState() != PublicPresentationSeminarProcessStateType.REPORT_WAITING_FOR_VALIDATION) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected PublicPresentationSeminarProcess executeActivity(PublicPresentationSeminarProcess process2, User userView, Object object) {
            PublicPresentationSeminarProcessBean bean = (PublicPresentationSeminarProcessBean)object;
            bean.getDocument().setType(PhdIndividualProgramDocumentType.PUBLIC_PRESENTATION_SEMINAR_REPORT);
            if (bean.getDocument().hasAnyInformation()) {
                process2.addDocument(bean.getDocument(), userView.getPerson());
            }
            process2.createState(PublicPresentationSeminarProcessStateType.REPORT_VALIDATED, userView.getPerson(), bean.getRemarks());
            if (bean.getGenerateAlert().booleanValue()) {
                AlertService.alertCoordinators(process2.getIndividualProgramProcess(), "message.phd.alert.public.presentation.seminar.report.validated.subject", "message.phd.alert.public.presentation.seminar.report.validated.body");
                AlertService.alertGuiders(process2.getIndividualProgramProcess(), "message.phd.alert.public.presentation.seminar.report.validated.subject", "message.phd.alert.public.presentation.seminar.report.validated.body");
                AlertService.alertStudent(process2.getIndividualProgramProcess(), "message.phd.alert.public.presentation.seminar.report.validated.subject", "message.phd.alert.public.presentation.seminar.report.validated.body");
            }
            return process2;
        }
    }

    public static class UploadReport
    extends PhdActivity {
        @Override
        protected void activityPreConditions(PublicPresentationSeminarProcess process2, User userView) {
            if (process2.getActiveState() != PublicPresentationSeminarProcessStateType.PUBLIC_PRESENTATION_DATE_SCHEDULED) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isAllowedToManageProcess(userView) && !process2.getIndividualProgramProcess().isGuider(userView.getPerson())) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected PublicPresentationSeminarProcess executeActivity(PublicPresentationSeminarProcess process2, User userView, Object object) {
            PublicPresentationSeminarProcessBean bean = (PublicPresentationSeminarProcessBean)object;
            bean.getDocument().setType(PhdIndividualProgramDocumentType.PUBLIC_PRESENTATION_SEMINAR_REPORT);
            process2.addDocument(bean.getDocument(), userView.getPerson());
            process2.createState(PublicPresentationSeminarProcessStateType.REPORT_WAITING_FOR_VALIDATION, userView.getPerson(), bean.getRemarks());
            if (bean.getGenerateAlert().booleanValue()) {
                AlertService.alertAcademicOffice(process2.getIndividualProgramProcess(), AcademicOperationType.VIEW_PHD_PUBLIC_PRESENTATION_ALERTS, "message.phd.alert.public.presentation.seminar.report.uploaded.subject", "message.phd.alert.public.presentation.seminar.report.uploaded.body");
            }
            return process2;
        }
    }

    public static class SchedulePresentationDate
    extends PhdActivity {
        @Override
        protected void activityPreConditions(PublicPresentationSeminarProcess process2, User userView) {
            if (process2.getActiveState() != PublicPresentationSeminarProcessStateType.COMMISSION_VALIDATED) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isAllowedToManageProcess(userView) && !process2.getIndividualProgramProcess().isCoordinatorForPhdProgram(userView.getPerson())) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected PublicPresentationSeminarProcess executeActivity(PublicPresentationSeminarProcess process2, User userView, Object object) {
            PublicPresentationSeminarProcessBean bean = (PublicPresentationSeminarProcessBean)object;
            process2.setPresentationDate(bean.getPresentationDate());
            process2.createState(PublicPresentationSeminarProcessStateType.PUBLIC_PRESENTATION_DATE_SCHEDULED, userView.getPerson(), bean.getRemarks());
            if (bean.getGenerateAlert().booleanValue()) {
                AlertService.alertAcademicOffice(process2.getIndividualProgramProcess(), AcademicOperationType.VIEW_PHD_PUBLIC_PRESENTATION_ALERTS, "message.phd.alert.public.presentation.seminar.scheduled.presentation.date.subject", "message.phd.alert.public.presentation.seminar.scheduled.presentation.date.body");
                AlertService.alertGuiders(process2.getIndividualProgramProcess(), "message.phd.alert.public.presentation.seminar.scheduled.presentation.date.subject", "message.phd.alert.public.presentation.seminar.scheduled.presentation.date.body");
                AlertService.alertStudent(process2.getIndividualProgramProcess(), "message.phd.alert.public.presentation.seminar.scheduled.presentation.date.subject", "message.phd.alert.public.presentation.seminar.scheduled.presentation.date.body");
            }
            return process2;
        }
    }

    public static class RejectComission
    extends PhdActivity {
        @Override
        protected void activityPreConditions(PublicPresentationSeminarProcess process2, User userView) {
            if (process2.getActiveState() != PublicPresentationSeminarProcessStateType.COMMISSION_WAITING_FOR_VALIDATION) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected PublicPresentationSeminarProcess executeActivity(PublicPresentationSeminarProcess process2, User userView, Object object) {
            PublicPresentationSeminarProcessBean bean = (PublicPresentationSeminarProcessBean)object;
            PublicPresentationSeminarState mostRecentState = process2.getMostRecentState();
            PublicPresentationSeminarState.createWithGivenStateDate(process2, PublicPresentationSeminarProcessStateType.WAITING_FOR_COMMISSION_CONSTITUTION, userView.getPerson(), bean.getRemarks(), mostRecentState.getStateDate().plus(5L));
            if (bean.getGenerateAlert().booleanValue()) {
                AlertService.alertCoordinators(process2.getIndividualProgramProcess(), "message.phd.alert.public.presentation.seminar.comission.rejected.subject", "message.phd.alert.public.presentation.seminar.comission.rejected.body");
            }
            return process2;
        }
    }

    public static class ValidateComission
    extends PhdActivity {
        @Override
        protected void activityPreConditions(PublicPresentationSeminarProcess process2, User userView) {
            if (process2.getActiveState() != PublicPresentationSeminarProcessStateType.COMMISSION_WAITING_FOR_VALIDATION) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isAllowedToManageProcess(userView)) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected PublicPresentationSeminarProcess executeActivity(PublicPresentationSeminarProcess process2, User userView, Object object) {
            PublicPresentationSeminarProcessBean bean = (PublicPresentationSeminarProcessBean)object;
            bean.getDocument().setType(PhdIndividualProgramDocumentType.PUBLIC_PRESENTATION_SEMINAR_COMISSION);
            if (bean.getDocument().hasAnyInformation()) {
                process2.addDocument(bean.getDocument(), userView.getPerson());
            }
            process2.createState(PublicPresentationSeminarProcessStateType.COMMISSION_VALIDATED, userView.getPerson(), bean.getRemarks());
            if (bean.getGenerateAlert().booleanValue()) {
                AlertService.alertGuiders(process2.getIndividualProgramProcess(), "message.phd.alert.public.presentation.seminar.comission.validated.subject", "message.phd.alert.public.presentation.seminar.comission.validated.body");
                AlertService.alertStudent(process2.getIndividualProgramProcess(), "message.phd.alert.public.presentation.seminar.comission.validated.subject", "message.phd.alert.public.presentation.seminar.comission.validated.body");
            }
            return process2;
        }
    }

    public static class SubmitComission
    extends PhdActivity {
        @Override
        protected void activityPreConditions(PublicPresentationSeminarProcess process2, User userView) {
            if (process2.getActiveState() != PublicPresentationSeminarProcessStateType.WAITING_FOR_COMMISSION_CONSTITUTION) {
                throw new PreConditionNotValidException();
            }
            if (!process2.isAllowedToManageProcess(userView) && !process2.getIndividualProgramProcess().isCoordinatorForPhdProgram(userView.getPerson())) {
                throw new PreConditionNotValidException();
            }
        }

        @Override
        protected PublicPresentationSeminarProcess executeActivity(PublicPresentationSeminarProcess process2, User userView, Object object) {
            PublicPresentationSeminarProcessBean bean = (PublicPresentationSeminarProcessBean)object;
            bean.getDocument().setType(PhdIndividualProgramDocumentType.PUBLIC_PRESENTATION_SEMINAR_COMISSION);
            process2.addDocument(bean.getDocument(), userView.getPerson());
            process2.createState(PublicPresentationSeminarProcessStateType.COMMISSION_WAITING_FOR_VALIDATION, userView.getPerson(), bean.getRemarks());
            if (bean.getGenerateAlert().booleanValue()) {
                AlertService.alertAcademicOffice(process2.getIndividualProgramProcess(), AcademicOperationType.VIEW_PHD_PUBLIC_PRESENTATION_ALERTS, "message.phd.alert.public.presentation.seminar.comission.validation.subject", "message.phd.alert.public.presentation.seminar.comission.validation.body");
            }
            return process2;
        }
    }

    @StartActivity
    public static class RequestComission
    extends PhdActivity {
        @Override
        protected void processPreConditions(PublicPresentationSeminarProcess process2, User userView) {
        }

        @Override
        protected void activityPreConditions(PublicPresentationSeminarProcess process2, User userView) {
        }

        @Override
        protected PublicPresentationSeminarProcess executeActivity(PublicPresentationSeminarProcess noProcess, User userView, Object object) {
            PublicPresentationSeminarProcessBean bean = (PublicPresentationSeminarProcessBean)object;
            PublicPresentationSeminarProcess result = new PublicPresentationSeminarProcess(bean.getPhdIndividualProgramProcess(), bean);
            result.createState(PublicPresentationSeminarProcessStateType.WAITING_FOR_COMMISSION_CONSTITUTION, userView.getPerson(), ((PublicPresentationSeminarProcessBean)object).getRemarks());
            return result;
        }
    }

    private static abstract class PhdActivity
    extends Activity<PublicPresentationSeminarProcess> {
        private PhdActivity() {
        }

        @Override
        public void checkPreConditions(PublicPresentationSeminarProcess process2, User userView) {
            this.processPreConditions(process2, userView);
            this.activityPreConditions(process2, userView);
        }

        protected void processPreConditions(PublicPresentationSeminarProcess process2, User userView) {
            if (process2 != null && process2.isExempted()) {
                throw new PreConditionNotValidException();
            }
        }

        protected abstract void activityPreConditions(PublicPresentationSeminarProcess var1, User var2);
    }
}

