/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.debts;

import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountType;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.phd.debts.ExternalScholarshipPhdGratuityContribuitionEvent_Base;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityEvent;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityExternalScholarshipExemption;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;

public class ExternalScholarshipPhdGratuityContribuitionEvent
extends ExternalScholarshipPhdGratuityContribuitionEvent_Base {
    public ExternalScholarshipPhdGratuityContribuitionEvent(Party party) {
        this.init(EventType.EXTERNAL_SCOLARSHIP, party);
        this.setRootDomainObject(Bennu.getInstance());
    }

    protected void disconnect() {
        PhdGratuityExternalScholarshipExemption exemption = this.getPhdGratuityExternalScholarshipExemption();
        exemption.doDelete();
        super.disconnect();
    }

    public Money calculateAmountToPay() {
        return this.calculateAmountToPay(new DateTime());
    }

    public Money getTotalValue() {
        return this.getPhdGratuityExternalScholarshipExemption().getValue();
    }

    protected Account getFromAccount() {
        return this.getParty().getAccountBy(AccountType.EXTERNAL);
    }

    public Account getToAccount() {
        return ((PhdGratuityEvent)((Object)this.getPhdGratuityExternalScholarshipExemption().getEvent())).getPhdProgram().getPhdProgramUnit().getAccountBy(AccountType.INTERNAL);
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        return new LabelFormatter().appendLabel(entryType.name(), "resources.EnumerationResources").appendLabel(" (").appendLabel(((PhdGratuityEvent)((Object)this.getPhdGratuityExternalScholarshipExemption().getEvent())).getPhdProgram().getName().getContent()).appendLabel(")");
    }

    public PostingRule getPostingRule() {
        return AdministrativeOffice.readMasterDegreeAdministrativeOffice().getServiceAgreementTemplate().findPostingRuleByEventTypeAndDate(this.getEventType(), this.getWhenOccured());
    }

    public Unit getOwnerUnit() {
        return AdministrativeOffice.readMasterDegreeAdministrativeOffice().getUnit();
    }

    public boolean isFctScholarshipPhdGratuityContribuitionEvent() {
        return true;
    }
}

