/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.candidacy;

import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.period.CandidacyPeriod;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.candidacy.InstitutionPhdCandidacyPeriod$callable$addPhdProgramListToPeriod;
import org.fenixedu.academic.domain.phd.candidacy.InstitutionPhdCandidacyPeriod$callable$addPhdProgramToPeriod;
import org.fenixedu.academic.domain.phd.candidacy.InstitutionPhdCandidacyPeriod$callable$create;
import org.fenixedu.academic.domain.phd.candidacy.InstitutionPhdCandidacyPeriod$callable$removePhdProgramInPeriod;
import org.fenixedu.academic.domain.phd.candidacy.InstitutionPhdCandidacyPeriod_Base;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyPeriod;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyPeriodBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyPeriodType;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyReferee;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.academic.util.phd.InstitutionPhdCandidacyProcessProperties;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class InstitutionPhdCandidacyPeriod
extends InstitutionPhdCandidacyPeriod_Base {
    public static final Advice advice$addPhdProgramToPeriod = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$addPhdProgramListToPeriod = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$removePhdProgramInPeriod = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected InstitutionPhdCandidacyPeriod() {
    }

    protected InstitutionPhdCandidacyPeriod(ExecutionYear executionYear, DateTime start, DateTime end, PhdCandidacyPeriodType type) {
        this();
        this.init(executionYear, start, end, type);
    }

    protected void init(ExecutionYear executionYear, DateTime start, DateTime end, PhdCandidacyPeriodType type) {
        this.checkOverlapingDates(start, end, type);
        if (!PhdCandidacyPeriodType.INSTITUTION.equals((Object)type)) {
            throw new DomainException("error.InstitutionPhdCandidacyPeriod.type.must.be.institution", new String[0]);
        }
        super.init(executionYear, start, end, type);
    }

    public boolean isInstitutionCandidacyPeriod() {
        return true;
    }

    public void addPhdProgramToPeriod(PhdProgram phdProgram) {
        Object object = advice$addPhdProgramToPeriod.perform((Callable)new InstitutionPhdCandidacyPeriod$callable$addPhdProgramToPeriod(this, phdProgram));
    }

    static /* synthetic */ void advised$addPhdProgramToPeriod(InstitutionPhdCandidacyPeriod this_, PhdProgram phdProgram) {
        if (phdProgram == null) {
            throw new DomainException("phd.InstitutionPhdCandidacyPeriod.phdProgram.required", new String[0]);
        }
        super.addPhdPrograms(phdProgram);
    }

    public void addPhdProgramListToPeriod(List<PhdProgram> list) {
        Object object = advice$addPhdProgramListToPeriod.perform((Callable)new InstitutionPhdCandidacyPeriod$callable$addPhdProgramListToPeriod(this, list));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$addPhdProgramListToPeriod(InstitutionPhdCandidacyPeriod this_, List phdProgramList) {
        super.getPhdProgramsSet().addAll(phdProgramList);
    }

    public void removePhdProgramInPeriod(PhdProgram phdProgram) {
        Object object = advice$removePhdProgramInPeriod.perform((Callable)new InstitutionPhdCandidacyPeriod$callable$removePhdProgramInPeriod(this, phdProgram));
    }

    static /* synthetic */ void advised$removePhdProgramInPeriod(InstitutionPhdCandidacyPeriod this_, PhdProgram phdProgram) {
        if (phdProgram == null) {
            throw new DomainException("phd.InstitutionPhdCandidacyPeriod.phdProgram.required", new String[0]);
        }
        super.removePhdPrograms(phdProgram);
    }

    public void addPhdPrograms(PhdProgram phdPrograms) {
        throw new DomainException("call addPhdProgramToPeriod()", new String[0]);
    }

    public void removePhdPrograms(PhdProgram phdPrograms) {
        throw new DomainException("call removePhdProgramInPeriod()", new String[0]);
    }

    public static InstitutionPhdCandidacyPeriod create(PhdCandidacyPeriodBean phdCandidacyPeriodBean) {
        return (InstitutionPhdCandidacyPeriod)((Object)advice$create.perform((Callable)new InstitutionPhdCandidacyPeriod$callable$create(phdCandidacyPeriodBean)));
    }

    static /* synthetic */ InstitutionPhdCandidacyPeriod advised$create(PhdCandidacyPeriodBean phdCandidacyPeriodBean) {
        ExecutionYear executionYear = phdCandidacyPeriodBean.getExecutionYear();
        DateTime start = phdCandidacyPeriodBean.getStart();
        DateTime end = phdCandidacyPeriodBean.getEnd();
        PhdCandidacyPeriodType type = phdCandidacyPeriodBean.getType();
        return new InstitutionPhdCandidacyPeriod(executionYear, start, end, type);
    }

    public static InstitutionPhdCandidacyPeriod readInstitutionPhdCandidacyPeriodForDate(DateTime date) {
        for (CandidacyPeriod period : Bennu.getInstance().getCandidacyPeriodsSet()) {
            if (!period.isInstitutionCandidacyPeriod() || !period.contains(date)) continue;
            return (InstitutionPhdCandidacyPeriod)((Object)period);
        }
        return null;
    }

    public static boolean isAnyInstitutionPhdCandidacyPeriodActive(DateTime date) {
        return InstitutionPhdCandidacyPeriod.readInstitutionPhdCandidacyPeriodForDate(date) != null;
    }

    public static boolean isAnyInstitutionPhdCandidacyPeriodActive() {
        return InstitutionPhdCandidacyPeriod.isAnyInstitutionPhdCandidacyPeriodActive(new DateTime());
    }

    public static InstitutionPhdCandidacyPeriod getMostRecentCandidacyPeriod() {
        PhdCandidacyPeriod mostRecentCandidacyPeriod = null;
        for (CandidacyPeriod candidacyPeriod : Bennu.getInstance().getCandidacyPeriodsSet()) {
            if (!candidacyPeriod.isInstitutionCandidacyPeriod() || candidacyPeriod.getStart().isAfterNow()) continue;
            if (mostRecentCandidacyPeriod == null) {
                mostRecentCandidacyPeriod = (PhdCandidacyPeriod)((Object)candidacyPeriod);
                continue;
            }
            if (!candidacyPeriod.getStart().isAfter((ReadableInstant)mostRecentCandidacyPeriod.getStart())) continue;
            mostRecentCandidacyPeriod = (PhdCandidacyPeriod)((Object)candidacyPeriod);
        }
        return (InstitutionPhdCandidacyPeriod)((Object)mostRecentCandidacyPeriod);
    }

    public String getEmailMessageBodyForRefereeForm(PhdCandidacyReferee referee) {
        return MessageFormat.format(String.format(BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.institution.email.body.referee", (String[])new String[0]), referee.getPhdProgramCandidacyProcess().getPhdProgram().getName().getContent(MultiLanguageString.en), InstitutionPhdCandidacyProcessProperties.getPublicCandidacyRefereeFormLink(new Locale("en", "EN")), referee.getValue(), referee.getPhdProgramCandidacyProcess().getPhdProgram().getName().getContent(MultiLanguageString.pt), InstitutionPhdCandidacyProcessProperties.getPublicCandidacyRefereeFormLink(new Locale("pt", "PT")), referee.getValue()), Unit.getInstitutionName().getContent());
    }

    public String getRefereeSubmissionFormLinkPt(PhdCandidacyReferee referee) {
        return String.format("%s?hash=%s&locale=pt_PT", InstitutionPhdCandidacyProcessProperties.getPublicCandidacyRefereeFormLink(new Locale("pt", "PT")), referee.getValue());
    }

    public String getRefereeSubmissionFormLinkEn(PhdCandidacyReferee referee) {
        return String.format("%s?hash=%s&locale=en_EN", InstitutionPhdCandidacyProcessProperties.getPublicCandidacyRefereeFormLink(new Locale("en", "EN")), referee.getValue());
    }

    public MultiLanguageString getEmailMessageSubjectForMissingCandidacyValidation(PhdIndividualProgramProcess process2) {
        return new MultiLanguageString().with(MultiLanguageString.pt, MessageFormat.format(BundleUtil.getString((String)"resources.PhdResources", (Locale)Locale.forLanguageTag("pt"), (String)"message.phd.institution.email.subject.missing.candidacy.validation", (String[])new String[0]), Unit.getInstitutionAcronym())).with(MultiLanguageString.en, MessageFormat.format(BundleUtil.getString((String)"resources.PhdResources", (Locale)Locale.ENGLISH, (String)"message.phd.institution.email.subject.missing.candidacy.validation", (String[])new String[0]), Unit.getInstitutionAcronym()));
    }

    public MultiLanguageString getEmailMessageBodyForMissingCandidacyValidation(PhdIndividualProgramProcess process2) {
        String englishBody = MessageFormat.format(String.format(BundleUtil.getString((String)"resources.PhdResources", (Locale)Locale.ENGLISH, (String)"message.phd.institution.email.body.missing.candidacy.validation", (String[])new String[0]), InstitutionPhdCandidacyProcessProperties.getPublicCandidacyAccessLink(new Locale("en", "EN")), process2.getCandidacyProcess().getCandidacyHashCode().getValue()), Unit.getInstitutionAcronym());
        String portugueseBody = MessageFormat.format(String.format(BundleUtil.getString((String)"resources.PhdResources", (Locale)Locale.forLanguageTag("pt"), (String)"message.phd.institution.email.body.missing.candidacy.validation", (String[])new String[0]), InstitutionPhdCandidacyProcessProperties.getPublicCandidacyAccessLink(new Locale("en", "EN")), process2.getCandidacyProcess().getCandidacyHashCode().getValue()), Unit.getInstitutionAcronym());
        return new MultiLanguageString().with(MultiLanguageString.en, englishBody).with(MultiLanguageString.pt, portugueseBody);
    }

    public static InstitutionPhdCandidacyPeriod readNextCandidacyPeriod() {
        List readOrderedPhdCandidacyPeriods = InstitutionPhdCandidacyPeriod.readOrderedPhdCandidacyPeriods();
        for (PhdCandidacyPeriod phdCandidacyPeriod : readOrderedPhdCandidacyPeriods) {
            if (!phdCandidacyPeriod.isInstitutionCandidacyPeriod() || !phdCandidacyPeriod.getStart().isAfterNow()) continue;
            return (InstitutionPhdCandidacyPeriod)((Object)phdCandidacyPeriod);
        }
        return null;
    }
}

