/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.phd.ExternalPhdProgram;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramCollaborationType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessState;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.PhdProgramFocusArea;
import org.fenixedu.academic.domain.phd.ThesisSubject;
import org.fenixedu.academic.domain.phd.ThesisSubjectOrder;
import org.fenixedu.academic.domain.phd.candidacy.PhdThesisSubjectOrderBean;
import org.joda.time.LocalDate;

public class PhdIndividualProgramProcessBean
implements Serializable {
    private static final long serialVersionUID = 909403079500457245L;
    private LocalDate candidacyDate;
    private String thesisTitle;
    private String thesisTitleEn;
    private PhdIndividualProgramCollaborationType collaborationType;
    private String otherCollaborationType;
    private final List<PhdThesisSubjectOrderBean> thesisSubjectBeans = new ArrayList<PhdThesisSubjectOrderBean>();
    private PhdIndividualProgramProcess individualProgramProcess;
    private PhdProgram phdProgram;
    private PhdProgramFocusArea focusArea;
    private ExternalPhdProgram externalPhdProgram;
    private QualificationExamsResult qualificationExamsRequired;
    private QualificationExamsResult qualificationExamsPerformed;
    private PhdIndividualProgramProcessState processState;
    private LocalDate whenRatified;
    private LocalDate whenFormalizedRegistration;
    private LocalDate whenStartedStudies;
    private Integer phdStudentNumber;
    private PhdIndividualProgramProcess destiny;
    private String remarks;
    private LocalDate stateDate;

    public PhdIndividualProgramProcessBean() {
        this.setQualificationExamsRequired(QualificationExamsResult.NULL);
        this.setQualificationExamsPerformed(QualificationExamsResult.NULL);
    }

    public PhdIndividualProgramProcessBean(PhdIndividualProgramProcess process2) {
        this.setCandidacyDate(process2.getCandidacyDate());
        this.setPhdProgram(process2.getPhdProgram());
        this.setFocusArea(process2.getPhdProgramFocusArea());
        this.setExternalPhdProgram(process2.getExternalPhdProgram());
        for (ThesisSubjectOrder subjectOrder : process2.getThesisSubjectOrdersSet()) {
            this.addThesisSubjectBean(new PhdThesisSubjectOrderBean(subjectOrder.getSubjectOrder(), subjectOrder.getThesisSubject()));
        }
        this.sortThesisSubjectBeans();
        this.setThesisTitle(process2.getThesisTitle());
        this.setThesisTitleEn(process2.getThesisTitleEn());
        this.setCollaborationType(process2.getCollaborationType());
        this.setOtherCollaborationType(process2.getOtherCollaborationType());
        this.setIndividualProgramProcess(process2);
        this.setQualificationExamsRequired(QualificationExamsResult.fromValue(process2.getQualificationExamsRequired()));
        this.setQualificationExamsPerformed(QualificationExamsResult.fromValue(process2.getQualificationExamsPerformed()));
        this.setWhenRatified(process2.getCandidacyProcess().getWhenRatified());
        this.setWhenFormalizedRegistration(process2.getWhenFormalizedRegistration());
        this.setWhenStartedStudies(process2.getWhenStartedStudies());
        this.setPhdStudentNumber(process2.getPhdIndividualProcessNumber().getPhdStudentNumber());
    }

    public List<PhdThesisSubjectOrderBean> getThesisSubjectBeans() {
        return this.thesisSubjectBeans;
    }

    public void addThesisSubjectBean(PhdThesisSubjectOrderBean thesisSubjectBean) {
        this.thesisSubjectBeans.add(thesisSubjectBean);
        this.sortThesisSubjectBeans();
    }

    public PhdThesisSubjectOrderBean getThesisSubjectBean(int order) {
        for (PhdThesisSubjectOrderBean bean : this.getThesisSubjectBeans()) {
            if (bean.getOrder() != order) continue;
            return bean;
        }
        return null;
    }

    public void sortThesisSubjectBeans() {
        Collections.sort(this.thesisSubjectBeans, PhdThesisSubjectOrderBean.COMPARATOR_BY_ORDER);
    }

    public void updateThesisSubjectBeans() {
        int order = 1;
        this.getThesisSubjectBeans().clear();
        if (this.hasFocusArea()) {
            for (ThesisSubject thesisSubject : this.getFocusArea().getThesisSubjectsSet()) {
                this.addThesisSubjectBean(new PhdThesisSubjectOrderBean(order++, thesisSubject));
            }
        }
    }

    public LocalDate getCandidacyDate() {
        return this.candidacyDate;
    }

    public void setCandidacyDate(LocalDate candidacyDate) {
        this.candidacyDate = candidacyDate;
    }

    public String getThesisTitle() {
        return this.thesisTitle;
    }

    public void setThesisTitle(String thesisTitle) {
        this.thesisTitle = thesisTitle;
    }

    public String getThesisTitleEn() {
        return this.thesisTitleEn;
    }

    public void setThesisTitleEn(String thesisTitleEn) {
        this.thesisTitleEn = thesisTitleEn;
    }

    public PhdIndividualProgramCollaborationType getCollaborationType() {
        return this.collaborationType;
    }

    public void setCollaborationType(PhdIndividualProgramCollaborationType collaborationType) {
        this.collaborationType = collaborationType;
    }

    public String getOtherCollaborationType() {
        return this.otherCollaborationType;
    }

    public void setOtherCollaborationType(String otherCollaborationType) {
        this.otherCollaborationType = otherCollaborationType;
    }

    public boolean isCollaborationInformationCorrect() {
        return this.getCollaborationType().needExtraInformation() ? !StringUtils.isEmpty((String)this.otherCollaborationType) : true;
    }

    public PhdIndividualProgramProcess getIndividualProgramProcess() {
        return this.individualProgramProcess;
    }

    public void setIndividualProgramProcess(PhdIndividualProgramProcess individualProgramProcess) {
        this.individualProgramProcess = individualProgramProcess;
    }

    public PhdProgram getPhdProgram() {
        return this.phdProgram;
    }

    public void setPhdProgram(PhdProgram phdProgram) {
        this.phdProgram = phdProgram;
    }

    public boolean hasPhdProgram() {
        return this.getPhdProgram() != null;
    }

    public PhdProgramFocusArea getFocusArea() {
        return this.focusArea;
    }

    public void setFocusArea(PhdProgramFocusArea focusArea) {
        this.focusArea = focusArea;
    }

    public boolean hasFocusArea() {
        return this.getFocusArea() != null;
    }

    public QualificationExamsResult getQualificationExamsRequired() {
        return this.qualificationExamsRequired;
    }

    public Boolean getQualificationExamsRequiredBooleanValue() {
        return this.qualificationExamsRequired.getValue();
    }

    public void setQualificationExamsRequired(QualificationExamsResult qualificationExamsRequired) {
        this.qualificationExamsRequired = qualificationExamsRequired;
    }

    public QualificationExamsResult getQualificationExamsPerformed() {
        return this.qualificationExamsPerformed;
    }

    public Boolean getQualificationExamsPerformedBooleanValue() {
        return this.qualificationExamsPerformed.getValue();
    }

    public void setQualificationExamsPerformed(QualificationExamsResult qualificationExamsPerformed) {
        this.qualificationExamsPerformed = qualificationExamsPerformed;
    }

    public PhdIndividualProgramProcessState getProcessState() {
        return this.processState;
    }

    public void setProcessState(PhdIndividualProgramProcessState processState) {
        this.processState = processState;
    }

    public ExternalPhdProgram getExternalPhdProgram() {
        return this.externalPhdProgram;
    }

    public void setExternalPhdProgram(ExternalPhdProgram externalPhdProgram) {
        this.externalPhdProgram = externalPhdProgram;
    }

    public LocalDate getWhenRatified() {
        return this.whenRatified;
    }

    public void setWhenRatified(LocalDate whenRatified) {
        this.whenRatified = whenRatified;
    }

    public LocalDate getWhenFormalizedRegistration() {
        return this.whenFormalizedRegistration;
    }

    public void setWhenFormalizedRegistration(LocalDate whenFormalizedRegistration) {
        this.whenFormalizedRegistration = whenFormalizedRegistration;
    }

    public LocalDate getWhenStartedStudies() {
        return this.whenStartedStudies;
    }

    public void setWhenStartedStudies(LocalDate whenStartedStudies) {
        this.whenStartedStudies = whenStartedStudies;
    }

    public Integer getPhdStudentNumber() {
        return this.phdStudentNumber;
    }

    public void setPhdStudentNumber(Integer phdStudentNumber) {
        this.phdStudentNumber = phdStudentNumber;
    }

    public PhdIndividualProgramProcess getDestiny() {
        return this.destiny;
    }

    public void setDestiny(PhdIndividualProgramProcess destiny) {
        this.destiny = destiny;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public LocalDate getStateDate() {
        return this.stateDate;
    }

    public void setStateDate(LocalDate stateDate) {
        this.stateDate = stateDate;
    }

    public static enum QualificationExamsResult {
        NULL(null),
        YES(Boolean.TRUE),
        NO(Boolean.FALSE);

        private Boolean value;

        private QualificationExamsResult(Boolean value) {
            this.value = value;
        }

        public Boolean getValue() {
            return this.value;
        }

        public static QualificationExamsResult fromValue(Boolean value) {
            if (value == null) {
                return NULL;
            }
            if (value == Boolean.TRUE) {
                return YES;
            }
            return NO;
        }
    }
}

