/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.documents;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.documents.AnnualIRSDeclarationDocument$callable$create;
import org.fenixedu.academic.domain.documents.AnnualIRSDeclarationDocument$callable$generateAnotherDeclaration;
import org.fenixedu.academic.domain.documents.AnnualIRSDeclarationDocument_Base;
import org.fenixedu.academic.domain.documents.GeneratedDocumentType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AnnualIRSDeclarationDocument
extends AnnualIRSDeclarationDocument_Base {
    public static final Advice advice$generateAnotherDeclaration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public AnnualIRSDeclarationDocument(Person addressee, Person operator, String filename, byte[] content, Integer year) {
        this.checkParameters(year);
        this.checkRulesToCreate(addressee, year);
        this.setYear(year);
        this.init(GeneratedDocumentType.ANNUAL_IRS_DECLARATION, (Party)((Object)addressee), operator, filename, content);
    }

    public Person getAddressee() {
        return (Person)((Object)super.getAddressee());
    }

    public boolean isAccessible(User user) {
        return super.isAccessible(user) || RoleType.MANAGER.isMember(user);
    }

    private void checkRulesToCreate(Person addressee, Integer year) {
        if (addressee.hasAnnualIRSDocumentFor(year)) {
            throw new DomainException("error.documents.AnnualIRSDeclarationDocument.annual.irs.document.alread.exists.for.year", new String[0]);
        }
    }

    private void checkParameters(Integer year) {
        if (year == null) {
            throw new DomainException("error.documents.AnnualIRSDeclarationDocument.year.cannot.be.null", new String[0]);
        }
    }

    public AnnualIRSDeclarationDocument generateAnotherDeclaration(Person person, byte[] byArray) {
        return (AnnualIRSDeclarationDocument)((Object)advice$generateAnotherDeclaration.perform((Callable)new AnnualIRSDeclarationDocument$callable$generateAnotherDeclaration(this, person, byArray)));
    }

    static /* synthetic */ AnnualIRSDeclarationDocument advised$generateAnotherDeclaration(AnnualIRSDeclarationDocument this_, Person operator, byte[] content) {
        Person addressee = this_.getAddressee();
        Integer year = this_.getYear();
        this_.delete();
        return new AnnualIRSDeclarationDocument(addressee, operator, AnnualIRSDeclarationDocument.buildFilename(addressee, year), content, year);
    }

    private static String buildFilename(Person person, Integer year) {
        return String.format("IRS-%s-%s-%s.pdf", year, person.getDocumentIdNumber(), new LocalDate().toString("yyyyMMdd"));
    }

    public static AnnualIRSDeclarationDocument create(Person person, Person person2, byte[] byArray, Integer n) {
        return (AnnualIRSDeclarationDocument)((Object)advice$create.perform((Callable)new AnnualIRSDeclarationDocument$callable$create(person, person2, byArray, n)));
    }

    static /* synthetic */ AnnualIRSDeclarationDocument advised$create(Person addressee, Person operator, byte[] content, Integer year) {
        return new AnnualIRSDeclarationDocument(addressee, operator, AnnualIRSDeclarationDocument.buildFilename(addressee, year), content, year);
    }
}

