/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.MaximumNumberOfEctsInStandaloneCurriculumGroup;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.StandaloneCurriculumGroup;

public class MaximumNumberOfEctsInStandaloneCurriculumGroupExecutor
extends CurricularRuleExecutor {
    @Override
    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }

    @Override
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        MaximumNumberOfEctsInStandaloneCurriculumGroup rule = (MaximumNumberOfEctsInStandaloneCurriculumGroup)curricularRule;
        double total = this.calculateTotalEctsCredits(enrolmentContext) + this.calculateApprovedEcts(enrolmentContext);
        if (!rule.allowEcts(total)) {
            return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.MaximumNumberOfEctsInStandaloneCurriculumGroupExecutor", String.valueOf(rule.getMaximumEcts()), String.valueOf(total));
        }
        return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    private double calculateTotalEctsCredits(EnrolmentContext enrolmentContext) {
        double accumulated = 0.0;
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getDegreeModulesToEvaluate()) {
            accumulated += this.calculateAccumulatedEctsCredits(degreeModuleToEvaluate, enrolmentContext);
        }
        return accumulated;
    }

    protected double calculateAccumulatedEctsCredits(IDegreeModuleToEvaluate degreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        if (enrolmentContext.isToEvaluateRulesByYear()) {
            return degreeModuleToEvaluate.getEctsCredits();
        }
        return degreeModuleToEvaluate.getAccumulatedEctsCredits(enrolmentContext.getExecutionPeriod());
    }

    private double calculateApprovedEcts(EnrolmentContext enrolmentContext) {
        ExecutionSemester executionSemester = enrolmentContext.getExecutionPeriod();
        StandaloneCurriculumGroup group = enrolmentContext.getStudentCurricularPlan().getStandaloneCurriculumGroup();
        double approved = 0.0;
        for (CurriculumLine line : group.getChildCurriculumLines()) {
            if (!line.isApproved() || !line.isValid(executionSemester)) continue;
            approved += line.getAccumulatedEctsCredits(executionSemester);
        }
        return approved;
    }

    @Override
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return this.executeEnrolmentVerificationWithRules(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
    }
}

