/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.degreeTransfer;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacySeriesGradeState;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyState;
import org.fenixedu.academic.domain.candidacyProcess.degreeTransfer.DegreeTransferIndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.degreeTransfer.DegreeTransferIndividualCandidacySeriesGrade;

public class DegreeTransferIndividualCandidacyResultBean
implements Serializable {
    private DegreeTransferIndividualCandidacyProcess candidacyProcess;
    private BigDecimal affinity;
    private Integer degreeNature;
    private BigDecimal approvedEctsRate;
    private BigDecimal gradeRate;
    private BigDecimal seriesCandidacyGrade;
    private IndividualCandidacyState state;
    private IndividualCandidacySeriesGradeState seriesGradeState;
    private Degree degree;
    private List<Degree> degrees;

    public DegreeTransferIndividualCandidacyResultBean(DegreeTransferIndividualCandidacyProcess process2) {
        this.setCandidacyProcess(process2);
        this.setAffinity(process2.getCandidacyAffinity());
        this.setDegreeNature(process2.getCandidacyDegreeNature());
        this.setApprovedEctsRate(process2.getCandidacyApprovedEctsRate());
        this.setGradeRate(process2.getCandidacyGradeRate());
        this.setSeriesCandidacyGrade(process2.getCandidacySeriesCandidacyGrade());
        if (process2.isCandidacyAccepted() || process2.isCandidacyRejected()) {
            this.setState(process2.getCandidacyState());
        }
        ArrayList<Degree> d = new ArrayList<Degree>();
        d.add(process2.getCandidacy().getSelectedDegree());
        this.setDegrees(d);
    }

    public DegreeTransferIndividualCandidacyResultBean(DegreeTransferIndividualCandidacyProcess process2, Degree degree) {
        this.setCandidacyProcess(process2);
        DegreeTransferIndividualCandidacySeriesGrade seriesGradeForDegree = process2.getCandidacy().getDegreeTransferIndividualCandidacySeriesGradeForDegree(degree);
        this.setAffinity(seriesGradeForDegree.getAffinity());
        this.setDegreeNature(seriesGradeForDegree.getDegreeNature());
        this.setApprovedEctsRate(seriesGradeForDegree.getApprovedEctsRate());
        this.setGradeRate(seriesGradeForDegree.getGradeRate());
        this.setSeriesCandidacyGrade(seriesGradeForDegree.getSeriesCandidacyGrade());
        if (process2.isCandidacyAccepted() || process2.isCandidacyRejected()) {
            this.setState(process2.getCandidacyState());
        }
        ArrayList<Degree> d = new ArrayList<Degree>();
        d.add(degree);
        this.setDegrees(d);
        this.setDegree(degree);
        this.setSeriesGradeState(seriesGradeForDegree.getState());
    }

    public DegreeTransferIndividualCandidacyProcess getCandidacyProcess() {
        return this.candidacyProcess;
    }

    public void setCandidacyProcess(DegreeTransferIndividualCandidacyProcess candidacyProcess) {
        this.candidacyProcess = candidacyProcess;
    }

    public String getStudentNumber() {
        return this.getCandidacyProcess().getPersonalDetails().hasStudent() ? this.getCandidacyProcess().getPersonalDetails().getStudent().getNumber().toString() : null;
    }

    public String getCandidacyPersonName() {
        return this.getCandidacyProcess().getPersonalDetails().getName();
    }

    public BigDecimal getAffinity() {
        return this.affinity;
    }

    public void setAffinity(BigDecimal affinity) {
        this.affinity = affinity;
    }

    public Integer getDegreeNature() {
        return this.degreeNature;
    }

    public void setDegreeNature(Integer degreeNature) {
        this.degreeNature = degreeNature;
    }

    public BigDecimal getApprovedEctsRate() {
        return this.approvedEctsRate;
    }

    public void setApprovedEctsRate(BigDecimal approvedEctsRate) {
        this.approvedEctsRate = approvedEctsRate;
    }

    public BigDecimal getGradeRate() {
        return this.gradeRate;
    }

    public void setGradeRate(BigDecimal gradeRate) {
        this.gradeRate = gradeRate;
    }

    public BigDecimal getSeriesCandidacyGrade() {
        return this.seriesCandidacyGrade;
    }

    public void setSeriesCandidacyGrade(BigDecimal seriesCandidacyGrade) {
        this.seriesCandidacyGrade = seriesCandidacyGrade;
    }

    public IndividualCandidacyState getState() {
        return this.state;
    }

    public void setState(IndividualCandidacyState state) {
        this.state = state;
    }

    public Degree getDegree() {
        return this.degree;
    }

    public void setDegree(Degree degree) {
        this.degree = degree;
    }

    public List<Degree> getDegrees() {
        return this.degrees;
    }

    public void setDegrees(List<Degree> degrees) {
        this.degrees = degrees;
    }

    public IndividualCandidacySeriesGradeState getSeriesGradeState() {
        return this.seriesGradeState;
    }

    public void setSeriesGradeState(IndividualCandidacySeriesGradeState seriesGradeState) {
        this.seriesGradeState = seriesGradeState;
    }
}

