/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.report.events;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.report.events.Wrapper;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.phd.debts.ExternalScholarshipPhdGratuityContribuitionEvent;
import org.fenixedu.academic.domain.phd.debts.PhdGratuityEvent;
import org.fenixedu.academic.domain.student.Student;

public class ExternalScholarshipPhdGratuityContribuitionEventWrapper
implements Wrapper {
    private final ExternalScholarshipPhdGratuityContribuitionEvent event;

    public ExternalScholarshipPhdGratuityContribuitionEventWrapper(Event event) {
        this.event = (ExternalScholarshipPhdGratuityContribuitionEvent)((Object)event);
    }

    private PhdGratuityEvent getPhdGratuityEvent() {
        PhdGratuityEvent phdGratuityEvent = (PhdGratuityEvent)((Object)this.event.getPhdGratuityExternalScholarshipExemption().getEvent());
        return phdGratuityEvent;
    }

    private Student getStudent() {
        return this.getPhdGratuityEvent().getPerson().getStudent();
    }

    @Override
    public String getStudentNumber() {
        Student student = this.getStudent();
        return student.getNumber().toString();
    }

    @Override
    public String getStudentName() {
        return this.getStudent().getPerson().getName();
    }

    @Override
    public String getStudentEmail() {
        return this.getStudent().getPerson().getDefaultEmailAddressValue();
    }

    @Override
    public String getRegistrationStartDate() {
        return "";
    }

    @Override
    public String getExecutionYear() {
        return this.getForExecutionYear().getName();
    }

    @Override
    public String getDegreeName() {
        return "";
    }

    @Override
    public String getDegreeType() {
        return "";
    }

    @Override
    public String getPhdProgramName() {
        PhdGratuityEvent phdGratuityEvent = this.getPhdGratuityEvent();
        return phdGratuityEvent.getPhdIndividualProgramProcess().getPhdProgram().getName().getContent();
    }

    @Override
    public String getEnrolledECTS() {
        return "";
    }

    @Override
    public String getRegime() {
        return "";
    }

    @Override
    public String getEnrolmentModel() {
        return "";
    }

    @Override
    public String getResidenceYear() {
        return "";
    }

    @Override
    public String getResidenceMonth() {
        return "";
    }

    @Override
    public String getStudiesType() {
        return "Programa Doutoral";
    }

    @Override
    public String getTotalDiscount() {
        return "";
    }

    @Override
    public boolean isAfterOrEqualExecutionYear(ExecutionYear executionYear) {
        return this.getForExecutionYear().isAfterOrEquals(executionYear);
    }

    @Override
    public ExecutionYear getForExecutionYear() {
        return ExecutionYear.readByDateTime(this.event.getEventStateDate());
    }

    @Override
    public AdministrativeOffice getRelatedAcademicOffice() {
        return this.getPhdGratuityEvent().getPhdIndividualProgramProcess().getAdministrativeOffice();
    }

    @Override
    public String getRelatedEventExternalId() {
        return this.getPhdGratuityEvent().getExternalId();
    }

    @Override
    public String getDebtorFiscalId() {
        return this.event.getParty().getSocialSecurityNumber();
    }

    @Override
    public String getDebtorName() {
        return this.event.getParty().getName();
    }
}

