/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.candidacy;

import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.AcademicEventExemption;
import org.fenixedu.academic.domain.accounting.postingRules.candidacy.Over23IndividualCandidacyPR_Base;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class Over23IndividualCandidacyPR
extends Over23IndividualCandidacyPR_Base {
    public Over23IndividualCandidacyPR() {
    }

    public Over23IndividualCandidacyPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount) {
        this();
        this.init(EntryType.OVER23_INDIVIDUAL_CANDIDACY_FEE, EventType.OVER23_INDIVIDUAL_CANDIDACY, startDate, endDate, serviceAgreementTemplate, fixedAmount);
    }

    public Over23IndividualCandidacyPR edit(Money fixedAmount) {
        this.deactivate();
        return new Over23IndividualCandidacyPR(new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), fixedAmount);
    }

    public PaymentCodeType calculatePaymentCodeTypeFromEvent(Event event, DateTime when, boolean applyDiscount) {
        return PaymentCodeType.OVER_23_INDIVIDUAL_CANDIDACY_PROCESS;
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        if (event.getExemptionsSet().isEmpty()) {
            return amountToPay;
        }
        for (Exemption exemption : event.getExemptionsSet()) {
            if (!exemption.isAcademicEventExemption()) continue;
            AcademicEventExemption academicEventExemption = (AcademicEventExemption)((Object)exemption);
            amountToPay = amountToPay.subtract(academicEventExemption.getValue());
        }
        if (amountToPay.isNegative()) {
            return Money.ZERO;
        }
        return amountToPay;
    }
}

