/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.gratuity;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public enum GratuityExemptionJustificationType {
    INSTITUTION,
    INSTITUTION_GRANT_OWNER,
    OTHER_INSTITUTION,
    PALOP_TEACHER,
    SON_OF_DECORATED_MILITARY,
    SOCIAL_SHARE_GRANT_OWNER,
    STUDENT_TEACH,
    DIRECTIVE_COUNCIL_AUTHORIZATION,
    SEPARATION_CYCLES_AUTHORIZATION;


    public String getName() {
        return this.name();
    }

    public String getQualifiedName() {
        return GratuityExemptionJustificationType.class.getSimpleName() + "." + this.name();
    }

    public String getFullyQualifiedName() {
        return GratuityExemptionJustificationType.class.getName() + "." + this.name();
    }

    public static List<GratuityExemptionJustificationType> getTypesFor(DegreeType degreeType) {
        if (degreeType.isEmpty()) {
            return Arrays.asList(INSTITUTION, SON_OF_DECORATED_MILITARY, SOCIAL_SHARE_GRANT_OWNER, DIRECTIVE_COUNCIL_AUTHORIZATION);
        }
        if (degreeType.isAdvancedSpecializationDiploma()) {
            return Arrays.asList(INSTITUTION, OTHER_INSTITUTION, PALOP_TEACHER);
        }
        if (degreeType.isAdvancedFormationDiploma()) {
            return Arrays.asList(INSTITUTION, INSTITUTION_GRANT_OWNER, OTHER_INSTITUTION, PALOP_TEACHER, STUDENT_TEACH, DIRECTIVE_COUNCIL_AUTHORIZATION);
        }
        if (degreeType.isPreBolonhaDegree() || degreeType.isBolonhaMasterDegree() || degreeType.isBolonhaDegree() || degreeType.isIntegratedMasterDegree()) {
            return Arrays.asList(SON_OF_DECORATED_MILITARY, SOCIAL_SHARE_GRANT_OWNER, DIRECTIVE_COUNCIL_AUTHORIZATION, SEPARATION_CYCLES_AUTHORIZATION);
        }
        throw new RuntimeException("Unknown degree type");
    }

    public String localizedName(Locale locale) {
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)this.getQualifiedName(), (String[])new String[0]);
    }

    public String getLocalizedName() {
        return this.localizedName(I18N.getLocale());
    }
}

