/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events;

import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountType;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.events.EnrolmentOutOfPeriodEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.util.LabelFormatter;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class EnrolmentOutOfPeriodEvent
extends EnrolmentOutOfPeriodEvent_Base {
    protected EnrolmentOutOfPeriodEvent() {
    }

    public EnrolmentOutOfPeriodEvent(AdministrativeOffice administrativeOffice, Person person, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester, Integer numberOfDelayDays) {
        this();
        this.init(administrativeOffice, person, studentCurricularPlan, executionSemester, numberOfDelayDays);
    }

    private void init(AdministrativeOffice administrativeOffice, Person person, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester, Integer numberOfDelayDays) {
        this.checkParameters(administrativeOffice, studentCurricularPlan, executionSemester, numberOfDelayDays);
        super.init(administrativeOffice, EventType.ENROLMENT_OUT_OF_PERIOD, person);
        super.setExecutionPeriod(executionSemester);
        super.setStudentCurricularPlan(studentCurricularPlan);
        super.setNumberOfDelayDays(numberOfDelayDays);
    }

    private void checkParameters(AdministrativeOffice administrativeOffice, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester, Integer numberOfDelayDays) {
        if (administrativeOffice == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.events.EnrolmentOutOfPeriodEvent.administrativeOffice.cannot.be.null", new String[0]);
        }
        if (studentCurricularPlan == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.events.EnrolmentOutOfPeriodEvent.studentCurricularPlan.cannot.be.null", new String[0]);
        }
        if (executionSemester == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.events.EnrolmentOutOfPeriodEvent.executionPeriod.cannot.be.null", new String[0]);
        }
        if (numberOfDelayDays == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.events.EnrolmentOutOfPeriodEvent.numberOfDelayDays.cannot.be.null", new String[0]);
        }
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter().appendLabel(entryType.name(), "resources.EnumerationResources");
        this.addCommonDescription(labelFormatter);
        return labelFormatter;
    }

    public LabelFormatter getDescription() {
        LabelFormatter labelFormatter = super.getDescription();
        this.addCommonDescription(labelFormatter);
        return labelFormatter;
    }

    private void addCommonDescription(LabelFormatter labelFormatter) {
        labelFormatter.appendLabel(" (");
        labelFormatter.appendLabel(this.getDegree().getDegreeType().getName().getContent());
        labelFormatter.appendLabel(" - ");
        labelFormatter.appendLabel(this.getDegree().getNameFor(this.getExecutionPeriod().getExecutionYear()).getContent());
        labelFormatter.appendLabel(" - ");
        labelFormatter.appendLabel(this.getExecutionPeriod().getSemester().toString());
        labelFormatter.appendLabel("label.semester", "resources.ApplicationResources");
        labelFormatter.appendLabel("  " + this.getExecutionPeriod().getYear());
        labelFormatter.appendLabel(")");
    }

    private Degree getDegree() {
        return this.getStudentCurricularPlan().getDegree();
    }

    protected Account getFromAccount() {
        return this.getPerson().getAccountBy(AccountType.EXTERNAL);
    }

    public PostingRule getPostingRule() {
        return this.getAdministrativeOffice().getServiceAgreementTemplate().findPostingRuleByEventTypeAndDate(this.getEventType(), this.getWhenOccured());
    }

    public Account getToAccount() {
        return this.getAdministrativeOffice().getUnit().getAccountBy(AccountType.INTERNAL);
    }

    public boolean isEnrolmentOutOfPeriod() {
        return true;
    }

    static {
        StudentCurricularPlan.getRelationEnrolmentOutOfPeriodEventStudentCurricularPlan().addListener((RelationListener)new RelationAdapter<StudentCurricularPlan, EnrolmentOutOfPeriodEvent>(){

            public void beforeAdd(StudentCurricularPlan studentCurricularPlan, EnrolmentOutOfPeriodEvent enrolmentOutOfPeriodEvent) {
                Registration registration;
                if (studentCurricularPlan != null && enrolmentOutOfPeriodEvent != null && (registration = studentCurricularPlan.getRegistration()).containsEnrolmentOutOfPeriodEventFor(enrolmentOutOfPeriodEvent.getExecutionPeriod())) {
                    throw new DomainException("error.accounting.events.EnrolmentOutOfPeriodEvent.registration.already.contains.enrolment.out.of.period.event.for.period", studentCurricularPlan.getRegistration().getStudent().getNumber().toString(), studentCurricularPlan.getRegistration().getDegree().getPresentationName(), enrolmentOutOfPeriodEvent.getExecutionPeriod().getExecutionYear().getYear(), enrolmentOutOfPeriodEvent.getExecutionPeriod().getSemester().toString());
                }
            }
        });
    }
}

