/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.MarkSheetState;
import org.fenixedu.academic.domain.MarkSheet_Base;
import org.fenixedu.academic.domain.OldMarkSheet;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.curriculum.EnrollmentState;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.EnrolmentNotPayedException;
import org.fenixedu.academic.domain.exceptions.InDebtEnrolmentsException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetEnrolmentEvaluationBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.MarkSheetPredicates;
import org.fenixedu.academic.util.DateFormatUtil;
import org.fenixedu.academic.util.EnrolmentEvaluationState;
import org.fenixedu.academic.util.FenixDigestUtils;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.YearMonthDay;

public class MarkSheet
extends MarkSheet_Base {
    private static final Comparator<MarkSheet> COMPARATOR_BY_EVALUATION_DATE = new Comparator<MarkSheet>(){

        @Override
        public int compare(MarkSheet o1, MarkSheet o2) {
            if (o1.getEvaluationDateDateTime() == null && o2.getEvaluationDateDateTime() == null) {
                return 0;
            }
            if (o1.getEvaluationDateDateTime() == null) {
                return -1;
            }
            if (o2.getEvaluationDateDateTime() == null) {
                return 1;
            }
            return o1.getEvaluationDateDateTime().compareTo((ReadableInstant)o2.getEvaluationDateDateTime());
        }
    };
    private static final Comparator<MarkSheet> COMPARATOR_BY_CREATION_DATE = new Comparator<MarkSheet>(){

        @Override
        public int compare(MarkSheet o1, MarkSheet o2) {
            if (o1.getCreationDateDateTime() == null && o2.getCreationDateDateTime() == null) {
                return 0;
            }
            if (o1.getCreationDateDateTime() == null) {
                return -1;
            }
            if (o2.getCreationDateDateTime() == null) {
                return 1;
            }
            return o1.getCreationDateDateTime().compareTo((ReadableInstant)o2.getCreationDateDateTime());
        }
    };
    public static final Comparator<MarkSheet> COMPARATOR_BY_EVALUATION_DATE_AND_ID = new Comparator<MarkSheet>(){

        @Override
        public final int compare(MarkSheet o1, MarkSheet o2) {
            ComparatorChain comparatorChain = new ComparatorChain();
            comparatorChain.addComparator(COMPARATOR_BY_EVALUATION_DATE);
            comparatorChain.addComparator(DomainObjectUtil.COMPARATOR_BY_ID);
            return comparatorChain.compare((Object)o1, (Object)o2);
        }
    };
    public static final Comparator<MarkSheet> COMPARATOR_BY_EVALUATION_DATE_AND_CREATION_DATE_AND_ID = new Comparator<MarkSheet>(){

        @Override
        public final int compare(MarkSheet o1, MarkSheet o2) {
            ComparatorChain comparatorChain = new ComparatorChain();
            comparatorChain.addComparator(COMPARATOR_BY_EVALUATION_DATE);
            comparatorChain.addComparator(COMPARATOR_BY_CREATION_DATE);
            comparatorChain.addComparator(DomainObjectUtil.COMPARATOR_BY_ID);
            return comparatorChain.compare((Object)o1, (Object)o2);
        }
    };

    protected MarkSheet() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setCreationDateDateTime(new DateTime());
        this.setPrinted(Boolean.FALSE);
    }

    private MarkSheet(CurricularCourse curricularCourse, ExecutionSemester executionSemester, Teacher responsibleTeacher, Date evaluationDate, EvaluationSeason season, MarkSheetState markSheetState, Boolean submittedByTeacher, Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeans, Person creator) {
        this();
        this.checkParameters(curricularCourse, executionSemester, responsibleTeacher, evaluationDate, season, markSheetState, evaluationBeans, creator);
        this.init(curricularCourse, executionSemester, responsibleTeacher, evaluationDate, season, markSheetState, submittedByTeacher, creator);
        if (this.hasMarkSheetState(MarkSheetState.RECTIFICATION_NOT_CONFIRMED)) {
            this.addEnrolmentEvaluationsWithoutResctrictions(responsibleTeacher, evaluationBeans, EnrolmentEvaluationState.TEMPORARY_OBJ);
        } else {
            this.addEnrolmentEvaluationsWithResctrictions(responsibleTeacher, evaluationBeans, EnrolmentEvaluationState.TEMPORARY_OBJ);
        }
        this.generateCheckSum();
    }

    public static MarkSheet createNormal(CurricularCourse curricularCourse, ExecutionSemester executionSemester, Teacher responsibleTeacher, Date evaluationDate, EvaluationSeason season, Boolean submittedByTeacher, Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeans, Person creator) {
        return new MarkSheet(curricularCourse, executionSemester, responsibleTeacher, evaluationDate, season, MarkSheetState.NOT_CONFIRMED, submittedByTeacher, evaluationBeans, creator);
    }

    public static MarkSheet createOldNormal(CurricularCourse curricularCourse, ExecutionSemester executionSemester, Teacher responsibleTeacher, Date evaluationDate, EvaluationSeason season, Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeans, Person creator) {
        return new OldMarkSheet(curricularCourse, executionSemester, responsibleTeacher, evaluationDate, season, MarkSheetState.NOT_CONFIRMED, evaluationBeans, creator);
    }

    public static MarkSheet createRectification(CurricularCourse curricularCourse, ExecutionSemester executionSemester, Teacher responsibleTeacher, Date evaluationDate, EvaluationSeason season, String reason, MarkSheetEnrolmentEvaluationBean evaluationBean, Person creator) {
        MarkSheet markSheet = new MarkSheet(curricularCourse, executionSemester, responsibleTeacher, evaluationDate, season, MarkSheetState.RECTIFICATION_NOT_CONFIRMED, Boolean.FALSE, evaluationBean != null ? Collections.singletonList(evaluationBean) : null, creator);
        markSheet.setReason(reason);
        return markSheet;
    }

    public static MarkSheet createOldRectification(CurricularCourse curricularCourse, ExecutionSemester executionSemester, Teacher responsibleTeacher, Date evaluationDate, EvaluationSeason season, String reason, MarkSheetEnrolmentEvaluationBean evaluationBean, Person creator) {
        List<MarkSheetEnrolmentEvaluationBean> beans = evaluationBean != null ? Collections.singletonList(evaluationBean) : null;
        OldMarkSheet markSheet = new OldMarkSheet(curricularCourse, executionSemester, responsibleTeacher, evaluationDate, season, MarkSheetState.RECTIFICATION_NOT_CONFIRMED, beans, creator);
        ((MarkSheet)((Object)markSheet)).setReason(reason);
        return markSheet;
    }

    private void checkParameters(CurricularCourse curricularCourse, ExecutionSemester executionSemester, Teacher responsibleTeacher, Date evaluationDate, EvaluationSeason season, MarkSheetState markSheetState, Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeans, Person creator) {
        if (curricularCourse == null || executionSemester == null || responsibleTeacher == null || evaluationDate == null || season == null || markSheetState == null || creator == null) {
            throw new DomainException("error.markSheet.invalid.arguments", new String[0]);
        }
        if (evaluationBeans == null || evaluationBeans.size() == 0) {
            throw new DomainException("error.markSheet.create.with.invalid.enrolmentEvaluations.number", new String[0]);
        }
        this.checkIfTeacherIsResponsibleOrCoordinator(curricularCourse, executionSemester, responsibleTeacher, season);
        this.checkIfEvaluationDateIsInExamsPeriod(curricularCourse.getDegreeCurricularPlan(), executionSemester, evaluationDate, season);
    }

    protected void checkIfTeacherIsResponsibleOrCoordinator(CurricularCourse curricularCourse, ExecutionSemester executionSemester, Teacher responsibleTeacher, EvaluationSeason season) throws DomainException {
        if (curricularCourse.isDissertation()) {
            if (RoleType.SCIENTIFIC_COUNCIL.isMember(responsibleTeacher.getPerson().getUser())) {
                return;
            }
            for (ExecutionCourse executionCourse : curricularCourse.getAssociatedExecutionCoursesSet()) {
                if (executionCourse.getExecutionPeriod().getExecutionYear() != executionSemester.getExecutionYear()) continue;
                for (Professorship professorship : executionCourse.getProfessorshipsSet()) {
                    if (!professorship.isResponsibleFor() || professorship.getTeacher() != responsibleTeacher) continue;
                    return;
                }
            }
        }
        if (season.isImprovement() && curricularCourse.getExecutionCoursesByExecutionPeriod(executionSemester).isEmpty() ? !responsibleTeacher.getPerson().isResponsibleOrCoordinatorFor(curricularCourse, executionSemester.getPreviousExecutionPeriod()) && !responsibleTeacher.getPerson().isResponsibleOrCoordinatorFor(curricularCourse, executionSemester.getPreviousExecutionPeriod().getPreviousExecutionPeriod()) && !responsibleTeacher.getPerson().isResponsibleOrCoordinatorFor(curricularCourse, executionSemester.getPreviousExecutionPeriod().getPreviousExecutionPeriod().getPreviousExecutionPeriod()) : !responsibleTeacher.getPerson().isResponsibleOrCoordinatorFor(curricularCourse, executionSemester)) {
            throw new DomainException("error.teacherNotResponsibleOrNotCoordinator", new String[0]);
        }
    }

    protected void checkIfEvaluationDateIsInExamsPeriod(DegreeCurricularPlan degreeCurricularPlan, ExecutionSemester executionSemester, Date evaluationDate, EvaluationSeason season) throws DomainException {
        ExecutionDegree executionDegree = degreeCurricularPlan.getExecutionDegreeByYear(executionSemester.getExecutionYear());
        if (executionDegree == null) {
            if (!season.isImprovement() || !degreeCurricularPlan.canSubmitImprovementMarkSheets(executionSemester.getExecutionYear())) {
                throw new DomainException("error.evaluationDateNotInExamsPeriod", new String[0]);
            }
        } else if (!(season.isSpecialAuthorization() || evaluationDate != null && season.getExamPeriods(executionDegree, executionSemester).anyMatch(o1 -> o1.nestedOccupationPeriodsContainsDay(YearMonthDay.fromDateFields((Date)evaluationDate))))) {
            String dateFormat = "dd/MM/yyyy";
            String period = season.getExamPeriods(executionDegree, executionSemester).map(o -> o.getStartYearMonthDay().toString(dateFormat) + "-" + o.getEndYearMonthDay().toString(dateFormat)).collect(Collectors.joining(", "));
            if (!Strings.isNullOrEmpty((String)period)) {
                throw new DomainException("error.evaluationDateNotInExamsPeriod.withEvaluationDateAndPeriodDates", DateFormatUtil.format(dateFormat, evaluationDate), period);
            }
            throw new DomainException("error.evaluationDateNotInExamsPeriod", new String[0]);
        }
    }

    private ExecutionDegree getExecutionDegree(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return curricularCourse.getDegreeCurricularPlan().getExecutionDegreeByYear(executionSemester.getExecutionYear());
    }

    protected void init(CurricularCourse curricularCourse, ExecutionSemester executionSemester, Teacher responsibleTeacher, Date evaluationDate, EvaluationSeason season, MarkSheetState markSheetState, Boolean submittedByTeacher, Person creator) {
        this.setMarkSheetState(markSheetState);
        this.setCurricularCourse(curricularCourse);
        this.setExecutionPeriod(executionSemester);
        this.setResponsibleTeacher(responsibleTeacher);
        this.setEvaluationDate(evaluationDate);
        this.setEvaluationSeason(season);
        this.setSubmittedByTeacher(submittedByTeacher);
        this.setCreator(creator);
    }

    private void addEnrolmentEvaluationsWithoutResctrictions(Teacher responsibleTeacher, Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeans, EnrolmentEvaluationState enrolmentEvaluationState) {
        AccessControl.check(this, MarkSheetPredicates.editPredicate);
        for (MarkSheetEnrolmentEvaluationBean evaluationBean : evaluationBeans) {
            this.checkIfEvaluationDateIsInExamsPeriod(this.getCurricularCourse().getDegreeCurricularPlan(), this.getExecutionPeriod(), evaluationBean.getEvaluationDate(), this.getEvaluationSeason());
            EnrolmentEvaluation enrolmentEvaluation = evaluationBean.getEnrolment().addNewEnrolmentEvaluation(enrolmentEvaluationState, this.getEvaluationSeason(), responsibleTeacher.getPerson(), evaluationBean.getGradeValue(), this.getCreationDate(), evaluationBean.getEvaluationDate(), this.getExecutionPeriod(), null);
            this.addEnrolmentEvaluations(enrolmentEvaluation);
        }
    }

    private void addEnrolmentEvaluationsWithResctrictions(Teacher responsibleTeacher, Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeans, EnrolmentEvaluationState enrolmentEvaluationState) {
        AccessControl.check(this, MarkSheetPredicates.editPredicate);
        Set<Enrolment> enrolmentsNotInAnyMarkSheet = this.getCurricularCourse().getEnrolmentsNotInAnyMarkSheet(this.getEvaluationSeason(), this.getExecutionPeriod());
        HashSet<Enrolment> notPayedEnrolments = new HashSet<Enrolment>();
        for (MarkSheetEnrolmentEvaluationBean evaluationBean : evaluationBeans) {
            if (enrolmentsNotInAnyMarkSheet.contains(evaluationBean.getEnrolment())) {
                try {
                    this.addEnrolmentEvaluationToMarkSheet(responsibleTeacher, enrolmentEvaluationState, evaluationBean);
                }
                catch (EnrolmentNotPayedException e) {
                    notPayedEnrolments.add(e.getEnrolment());
                }
                continue;
            }
            throw new DomainException("error.markSheet", new String[0]);
        }
    }

    private void addEnrolmentEvaluationToMarkSheet(Teacher responsibleTeacher, EnrolmentEvaluationState enrolmentEvaluationState, MarkSheetEnrolmentEvaluationBean evaluationBean) {
        AccessControl.check(this, MarkSheetPredicates.editPredicate);
        this.checkIfEvaluationDateIsInExamsPeriod(this.getCurricularCourse().getDegreeCurricularPlan(), this.getExecutionPeriod(), evaluationBean.getEvaluationDate(), this.getEvaluationSeason());
        EnrolmentEvaluation enrolmentEvaluation = evaluationBean.getEnrolment().getEnrolmentEvaluationBySeasonAndState(enrolmentEvaluationState, this.getEvaluationSeason()).orElse(null);
        if (enrolmentEvaluation == null) {
            enrolmentEvaluation = evaluationBean.getEnrolment().addNewEnrolmentEvaluation(enrolmentEvaluationState, this.getEvaluationSeason(), responsibleTeacher.getPerson(), evaluationBean.getGradeValue(), this.getCreationDate(), evaluationBean.getEvaluationDate(), this.getExecutionPeriod(), null);
        } else {
            enrolmentEvaluation.edit(responsibleTeacher.getPerson(), evaluationBean.getGradeValue(), this.getCreationDate(), evaluationBean.getEvaluationDate());
        }
        this.addEnrolmentEvaluations(enrolmentEvaluation);
    }

    protected boolean hasMarkSheetState(MarkSheetState markSheetState) {
        return this.getMarkSheetState() == markSheetState;
    }

    public boolean isNotConfirmed() {
        return this.hasMarkSheetState(MarkSheetState.NOT_CONFIRMED) || this.hasMarkSheetState(MarkSheetState.RECTIFICATION_NOT_CONFIRMED);
    }

    public boolean isConfirmed() {
        return this.hasMarkSheetState(MarkSheetState.CONFIRMED) || this.hasMarkSheetState(MarkSheetState.RECTIFICATION);
    }

    public boolean isRectification() {
        return this.hasMarkSheetState(MarkSheetState.RECTIFICATION) || this.hasMarkSheetState(MarkSheetState.RECTIFICATION_NOT_CONFIRMED);
    }

    public void editNormal(Teacher responsibleTeacher, Date newEvaluationDate) {
        AccessControl.check(this, MarkSheetPredicates.editPredicate);
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        if (this.hasMarkSheetState(MarkSheetState.RECTIFICATION_NOT_CONFIRMED)) {
            throw new DomainException("error.markSheet.wrong.edit.method", new String[0]);
        }
        this.checkIfTeacherIsResponsibleOrCoordinator(this.getCurricularCourse(), this.getExecutionPeriod(), responsibleTeacher, this.getEvaluationSeason());
        this.checkIfEvaluationDateIsInExamsPeriod(this.getCurricularCourse().getDegreeCurricularPlan(), this.getExecutionPeriod(), newEvaluationDate, this.getEvaluationSeason());
        Date oldEvaluationDate = this.getEvaluationDateDateTime().toDate();
        this.setResponsibleTeacher(responsibleTeacher);
        this.setEvaluationDate(newEvaluationDate);
        this.editMarkSheetEnrolmentEvaluationsWithSameEvaluationDate(responsibleTeacher, oldEvaluationDate, newEvaluationDate, this.getEnrolmentEvaluationsSet());
        this.generateCheckSum();
    }

    public void editRectification(MarkSheetEnrolmentEvaluationBean enrolmentEvaluationBean) {
        AccessControl.check(this, MarkSheetPredicates.editPredicate);
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        if (this.hasMarkSheetState(MarkSheetState.NOT_CONFIRMED)) {
            throw new DomainException("error.markSheet.wrong.edit.method", new String[0]);
        }
        if (enrolmentEvaluationBean == null) {
            throw new DomainException("error.markSheet.edit.with.invalid.enrolmentEvaluations.number", new String[0]);
        }
        this.editEnrolmentEvaluations(Collections.singletonList(enrolmentEvaluationBean));
        this.generateCheckSum();
    }

    private void editMarkSheetEnrolmentEvaluationsWithSameEvaluationDate(Teacher responsibleTeacher, Date oldEvaluationDate, Date newEvaluationDate, Set<EnrolmentEvaluation> enrolmentEvaluationsToEdit) {
        AccessControl.check(this, MarkSheetPredicates.editPredicate);
        String dateFormat = "dd/MM/yyyy";
        for (EnrolmentEvaluation enrolmentEvaluation : enrolmentEvaluationsToEdit) {
            if (DateFormatUtil.compareDates(dateFormat, enrolmentEvaluation.getExamDate(), oldEvaluationDate) != 0) continue;
            this.checkIfEvaluationDateIsInExamsPeriod(this.getCurricularCourse().getDegreeCurricularPlan(), this.getExecutionPeriod(), newEvaluationDate, this.getEvaluationSeason());
            enrolmentEvaluation.edit(responsibleTeacher.getPerson(), newEvaluationDate);
        }
    }

    public void editNormal(Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeansToEdit, Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeansToAppend, Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeansToRemove) {
        AccessControl.check(this, MarkSheetPredicates.editPredicate);
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        if (this.hasMarkSheetState(MarkSheetState.RECTIFICATION_NOT_CONFIRMED)) {
            throw new DomainException("error.markSheet.wrong.edit.method", new String[0]);
        }
        this.checkIfEnrolmentEvaluationsNumberIsValid(evaluationBeansToAppend, evaluationBeansToRemove);
        this.editEnrolmentEvaluations(evaluationBeansToEdit);
        this.removeEnrolmentEvaluations(evaluationBeansToRemove);
        this.appendEnrolmentEvaluations(evaluationBeansToAppend);
        this.generateCheckSum();
    }

    private void checkIfEnrolmentEvaluationsNumberIsValid(Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeansToAppend, Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeansToRemove) {
        if (evaluationBeansToAppend.size() == 0 && evaluationBeansToRemove.size() == this.getEnrolmentEvaluationsSet().size()) {
            throw new DomainException("error.markSheet.edit.with.invalid.enrolmentEvaluations.number", new String[0]);
        }
    }

    protected void editEnrolmentEvaluations(Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeansToEdit) {
        AccessControl.check(this, MarkSheetPredicates.editPredicate);
        for (MarkSheetEnrolmentEvaluationBean enrolmentEvaluationBean : evaluationBeansToEdit) {
            if (this.getEnrolmentEvaluationsSet().contains((Object)enrolmentEvaluationBean.getEnrolmentEvaluation())) {
                this.checkIfEvaluationDateIsInExamsPeriod(this.getCurricularCourse().getDegreeCurricularPlan(), this.getExecutionPeriod(), enrolmentEvaluationBean.getEvaluationDate(), this.getEvaluationSeason());
                EnrolmentEvaluation enrolmentEvaluation = enrolmentEvaluationBean.getEnrolmentEvaluation();
                enrolmentEvaluation.edit(this.getResponsibleTeacher().getPerson(), enrolmentEvaluationBean.getGradeValue(), new Date(), enrolmentEvaluationBean.getEvaluationDate());
                continue;
            }
            throw new DomainException("error.markSheet", new String[0]);
        }
    }

    private void removeEnrolmentEvaluations(Collection<MarkSheetEnrolmentEvaluationBean> enrolmentEvaluationBeansToRemove) {
        AccessControl.check(this, MarkSheetPredicates.editPredicate);
        for (MarkSheetEnrolmentEvaluationBean enrolmentEvaluationBean : enrolmentEvaluationBeansToRemove) {
            enrolmentEvaluationBean.getEnrolmentEvaluation().removeFromMarkSheet();
            enrolmentEvaluationBean.getEnrolmentEvaluation().setGrade(Grade.createEmptyGrade());
        }
    }

    protected void appendEnrolmentEvaluations(Collection<MarkSheetEnrolmentEvaluationBean> evaluationBeansToAppend) {
        this.addEnrolmentEvaluationsWithResctrictions(this.getResponsibleTeacher(), evaluationBeansToAppend, EnrolmentEvaluationState.TEMPORARY_OBJ);
    }

    public void confirm(Person validator) {
        AccessControl.check(this, MarkSheetPredicates.confirmPredicate);
        if (validator == null) {
            throw new DomainException("error.markSheet.invalid.arguments", new String[0]);
        }
        if (this.isNotConfirmed()) {
            this.setValidator(validator);
            HashSet<Enrolment> inDebtEnrolments = new HashSet<Enrolment>();
            for (EnrolmentEvaluation enrolmentEvaluation : this.getEnrolmentEvaluationsSet()) {
                try {
                    enrolmentEvaluation.confirmSubmission(this.getEnrolmentEvaluationStateToConfirm(), validator, "");
                }
                catch (EnrolmentNotPayedException e) {
                    inDebtEnrolments.add(e.getEnrolment());
                }
            }
            if (!inDebtEnrolments.isEmpty()) {
                throw new InDebtEnrolmentsException("EnrolmentEvaluation.cannot.set.grade.on.not.payed.enrolment.evaluation", inDebtEnrolments);
            }
        } else {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        this.setConfirmationDateDateTime(new DateTime());
        this.setMarkSheetState(this.getMarkSheetStateToConfirm());
    }

    protected MarkSheetState getMarkSheetStateToConfirm() {
        if (this.getMarkSheetState() == MarkSheetState.NOT_CONFIRMED) {
            return MarkSheetState.CONFIRMED;
        }
        return MarkSheetState.RECTIFICATION;
    }

    protected EnrolmentEvaluationState getEnrolmentEvaluationStateToConfirm() {
        if (this.getMarkSheetState() == MarkSheetState.NOT_CONFIRMED) {
            return EnrolmentEvaluationState.FINAL_OBJ;
        }
        return EnrolmentEvaluationState.RECTIFICATION_OBJ;
    }

    public boolean getCanBeDeleted() {
        return this.isNotConfirmed();
    }

    public void delete() {
        if (!this.getCanBeDeleted()) {
            throw new DomainException("error.markSheet.cannot.be.deleted", new String[0]);
        }
        this.setExecutionPeriod(null);
        this.setEvaluationSeason(null);
        this.setCurricularCourse(null);
        this.setResponsibleTeacher(null);
        this.setValidator(null);
        this.setCreator(null);
        if (this.hasMarkSheetState(MarkSheetState.RECTIFICATION_NOT_CONFIRMED)) {
            this.changeRectifiedEnrolmentEvaluationToPreviowsState();
            while (!this.getEnrolmentEvaluationsSet().isEmpty()) {
                ((EnrolmentEvaluation)((Object)this.getEnrolmentEvaluationsSet().iterator().next())).delete();
            }
        } else {
            while (!this.getEnrolmentEvaluationsSet().isEmpty()) {
                ((EnrolmentEvaluation)((Object)this.getEnrolmentEvaluationsSet().iterator().next())).removeFromMarkSheet();
            }
        }
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    private void changeRectifiedEnrolmentEvaluationToPreviowsState() {
        EnrolmentEvaluation enrolmentEvaluation;
        if (this.getEnrolmentEvaluationsSet().isEmpty()) {
            return;
        }
        enrolmentEvaluation.setEnrolmentEvaluationState((enrolmentEvaluation = ((EnrolmentEvaluation)((Object)this.getEnrolmentEvaluationsSet().iterator().next())).getRectified()).getMarkSheet().getMarkSheetState() == MarkSheetState.RECTIFICATION ? EnrolmentEvaluationState.RECTIFICATION_OBJ : EnrolmentEvaluationState.FINAL_OBJ);
    }

    protected void generateCheckSum() {
        if (this.isNotConfirmed()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getExecutionPeriod().getExecutionYear().getYear()).append(this.getExecutionPeriod().getSemester());
            stringBuilder.append(this.getResponsibleTeacher().getPerson().getUsername()).append(this.getEvaluationDateDateTime().toString("yyyy/MM/dd"));
            stringBuilder.append(this.getEvaluationSeason().getExternalId());
            for (EnrolmentEvaluation enrolmentEvaluation : this.getEnrolmentEvaluationsSortedByStudentNumber()) {
                stringBuilder.append(enrolmentEvaluation.getCheckSum());
            }
            this.setCheckSum(FenixDigestUtils.createDigest(stringBuilder.toString()));
        }
    }

    public Set<EnrolmentEvaluation> getEnrolmentEvaluationsSortedByStudentNumber() {
        TreeSet<EnrolmentEvaluation> enrolmentEvaluations = new TreeSet<EnrolmentEvaluation>(EnrolmentEvaluation.SORT_BY_STUDENT_NUMBER);
        enrolmentEvaluations.addAll(this.getEnrolmentEvaluationsSet());
        return enrolmentEvaluations;
    }

    public EnrolmentEvaluation getEnrolmentEvaluationByStudent(Student student) {
        for (EnrolmentEvaluation enrolmentEvaluation : this.getEnrolmentEvaluationsSet()) {
            if (!enrolmentEvaluation.getEnrolment().getStudentCurricularPlan().getRegistration().getStudent().equals((Object)student)) continue;
            return enrolmentEvaluation;
        }
        return null;
    }

    public void addEnrolmentEvaluations(EnrolmentEvaluation enrolmentEvaluations) {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.addEnrolmentEvaluations(enrolmentEvaluations);
    }

    public void removeCurricularCourse() {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setCurricularCourse(null);
    }

    public void removeValidator() {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setValidator(null);
    }

    public void removeCreator() {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setCreator(null);
    }

    public void removeEnrolmentEvaluations(EnrolmentEvaluation enrolmentEvaluations) {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.removeEnrolmentEvaluations(enrolmentEvaluations);
    }

    public void removeExecutionPeriod() {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setExecutionPeriod(null);
    }

    public void removeResponsibleTeacher() {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setResponsibleTeacher(null);
    }

    public void removeBennu() {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setRootDomainObject(null);
    }

    public void setCheckSum(String checkSum) {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setCheckSum(checkSum);
    }

    public void setConfirmationDate(Date confirmationDate) {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        if (confirmationDate == null) {
            this.setConfirmationDateDateTime(null);
        } else {
            this.setConfirmationDateDateTime(new DateTime(confirmationDate.getTime()));
        }
    }

    public void setCreationDate(Date creationDate) {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        if (creationDate == null) {
            this.setCreationDateDateTime(null);
        } else {
            this.setCreationDateDateTime(new DateTime(creationDate.getTime()));
        }
    }

    public void setCurricularCourse(CurricularCourse curricularCourse) {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setCurricularCourse(curricularCourse);
    }

    public void setValidator(Person validator) {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setValidator(validator);
    }

    public void setCreator(Person creator) {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setCreator(creator);
    }

    public void setEvaluationDate(Date evaluationDate) {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        if (evaluationDate == null) {
            this.setEvaluationDateDateTime(null);
        } else {
            this.setEvaluationDateDateTime(new DateTime(evaluationDate.getTime()));
        }
    }

    public void setExecutionPeriod(ExecutionSemester executionSemester) {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setExecutionPeriod(executionSemester);
    }

    public void setMarkSheetState(MarkSheetState markSheetState) {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setMarkSheetState(markSheetState);
    }

    public void setEvaluationSeason(EvaluationSeason evaluationSeason) {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setEvaluationSeason(evaluationSeason);
    }

    public void setResponsibleTeacher(Teacher responsibleTeacher) {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setResponsibleTeacher(responsibleTeacher);
    }

    public void setConfirmationDateDateTime(DateTime confirmationDateDateTime) {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setConfirmationDateDateTime(confirmationDateDateTime);
    }

    public void setCreationDateDateTime(DateTime creationDateDateTime) {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setCreationDateDateTime(creationDateDateTime);
    }

    public void setEvaluationDateDateTime(DateTime evaluationDateDateTime) {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setEvaluationDateDateTime(evaluationDateDateTime);
    }

    public void setReason(String reason) {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setReason(reason);
    }

    public void setSubmittedByTeacher(Boolean submittedByTeacher) {
        if (this.isConfirmed()) {
            throw new DomainException("error.markSheet.already.confirmed", new String[0]);
        }
        super.setSubmittedByTeacher(submittedByTeacher);
    }

    public String getPrettyCheckSum() {
        return FenixDigestUtils.getPrettyCheckSum(this.getCheckSum());
    }

    public boolean canManage(Person person) {
        Set degreesForOperation = AcademicAccessRule.getDegreesAccessibleToFunction(AcademicOperationType.MANAGE_MARKSHEETS, person.getUser()).collect(Collectors.toSet());
        return degreesForOperation.contains(this.getCurricularCourse().getDegreeCurricularPlan().getDegree());
    }

    public void removeGrades(Collection<EnrolmentEvaluation> enrolmentEvaluations) {
        if (enrolmentEvaluations != null && enrolmentEvaluations.size() > 0) {
            if (this.getMarkSheetState() == MarkSheetState.CONFIRMED) {
                super.setMarkSheetState(MarkSheetState.NOT_CONFIRMED);
            }
            if (this.getMarkSheetState() == MarkSheetState.RECTIFICATION) {
                super.setMarkSheetState(MarkSheetState.RECTIFICATION_NOT_CONFIRMED);
            }
            this.setValidator(null);
            this.setConfirmationDateDateTime(null);
            for (EnrolmentEvaluation enrolmentEvaluation : this.getEnrolmentEvaluationsSet()) {
                if (enrolmentEvaluations.contains((Object)enrolmentEvaluation)) {
                    if (enrolmentEvaluation.getRectification() != null) {
                        throw new DomainException("error.enrolment.evaluation.has.rectification", new String[0]);
                    }
                    this.removeEvaluationFromMarkSheet(enrolmentEvaluation);
                    continue;
                }
                this.changeEvaluationStateToTemporaryState(enrolmentEvaluation);
            }
            this.generateCheckSum();
        }
    }

    private void removeEvaluationFromMarkSheet(EnrolmentEvaluation enrolmentEvaluation) {
        this.changeEvaluationStateToTemporaryState(enrolmentEvaluation);
        enrolmentEvaluation.setMarkSheet(null);
        enrolmentEvaluation.setGrade(Grade.createEmptyGrade());
        enrolmentEvaluation.setCheckSum(null);
        enrolmentEvaluation.setExamDateYearMonthDay(null);
        enrolmentEvaluation.setPerson(null);
        enrolmentEvaluation.setGradeAvailableDateYearMonthDay(null);
        enrolmentEvaluation.setPersonResponsibleForGrade(null);
        enrolmentEvaluation.setRectified(null);
    }

    private void changeEvaluationStateToTemporaryState(EnrolmentEvaluation enrolmentEvaluation) {
        enrolmentEvaluation.setEnrolmentEvaluationState(EnrolmentEvaluationState.TEMPORARY_OBJ);
        Enrolment enrolment = enrolmentEvaluation.getEnrolment();
        if (enrolment.getAllFinalEnrolmentEvaluations().isEmpty()) {
            enrolment.setEnrollmentState(EnrollmentState.ENROLLED);
        } else {
            enrolment.setEnrollmentState(enrolment.getFinalEnrolmentEvaluation().getEnrollmentStateByGrade());
        }
    }

    public boolean getCanRectify() {
        return this.isConfirmed() && MarkSheetPredicates.rectifyPredicate.evaluate(this);
    }

    public boolean getCanConfirm() {
        return this.isNotConfirmed() && !this.getEnrolmentEvaluationsSet().isEmpty() && MarkSheetPredicates.confirmPredicate.evaluate(this);
    }

    public boolean getCanEdit() {
        return this.isNotConfirmed() && MarkSheetPredicates.editPredicate.evaluate(this);
    }

    public boolean getCanRemoveGrades() {
        return this.isConfirmed() && MarkSheetPredicates.removeGradesPredicate.evaluate(this);
    }

    public boolean isDissertation() {
        return this.getCurricularCourse().isDissertation();
    }

    public String getStateDiscription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(BundleUtil.getString((String)"resources.EnumerationResources", (String)this.getMarkSheetState().getName(), (String[])new String[0]).trim());
        if (this.getSubmittedByTeacher().booleanValue()) {
            stringBuilder.append(" (").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.markSheet.submittedByTeacher", (String[])new String[0]).trim()).append(")");
        }
        return stringBuilder.toString();
    }

    public String getDegreeName() {
        return this.getCurricularCourse().getDegree().getNameFor(this.getExecutionPeriod()).getContent();
    }

    public String getDegreeCurricularPlanName() {
        return this.getCurricularCourse().getDegreeCurricularPlan().getName();
    }

    public String getCurricularCourseName() {
        return this.getCurricularCourse().getName(this.getExecutionPeriod());
    }

    public String getCurricularCourseAcronym() {
        return this.getCurricularCourse().getAcronym(this.getExecutionPeriod());
    }

    public boolean isFor(DegreeCurricularPlan dcp) {
        return this.getCurricularCourse().getDegreeCurricularPlan().equals((Object)dcp);
    }

    @Deprecated
    public Date getConfirmationDate() {
        DateTime dt = this.getConfirmationDateDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public Date getCreationDate() {
        DateTime dt = this.getCreationDateDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public Date getEvaluationDate() {
        DateTime dt = this.getEvaluationDateDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }
}

