/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExportGrouping;
import org.fenixedu.academic.domain.Grouping_Base;
import org.fenixedu.academic.domain.GroupsAndShiftsManagementLog;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Project;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftGroupingProperties;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.StudentGroup;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.util.EnrolmentGroupPolicyType;
import org.fenixedu.academic.util.ProposalState;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.fenixframework.FenixFramework;

public class Grouping
extends Grouping_Base {
    public static Comparator<Grouping> COMPARATOR_BY_ENROLMENT_BEGIN_DATE = new Comparator<Grouping>(){

        @Override
        public int compare(Grouping g1, Grouping g2) {
            return g1.getEnrolmentBeginDayDateDateTime().compareTo((ReadableInstant)g2.getEnrolmentBeginDayDateDateTime());
        }
    };

    public Grouping() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public Calendar getEnrolmentBeginDay() {
        if (this.getEnrolmentBeginDayDate() != null) {
            Calendar result = Calendar.getInstance();
            result.setTime(this.getEnrolmentBeginDayDate());
            return result;
        }
        return null;
    }

    public void setEnrolmentBeginDay(Calendar enrolmentBeginDay) {
        if (enrolmentBeginDay != null) {
            this.setEnrolmentBeginDayDate(enrolmentBeginDay.getTime());
        } else {
            this.setEnrolmentBeginDayDate(null);
        }
    }

    public Calendar getEnrolmentEndDay() {
        if (this.getEnrolmentEndDayDate() != null) {
            Calendar result = Calendar.getInstance();
            result.setTime(this.getEnrolmentEndDayDate());
            return result;
        }
        return null;
    }

    public void setEnrolmentEndDay(Calendar enrolmentEndDay) {
        if (enrolmentEndDay != null) {
            this.setEnrolmentEndDayDate(enrolmentEndDay.getTime());
        } else {
            this.setEnrolmentEndDayDate(null);
        }
    }

    public List<ExecutionCourse> getExecutionCourses() {
        ArrayList<ExecutionCourse> result = new ArrayList<ExecutionCourse>();
        for (ExportGrouping exportGrouping : this.getExportGroupingsSet()) {
            if (exportGrouping.getProposalState().getState() != 2 && exportGrouping.getProposalState().getState() != 1) continue;
            result.add(exportGrouping.getExecutionCourse());
        }
        return result;
    }

    public List<StudentGroup> getStudentGroupsWithoutShift() {
        ArrayList<StudentGroup> result = new ArrayList<StudentGroup>();
        for (StudentGroup studentGroup : this.getStudentGroupsSet()) {
            if (studentGroup.getShift() != null) continue;
            result.add(studentGroup);
        }
        return result;
    }

    public List<StudentGroup> getStudentGroupsWithShift() {
        ArrayList<StudentGroup> result = new ArrayList<StudentGroup>();
        for (StudentGroup studentGroup : this.getStudentGroupsSet()) {
            if (studentGroup.getShift() == null) continue;
            result.add(studentGroup);
        }
        return result;
    }

    public Integer getNumberOfStudentsNotInGrouping() {
        int numberOfStudents = 0;
        for (ExportGrouping exportGrouping : this.getExportGroupingsSet()) {
            if (exportGrouping.getProposalState().getState() != 2 && exportGrouping.getProposalState().getState() != 1) continue;
            for (Attends attend : exportGrouping.getExecutionCourse().getAttendsSet()) {
                if (this.getAttendsSet().contains((Object)attend)) continue;
                ++numberOfStudents;
            }
        }
        return numberOfStudents;
    }

    public void checkShiftCapacity(Shift shift) {
        List<StudentGroup> shiftStudentGroups = this.readAllStudentGroupsBy(shift);
        Integer groupMaximumNumber = this.getDifferentiatedCapacity() != false ? shift.getShiftGroupingProperties().getCapacity() : this.getGroupMaximumNumber();
        if (shiftStudentGroups != null && groupMaximumNumber != null && shiftStudentGroups.size() == groupMaximumNumber.intValue()) {
            throw new DomainException(((Object)((Object)this)).getClass().getName(), "error.shift.with.max.number.of.studentGroups");
        }
    }

    public Integer getNumberOfStudentsInGrouping() {
        return this.getAttendsSet().size();
    }

    public Attends getStudentAttend(Registration registration) {
        for (Attends attend : this.getAttendsSet()) {
            if (attend.getRegistration().getStudent() != registration.getStudent()) continue;
            return attend;
        }
        return null;
    }

    public Attends getStudentAttend(String studentUsername) {
        for (Attends attend : this.getAttendsSet()) {
            if (!attend.getRegistration().getPerson().getUsername().equals(studentUsername)) continue;
            return attend;
        }
        return null;
    }

    public StudentGroup readStudentGroupBy(Integer studentGroupNumber) {
        for (StudentGroup studentGroup : this.getStudentGroupsSet()) {
            if (!studentGroup.getGroupNumber().equals(studentGroupNumber)) continue;
            return studentGroup;
        }
        return null;
    }

    public List<StudentGroup> readAllStudentGroupsBy(Shift shift) {
        ArrayList<StudentGroup> result = new ArrayList<StudentGroup>();
        for (StudentGroup studentGroup : this.getStudentGroupsSet()) {
            if (studentGroup.getShift() != shift) continue;
            result.add(studentGroup);
        }
        return result;
    }

    public static Grouping create(String goupingName, Date enrolmentBeginDay, Date enrolmentEndDay, EnrolmentGroupPolicyType enrolmentGroupPolicyType, Integer groupMaximumNumber, Integer idealCapacity, Integer maximumCapacity, Integer minimumCapacity, String projectDescription, ShiftType shiftType, Boolean automaticEnrolment, Boolean differentiatedCapacity, ExecutionCourse executionCourse, Map<String, Integer> shiftCapacityMap) {
        if (goupingName == null || enrolmentBeginDay == null || enrolmentEndDay == null || enrolmentGroupPolicyType == null) {
            throw new NullPointerException();
        }
        Grouping.checkIfGroupingAlreadyExistInExecutionCourse(goupingName, executionCourse);
        Grouping grouping = new Grouping();
        grouping.setName(goupingName);
        grouping.setEnrolmentBeginDayDate(enrolmentBeginDay);
        grouping.setEnrolmentEndDayDate(enrolmentEndDay);
        grouping.setEnrolmentPolicy(enrolmentGroupPolicyType);
        grouping.setGroupMaximumNumber(groupMaximumNumber);
        grouping.setIdealCapacity(idealCapacity);
        grouping.setMaximumCapacity(maximumCapacity);
        grouping.setMinimumCapacity(minimumCapacity);
        grouping.setProjectDescription(projectDescription);
        grouping.setShiftType(shiftType);
        grouping.setAutomaticEnrolment(automaticEnrolment);
        grouping.setDifferentiatedCapacity(differentiatedCapacity);
        ExportGrouping exportGrouping = new ExportGrouping(grouping, executionCourse);
        exportGrouping.setProposalState(new ProposalState(1));
        Grouping.addGroupingToAttends(grouping, executionCourse.getAttendsSet());
        GroupsAndShiftsManagementLog.createLog(executionCourse, "resources.MessagingResources", "log.executionCourse.groupAndShifts.grouping.added", grouping.getName(), executionCourse.getNome(), executionCourse.getDegreePresentationString());
        if (differentiatedCapacity.booleanValue()) {
            Grouping.setDiferentiatedCapacityShiftsGroupingProperties(shiftType, shiftCapacityMap, grouping);
        }
        return grouping;
    }

    private static void addGroupingToAttends(Grouping grouping, Collection<Attends> attends) {
        for (Attends attend : attends) {
            attend.addGroupings(grouping);
        }
    }

    private static void checkIfGroupingAlreadyExistInExecutionCourse(String goupingName, ExecutionCourse executionCourse) {
        if (executionCourse.getGroupingByName(goupingName) != null) {
            throw new DomainException("error.exception.existing.groupProperties", new String[0]);
        }
    }

    public void edit(String goupingName, Date enrolmentBeginDay, Date enrolmentEndDay, EnrolmentGroupPolicyType enrolmentGroupPolicyType, Integer groupMaximumNumber, Integer idealCapacity, Integer maximumCapacity, Integer minimumCapacity, String projectDescription, ShiftType shiftType, Boolean automaticEnrolment, Boolean differentiatedCapacity, Map<String, Integer> shiftCapacityMap) {
        Set shiftGroupingProperties;
        if (goupingName == null || enrolmentBeginDay == null || enrolmentEndDay == null || enrolmentGroupPolicyType == null) {
            throw new NullPointerException();
        }
        this.checkIfGroupingAlreadyExists(goupingName);
        if (this.getDifferentiatedCapacity().booleanValue() && !differentiatedCapacity.booleanValue()) {
            if (!super.getStudentGroupsSet().isEmpty()) {
                throw new DomainException(((Object)((Object)this)).getClass().getName(), "error.groupProperties.edit.attendsSet.withGroups");
            }
            shiftGroupingProperties = this.getShiftGroupingPropertiesSet();
            for (ShiftGroupingProperties shiftGP : shiftGroupingProperties) {
                shiftGP.delete();
            }
        } else if (this.getDifferentiatedCapacity().booleanValue() && differentiatedCapacity.booleanValue() && this.isShiftTypeDifferent(shiftType)) {
            if (!super.getStudentGroupsSet().isEmpty()) {
                throw new DomainException(((Object)((Object)this)).getClass().getName(), "error.groupProperties.edit.attendsSet.withGroups");
            }
            shiftGroupingProperties = this.getShiftGroupingPropertiesSet();
            for (ShiftGroupingProperties shiftGP : shiftGroupingProperties) {
                shiftGP.delete();
            }
        }
        Integer groupMaximumNumberFix = groupMaximumNumber == null ? Integer.valueOf(Integer.MAX_VALUE) : groupMaximumNumber;
        if (!differentiatedCapacity.booleanValue() && groupMaximumNumberFix < this.getMaxStudentGroupsCount()) {
            throw new DomainException(((Object)((Object)this)).getClass().getName(), "error.groupProperties.edit.maxGroupCap.inferiorToExistingNumber");
        }
        this.setName(goupingName);
        this.setEnrolmentBeginDayDate(enrolmentBeginDay);
        this.setEnrolmentEndDayDate(enrolmentEndDay);
        this.setEnrolmentPolicy(enrolmentGroupPolicyType);
        this.setGroupMaximumNumber(groupMaximumNumber);
        this.setIdealCapacity(idealCapacity);
        this.setMaximumCapacity(maximumCapacity);
        this.setMinimumCapacity(minimumCapacity);
        this.setProjectDescription(projectDescription);
        this.setShiftType(shiftType);
        this.setAutomaticEnrolment(automaticEnrolment);
        this.setDifferentiatedCapacity(differentiatedCapacity);
        if (!differentiatedCapacity.booleanValue()) {
            Set shiftGroupingProperties2 = this.getShiftGroupingPropertiesSet();
            for (ShiftGroupingProperties shiftGP : shiftGroupingProperties2) {
                shiftGP.delete();
            }
        } else {
            Grouping.setDiferentiatedCapacityShiftsGroupingProperties(shiftType, shiftCapacityMap, this);
        }
        if (shiftType == null) {
            this.unEnrollStudentGroups(this.getStudentGroupsSet());
        }
        List<ExecutionCourse> ecs = this.getExecutionCourses();
        for (ExecutionCourse ec : ecs) {
            GroupsAndShiftsManagementLog.createLog(ec, "resources.MessagingResources", "log.executionCourse.groupAndShifts.grouping.edited", this.getName(), ec.getNome(), ec.getDegreePresentationString());
        }
    }

    private static void setDiferentiatedCapacityShiftsGroupingProperties(ShiftType shiftType, Map<String, Integer> shiftCapacityMap, Grouping grouping) {
        shiftCapacityMap.forEach((shiftID, capacity) -> {
            Shift shift = (Shift)FenixFramework.getDomainObject((String)shiftID);
            if (shift.getTypes().contains((Object)shiftType)) {
                if (capacity != null && grouping.getStudentGroupsIndexedByShift().get((Object)shift) != null && capacity < grouping.getStudentGroupsIndexedByShift().get((Object)shift).size()) {
                    throw new DomainException("error.groupProperties.edit.maxGroupCap.inferiorToExistingNumber", new String[0]);
                }
                if (shift.getShiftGroupingProperties() == null) {
                    shift.setShiftGroupingProperties(new ShiftGroupingProperties(shift, grouping, (Integer)capacity));
                } else {
                    shift.getShiftGroupingProperties().setCapacity((Integer)capacity);
                }
            }
        });
    }

    private boolean isShiftTypeEqual(ShiftType shiftType) {
        return shiftType != null && this.getShiftType() != null && this.getShiftType().compareTo(shiftType) == 0 || shiftType == null && this.getShiftType() == null;
    }

    private boolean isShiftTypeDifferent(ShiftType shiftType) {
        return shiftType == null && this.getShiftType() != null || shiftType != null && this.getShiftType() == null || this.getShiftType().compareTo(shiftType) != 0;
    }

    private Integer getMaxStudentGroupsCount() {
        HashMap<Shift, Integer> shiftCountMap = new HashMap<Shift, Integer>();
        for (StudentGroup studentGroup : super.getStudentGroupsSet()) {
            if (studentGroup.wasDeleted()) continue;
            Shift shift = studentGroup.getShift();
            int count = shiftCountMap.containsKey((Object)shift) ? (Integer)shiftCountMap.get((Object)shift) + 1 : 1;
            shiftCountMap.put(shift, count);
        }
        int max = 0;
        for (Integer i : shiftCountMap.values()) {
            if (i <= max) continue;
            max = i;
        }
        return max;
    }

    private void checkIfGroupingAlreadyExists(String groupingName) {
        if (!this.getName().equals(groupingName)) {
            for (ExecutionCourse executionCourse : this.getExecutionCourses()) {
                if (executionCourse.getGroupingByName(groupingName) == null) continue;
                throw new DomainException(((Object)((Object)this)).getClass().getName(), "error.exception.existing.groupProperties");
            }
        }
    }

    private void unEnrollStudentGroups(Collection<StudentGroup> studentGroups) {
        for (StudentGroup studentGroup : studentGroups) {
            studentGroup.setShift(null);
        }
    }

    public void createStudentGroup(Shift shift, Integer groupNumber, List<Registration> students) {
        if (groupNumber == null || students == null) {
            throw new NullPointerException();
        }
        if (this.readStudentGroupBy(groupNumber) != null) {
            throw new DomainException(((Object)((Object)this)).getClass().getName(), "error.invalidGroupNumber");
        }
        this.checkForStudentsInStudentGroupsAndGrouping(students);
        StudentGroup newStudentGroup = null;
        newStudentGroup = shift != null ? new StudentGroup(groupNumber, this, shift) : new StudentGroup(groupNumber, this);
        StringBuilder sbStudentNumbers = new StringBuilder("");
        sbStudentNumbers.setLength(0);
        for (Registration registration : students) {
            Attends attend = this.getStudentAttend(registration);
            newStudentGroup.addAttends(attend);
            if (sbStudentNumbers.length() != 0) {
                sbStudentNumbers.append(", " + registration.getNumber().toString());
                continue;
            }
            sbStudentNumbers.append(registration.getNumber().toString());
        }
        String labelKey = sbStudentNumbers.length() == 0 ? "log.executionCourse.groupAndShifts.grouping.group.added.empty" : "log.executionCourse.groupAndShifts.grouping.group.added";
        List<ExecutionCourse> ecs = this.getExecutionCourses();
        for (ExecutionCourse ec : ecs) {
            GroupsAndShiftsManagementLog.createLog(ec, "resources.MessagingResources", labelKey, groupNumber.toString(), this.getName(), Integer.toString(students.size()), sbStudentNumbers.toString(), ec.getNome(), ec.getDegreePresentationString());
        }
    }

    private void checkForStudentsInStudentGroupsAndGrouping(List<Registration> students) {
        for (Registration registration : students) {
            Attends attend = this.getStudentAttend(registration);
            for (StudentGroup studentGroup : this.getStudentGroupsSet()) {
                if (studentGroup.getAttendsSet().contains((Object)attend)) {
                    throw new DomainException(((Object)((Object)this)).getClass().getName(), "errors.existing.studentEnrolment");
                }
                if (this.getAttendsSet().contains((Object)attend)) continue;
                throw new DomainException(((Object)((Object)this)).getClass().getName(), "errors.notExisting.studentInGrouping");
            }
        }
    }

    public void delete() {
        if (!super.getStudentGroupsSet().isEmpty()) {
            throw new DomainException(((Object)((Object)this)).getClass().getName(), "");
        }
        if (this.getGroupingGroup() != null) {
            throw new DomainException("error.grouping.cannotDeleteGroupingUsedInAccessControl", new String[0]);
        }
        List<ExecutionCourse> ecs = this.getExecutionCourses();
        for (ExecutionCourse ec : ecs) {
            GroupsAndShiftsManagementLog.createLog(ec, "resources.MessagingResources", "log.executionCourse.groupAndShifts.grouping.removed", this.getName(), ec.getNome(), ec.getDegreePresentationString());
        }
        Set attends = this.getAttendsSet();
        ArrayList attendsAux = new ArrayList();
        attendsAux.addAll(attends);
        for (Attends attend : attendsAux) {
            attend.removeGroupings(this);
        }
        Set exportGroupings = this.getExportGroupingsSet();
        ArrayList exportGroupingsAux = new ArrayList();
        exportGroupingsAux.addAll(exportGroupings);
        for (ExportGrouping exportGrouping : exportGroupingsAux) {
            ExecutionCourse executionCourse = exportGrouping.getExecutionCourse();
            executionCourse.removeExportGroupings(exportGrouping);
            exportGrouping.delete();
        }
        for (ShiftGroupingProperties shiftGP : this.getShiftGroupingPropertiesSet()) {
            shiftGP.delete();
        }
        for (Project project : this.getProjectsSet()) {
            project.delete();
        }
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public int findMaxGroupNumber() {
        int max = 0;
        for (StudentGroup studentGroup : super.getStudentGroupsSet()) {
            max = Math.max(max, studentGroup.getGroupNumber());
        }
        return max;
    }

    public ExportGrouping getExportGrouping(ExecutionCourse executionCourse) {
        for (ExportGrouping exportGrouping : this.getExportGroupingsSet()) {
            if (exportGrouping.getExecutionCourse() != executionCourse) continue;
            return exportGrouping;
        }
        return null;
    }

    public boolean hasExportGrouping(ExecutionCourse executionCourse) {
        return this.getExportGrouping(executionCourse) != null;
    }

    public StudentGroup getStudentGroupByAttends(Attends attends) {
        for (StudentGroup studentGroup : this.getStudentGroupsSet()) {
            if (!studentGroup.getAttendsSet().contains((Object)attends)) continue;
            return studentGroup;
        }
        return null;
    }

    public Map<Shift, SortedSet<StudentGroup>> getStudentGroupsIndexedByShift() {
        TreeMap<Shift, SortedSet<StudentGroup>> map = new TreeMap<Shift, SortedSet<StudentGroup>>(Shift.SHIFT_COMPARATOR_BY_TYPE_AND_ORDERED_LESSONS);
        for (StudentGroup studentGroup : this.getStudentGroupsSet()) {
            TreeSet<StudentGroup> studentGroups;
            if (studentGroup.getShift() == null) continue;
            Shift shift = studentGroup.getShift();
            if (map.containsKey((Object)shift)) {
                studentGroups = (TreeSet<StudentGroup>)map.get((Object)shift);
            } else {
                studentGroups = new TreeSet<StudentGroup>(StudentGroup.COMPARATOR_BY_GROUP_NUMBER);
                map.put(shift, studentGroups);
            }
            studentGroups.add(studentGroup);
        }
        return map;
    }

    public SortedSet<StudentGroup> getStudentGroupsOrderedByGroupNumber() {
        TreeSet<StudentGroup> studentGroups = new TreeSet<StudentGroup>(StudentGroup.COMPARATOR_BY_GROUP_NUMBER);
        studentGroups.addAll(this.getStudentGroupsSet());
        return studentGroups;
    }

    public boolean isPersonTeacher(Person person) {
        for (ExecutionCourse ec : this.getExecutionCourses()) {
            for (Professorship professorship : ec.getProfessorshipsSet()) {
                if (professorship.getPerson() != person) continue;
                return true;
            }
        }
        return false;
    }

    public Set<StudentGroup> getStudentGroupsSet() {
        HashSet<StudentGroup> result = new HashSet<StudentGroup>();
        for (StudentGroup sg : super.getStudentGroupsSet()) {
            if (sg.wasDeleted()) continue;
            result.add(sg);
        }
        return Collections.unmodifiableSet(result);
    }

    public List<StudentGroup> getDeletedStudentGroups() {
        ArrayList<StudentGroup> result = new ArrayList<StudentGroup>();
        for (StudentGroup sg : super.getStudentGroupsSet()) {
            if (sg.getValid().booleanValue()) continue;
            result.add(sg);
        }
        return result;
    }

    @Deprecated
    public Date getEnrolmentBeginDayDate() {
        DateTime dt = this.getEnrolmentBeginDayDateDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setEnrolmentBeginDayDate(Date date) {
        if (date == null) {
            this.setEnrolmentBeginDayDateDateTime(null);
        } else {
            this.setEnrolmentBeginDayDateDateTime(new DateTime(date.getTime()));
        }
    }

    @Deprecated
    public Date getEnrolmentEndDayDate() {
        DateTime dt = this.getEnrolmentEndDayDateDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setEnrolmentEndDayDate(Date date) {
        if (date == null) {
            this.setEnrolmentEndDayDateDateTime(null);
        } else {
            this.setEnrolmentEndDayDateDateTime(new DateTime(date.getTime()));
        }
    }
}

