/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student.thesis;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.report.thesis.StudentThesisIdentificationDocument;
import org.fenixedu.academic.report.thesis.ThesisJuryReportDocument;
import org.fenixedu.academic.service.services.thesis.AcceptThesisDeclaration;
import org.fenixedu.academic.service.services.thesis.CreateThesisAbstractFile;
import org.fenixedu.academic.service.services.thesis.CreateThesisDissertationFile;
import org.fenixedu.academic.service.services.thesis.RejectThesisDeclaration;
import org.fenixedu.academic.ui.struts.action.commons.AbstractManageThesisDA;
import org.fenixedu.academic.ui.struts.action.student.StudentApplication;
import org.fenixedu.academic.ui.struts.action.student.thesis.DeclarationBean;
import org.fenixedu.academic.ui.struts.action.student.thesis.ThesisFileBean;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=StudentApplication.StudentSubmitApp.class, path="thesis", titleKey="label.student.thesis.submission")
@Mapping(path="/thesisSubmission", module="student")
@Forwards(value={@Forward(name="thesis-notFound", path="/student/thesis/notFound.jsp"), @Forward(name="thesis-showState", path="/student/thesis/showState.jsp"), @Forward(name="thesis-showUnavailable", path="/student/thesis/showUnavailable.jsp"), @Forward(name="thesis-submit", path="/student/thesis/submit.jsp"), @Forward(name="thesis-edit-abstract", path="/student/thesis/editAbstract.jsp"), @Forward(name="thesis-edit-keywords", path="/student/thesis/editKeywords.jsp"), @Forward(name="thesis-declaration", path="/student/thesis/declaration.jsp"), @Forward(name="thesis-declaration-view", path="/student/thesis/viewDeclaration.jsp"), @Forward(name="thesis-upload-dissertation", path="/student/thesis/uploadDissertation.jsp"), @Forward(name="thesis-upload-abstract", path="/student/thesis/uploadAbstract.jsp"), @Forward(name="thesis-list-enrolments", path="/student/thesis/listEnrolments.jsp"), @Forward(name="viewOperationsThesis", path="/student/thesis/viewOperationsThesis.jsp")})
public class ThesisSubmissionDA
extends AbstractManageThesisDA {
    public Student getStudent() {
        return Authenticate.getUser().getPerson().getStudent();
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("thesis", (Object)this.getThesis(request));
        return super.execute(mapping, actionForm, request, response);
    }

    @Override
    public Thesis getThesis(HttpServletRequest request) {
        Thesis thesis = null;
        String idString = request.getParameter("thesisId");
        if (idString == null) {
            Student student;
            Enrolment enrolment;
            thesis = (Thesis)((Object)request.getAttribute("thesis"));
            if (thesis == null && (enrolment = (student = this.getStudent()).getDissertationEnrolment()) != null) {
                thesis = enrolment.getThesis();
            }
        } else {
            thesis = (Thesis)FenixFramework.getDomainObject((String)idString);
        }
        return thesis;
    }

    @EntryPoint
    public ActionForward listThesis(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Student student = this.getStudent();
        TreeSet<Enrolment> enrolments = student.getDissertationEnrolments(null);
        request.setAttribute("enrolments", enrolments);
        return mapping.findForward("thesis-list-enrolments");
    }

    public ActionForward prepareThesisSubmissionByEnrolment(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Enrolment enrolment = (Enrolment)this.getDomainObject(request, "enrolmentId");
        if (enrolment == null) {
            request.setAttribute("noEnrolment", (Object)true);
            return mapping.findForward("thesis-notFound");
        }
        Thesis thesis = enrolment.getThesis();
        return this.prepareThesisSubmission(mapping, request, response, thesis);
    }

    public ActionForward prepareThesisSubmission(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        return this.prepareThesisSubmission(mapping, request, response, thesis);
    }

    private ActionForward prepareThesisSubmission(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, Thesis thesis) throws Exception {
        if (thesis == null || thesis.isDraft() || thesis.isSubmitted()) {
            request.setAttribute("noThesis", (Object)true);
            return mapping.findForward("thesis-notFound");
        }
        request.setAttribute("thesis", (Object)thesis);
        if (thesis.isWaitingConfirmation()) {
            this.setupStudentTodo(request, thesis);
            return mapping.findForward("thesis-submit");
        }
        if (thesis.isConfirmed() || thesis.isEvaluated()) {
            return mapping.findForward("thesis-showState");
        }
        return mapping.findForward("thesis-showUnavailable");
    }

    private void setupStudentTodo(HttpServletRequest request, Thesis thesis) {
        request.setAttribute("todo", thesis.getStudentConditions());
    }

    public ActionForward changeThesisDetails(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("changeDetails", (Object)true);
        return this.prepareThesisSubmission(mapping, actionForm, request, response);
    }

    public ActionForward editAbstract(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.editASCII(mapping, request, "thesis-edit-abstract");
    }

    public ActionForward editKeywords(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.editASCII(mapping, request, "thesis-edit-keywords");
    }

    public ActionForward editASCII(ActionMapping mapping, HttpServletRequest request, String forward) throws Exception {
        Thesis thesis = this.getThesis(request);
        if (thesis == null) {
            return mapping.findForward("thesis-notFound");
        }
        request.setAttribute("thesis", (Object)thesis);
        return mapping.findForward(forward);
    }

    public ActionForward viewDeclaration(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        if (thesis.isWaitingConfirmation()) {
            request.setAttribute("bean", (Object)new DeclarationBean(thesis));
            return mapping.findForward("thesis-declaration");
        }
        return mapping.findForward("thesis-declaration-view");
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActionForward changeDeclaration(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean accepted;
        boolean confirmation;
        Thesis thesis = this.getThesis(request);
        boolean bl = confirmation = request.getParameter("confirmReject") != null;
        if (confirmation) {
            RejectThesisDeclaration.runRejectThesisDeclaration(thesis);
            return this.prepareThesisSubmission(mapping, actionForm, request, response);
        }
        DeclarationBean bean = (DeclarationBean)this.getRenderedObject("declarationBean");
        boolean bl2 = accepted = request.getParameter("accept") != null;
        if (accepted) {
            if (bean.getVisibility() != null) {
                AcceptThesisDeclaration.runAcceptThesisDeclaration(thesis, bean.getVisibility(), bean.getAvailableAfter());
                return this.prepareThesisSubmission(mapping, actionForm, request, response);
            }
            this.addActionMessage("error", request, "error.student.thesis.declaration.visibility.required");
            request.setAttribute("bean", (Object)new DeclarationBean(thesis));
            return mapping.findForward("thesis-declaration");
        }
        if (thesis.getDissertation() == null && thesis.getExtendedAbstract() == null) {
            RejectThesisDeclaration.runRejectThesisDeclaration(thesis);
            return this.prepareThesisSubmission(mapping, actionForm, request, response);
        }
        request.setAttribute("confirmRejectWithFiles", (Object)true);
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("thesis-declaration");
    }

    public ActionForward prepareUploadDissertation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        request.setAttribute("fileBean", (Object)new ThesisFileBean(thesis));
        return mapping.findForward("thesis-upload-dissertation");
    }

    public ActionForward uploadDissertation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisFileBean bean = (ThesisFileBean)this.getRenderedObject();
        RenderUtils.invalidateViewState();
        if (!this.checkContentDisclaimer(request)) {
            this.addActionMessage("error", request, "label.student.thesis.upload.dissertation.message.content.decline.disclaimer");
            request.setAttribute("fileBean", (Object)bean);
            return mapping.findForward("thesis-upload-dissertation");
        }
        if (bean != null && bean.getFile() != null) {
            byte[] bytes = ByteStreams.toByteArray((InputStream)bean.getFile());
            try {
                CreateThesisDissertationFile.runCreateThesisDissertationFile(this.getThesis(request), bytes, bean.getSimpleFileName(), bean.getTitle(), bean.getSubTitle(), bean.getLanguage());
            }
            catch (DomainException e) {
                this.addActionMessage("error", request, e.getKey(), e.getArgs());
                return this.prepareUploadDissertation(mapping, actionForm, request, response);
            }
        }
        return this.prepareThesisSubmission(mapping, actionForm, request, response);
    }

    private boolean checkContentDisclaimer(HttpServletRequest request) {
        String contentDisclaimer = request.getParameter("contentDisclaimer");
        if ("checked".equals(contentDisclaimer) || "on".equals(contentDisclaimer)) {
            return true;
        }
        contentDisclaimer = (String)request.getAttribute("contentDisclaimer");
        return "checked".equals(contentDisclaimer) || "on".equals(contentDisclaimer);
    }

    public ActionForward removeDissertation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CreateThesisDissertationFile.runCreateThesisDissertationFile(this.getThesis(request), null, null, null, null, null);
        return this.prepareThesisSubmission(mapping, actionForm, request, response);
    }

    public ActionForward prepareUploadAbstract(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("fileBean", (Object)new ThesisFileBean());
        return mapping.findForward("thesis-upload-abstract");
    }

    public ActionForward uploadAbstract(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisFileBean bean = (ThesisFileBean)this.getRenderedObject();
        RenderUtils.invalidateViewState();
        if (bean != null && bean.getFile() != null) {
            byte[] bytes = ByteStreams.toByteArray((InputStream)bean.getFile());
            try {
                CreateThesisAbstractFile.runCreateThesisAbstractFile(this.getThesis(request), bytes, bean.getSimpleFileName(), null, null, null);
            }
            catch (DomainException e) {
                this.addActionMessage("error", request, e.getKey(), e.getArgs());
                return this.prepareUploadAbstract(mapping, actionForm, request, response);
            }
        }
        return this.prepareThesisSubmission(mapping, actionForm, request, response);
    }

    public ActionForward removeAbstract(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CreateThesisAbstractFile.runCreateThesisAbstractFile(this.getThesis(request), null, null, null, null, null);
        return this.prepareThesisSubmission(mapping, actionForm, request, response);
    }

    public ActionForward downloadIdentificationSheet(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        try {
            StudentThesisIdentificationDocument document = new StudentThesisIdentificationDocument(thesis);
            byte[] data = ReportsUtils.generateReport(document).getData();
            response.setContentLength(data.length);
            response.setContentType("application/pdf");
            response.addHeader("Content-Disposition", String.format("attachment; filename=%s.pdf", document.getReportFileName()));
            response.getOutputStream().write(data);
            return null;
        }
        catch (Exception e) {
            this.addActionMessage("error", request, "student.thesis.generate.identification.failed");
            return this.prepareThesisSubmission(mapping, actionForm, request, response);
        }
    }

    public ActionForward downloadJuryReportSheet(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        try {
            ThesisJuryReportDocument document = new ThesisJuryReportDocument(thesis);
            byte[] data = ReportsUtils.generateReport(document).getData();
            response.setContentLength(data.length);
            response.setContentType("application/pdf");
            response.addHeader("Content-Disposition", String.format("attachment; filename=%s.pdf", document.getReportFileName()));
            response.getOutputStream().write(data);
            return null;
        }
        catch (Exception e) {
            this.addActionMessage("error", request, "student.thesis.generate.juryreport.failed");
            return this.prepareThesisSubmission(mapping, actionForm, request, response);
        }
    }

    @Override
    public ActionForward editProposal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        throw new Error("this.cannot.be.called.here");
    }
}

